/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.metis.dereference.service.utils;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Function;

public final class GraphUtils {
    private GraphUtils() {
    }

    public static <K, V> Collection<V> breadthFirstSearch(K sourceNodeKey, V sourceNodeValue, int maxDistance, Function<K, V> valueResolver, BiConsumer<V, Set<K>> neighborExtractor) {
        HashMap<Object, V> allFoundNodes = new HashMap<Object, V>();
        allFoundNodes.put(sourceNodeKey, sourceNodeValue);
        HashSet<Object> nodesFoundDuringLastIteration = new HashSet<Object>();
        nodesFoundDuringLastIteration.add(sourceNodeKey);
        for (int distance = 0; distance < maxDistance; ++distance) {
            HashSet nodesFoundDuringThisIteration = new HashSet();
            nodesFoundDuringLastIteration.stream().map(allFoundNodes::get).forEach(value -> neighborExtractor.accept(value, nodesFoundDuringThisIteration));
            nodesFoundDuringLastIteration.clear();
            for (Object nodeKey : nodesFoundDuringThisIteration) {
                V value2;
                if (allFoundNodes.containsKey(nodeKey) || (value2 = valueResolver.apply(nodeKey)) == null) continue;
                nodesFoundDuringLastIteration.add(nodeKey);
                allFoundNodes.put(nodeKey, value2);
            }
        }
        return allFoundNodes.values();
    }
}

