/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.metis.dereference.service.dao;

import com.mongodb.MongoClient;
import eu.europeana.metis.dereference.Vocabulary;
import java.util.List;
import java.util.regex.Pattern;
import org.mongodb.morphia.Datastore;
import org.mongodb.morphia.Morphia;
import org.mongodb.morphia.query.Query;
import org.mongodb.morphia.query.UpdateOperations;

public class VocabularyDao {
    private Datastore ds;

    public VocabularyDao(MongoClient mongo, String db) {
        Morphia morphia = new Morphia();
        morphia.map(new Class[]{Vocabulary.class});
        this.ds = morphia.createDatastore(mongo, db);
    }

    public List<Vocabulary> getByUriSearch(String searchString) {
        Pattern pattern = Pattern.compile(Pattern.quote(searchString));
        return this.ds.find(Vocabulary.class).filter("uri", (Object)pattern).asList();
    }

    public String save(Vocabulary entity) {
        return (String)this.ds.save((Object)entity).getId();
    }

    public void delete(String name) {
        this.ds.delete(this.ds.createQuery(Vocabulary.class).filter("name", (Object)name));
    }

    public void update(Vocabulary entity) {
        Query query = this.ds.createQuery(Vocabulary.class).filter("name", (Object)entity.getName());
        UpdateOperations ops = this.ds.createUpdateOperations(Vocabulary.class);
        ops.set("iterations", (Object)entity.getIterations());
        if (entity.getRules() != null) {
            ops.set("rules", (Object)entity.getRules());
        } else {
            ops.unset("rules");
        }
        if (entity.getTypeRules() != null) {
            ops.set("typeRules", (Object)entity.getTypeRules());
        } else {
            ops.unset("typeRules");
        }
        if (entity.getType() != null) {
            ops.set("type", (Object)entity.getType());
        }
        ops.set("uri", (Object)entity.getUri());
        ops.set("xslt", (Object)entity.getXslt());
        ops.set("suffix", (Object)entity.getSuffix());
        this.ds.update(query, ops);
    }

    public List<Vocabulary> getAll() {
        return this.ds.find(Vocabulary.class).asList();
    }

    public Vocabulary get(String vocabularyId) {
        return (Vocabulary)this.ds.find(Vocabulary.class).filter("id", (Object)vocabularyId).get();
    }

    public Vocabulary findByName(String name) {
        return (Vocabulary)this.ds.find(Vocabulary.class).filter("name", (Object)name).get();
    }

    public void setDs(Datastore ds) {
        this.ds = ds;
    }
}

