/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.metis.dereference.service.dao;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import eu.europeana.metis.cache.redis.RedisProvider;
import eu.europeana.metis.dereference.ProcessedEntity;
import eu.europeana.metis.dereference.service.dao.AbstractDao;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import redis.clients.jedis.Jedis;

public class CacheDao
implements AbstractDao<ProcessedEntity> {
    private static final Logger LOGGER = LoggerFactory.getLogger(CacheDao.class);
    private final RedisProvider redisProvider;
    private final ObjectMapper om = new ObjectMapper();

    public CacheDao(RedisProvider redisProvider) {
        this.redisProvider = redisProvider;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public ProcessedEntity get(String resourceId) {
        try (Jedis jedis = this.redisProvider.getJedis();){
            String entity = jedis.get(resourceId);
            if (entity == null) return null;
            ProcessedEntity processedEntity = (ProcessedEntity)this.om.readValue(entity, ProcessedEntity.class);
            return processedEntity;
        }
        catch (IOException e) {
            LOGGER.warn("Unable to read entity " + resourceId, (Throwable)e);
        }
        return null;
    }

    @Override
    public void save(ProcessedEntity entity) {
        try (Jedis jedis = this.redisProvider.getJedis();){
            jedis.set(entity.getResourceId(), this.om.writeValueAsString((Object)entity));
        }
        catch (JsonProcessingException e) {
            LOGGER.warn("Unable to save entity", (Throwable)e);
        }
    }

    @Override
    public void delete(String resourceId) {
        try (Jedis jedis = this.redisProvider.getJedis();){
            jedis.del(resourceId);
        }
    }

    @Override
    public void update(String resourceId, ProcessedEntity entity) {
        this.save(entity);
    }

    public void emptyCache() {
        try (Jedis jedis = this.redisProvider.getJedis();){
            jedis.flushAll();
        }
    }
}

