/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.metis.dereference.service;

import eu.europeana.metis.dereference.OriginalEntity;
import eu.europeana.metis.dereference.Vocabulary;
import eu.europeana.metis.dereference.service.DereferencingManagementService;
import eu.europeana.metis.dereference.service.dao.CacheDao;
import eu.europeana.metis.dereference.service.dao.EntityDao;
import eu.europeana.metis.dereference.service.dao.VocabularyDao;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class MongoDereferencingManagementService
implements DereferencingManagementService {
    private static final Logger LOGGER = LoggerFactory.getLogger(MongoDereferencingManagementService.class);
    private final VocabularyDao vocabularyDao;
    private final CacheDao cacheDao;
    private final EntityDao entityDao;

    @Autowired
    public MongoDereferencingManagementService(VocabularyDao vocabularyDao, CacheDao cacheDao, EntityDao entityDao) {
        this.vocabularyDao = vocabularyDao;
        this.cacheDao = cacheDao;
        this.entityDao = entityDao;
    }

    @Override
    public void saveVocabulary(Vocabulary vocabulary) {
        this.vocabularyDao.save(vocabulary);
        LOGGER.info("Saved vocabulary with name: {}", (Object)vocabulary.getName());
    }

    @Override
    public void updateVocabulary(Vocabulary vocabulary) {
        this.vocabularyDao.update(vocabulary);
        this.cacheDao.emptyCache();
        LOGGER.info("Updated vocabulary with name: {}", (Object)vocabulary.getName());
    }

    @Override
    public void deleteVocabulary(String name) {
        this.vocabularyDao.delete(name);
        this.cacheDao.emptyCache();
        LOGGER.info("Deleted vocabulary with name: {}", (Object)name);
    }

    @Override
    public List<Vocabulary> getAllVocabularies() {
        return this.vocabularyDao.getAll();
    }

    @Override
    public void removeEntity(String uri) {
        this.cacheDao.delete(uri);
        this.entityDao.delete(uri);
    }

    @Override
    public void updateEntity(String uri, String xml) {
        this.cacheDao.delete(uri);
        OriginalEntity entity = new OriginalEntity();
        entity.setURI(uri);
        entity.setXml(xml);
        this.entityDao.update(uri, entity);
    }

    @Override
    public Vocabulary findByName(String name) {
        return this.vocabularyDao.findByName(name);
    }

    @Override
    public void emptyCache() {
        this.cacheDao.emptyCache();
    }
}

