/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.metis.dereference.service;

import eu.europeana.enrichment.api.external.model.Concept;
import eu.europeana.enrichment.api.external.model.EnrichmentBase;
import eu.europeana.enrichment.api.external.model.EnrichmentResultList;
import eu.europeana.enrichment.api.external.model.Part;
import eu.europeana.enrichment.api.external.model.Place;
import eu.europeana.enrichment.api.external.model.Resource;
import eu.europeana.enrichment.api.external.model.Timespan;
import eu.europeana.enrichment.rest.client.EnrichmentClient;
import eu.europeana.metis.dereference.ProcessedEntity;
import eu.europeana.metis.dereference.Vocabulary;
import eu.europeana.metis.dereference.service.DereferenceService;
import eu.europeana.metis.dereference.service.dao.CacheDao;
import eu.europeana.metis.dereference.service.dao.VocabularyDao;
import eu.europeana.metis.dereference.service.utils.GraphUtils;
import eu.europeana.metis.dereference.service.utils.IncomingRecordToEdmConverter;
import eu.europeana.metis.dereference.service.utils.RdfRetriever;
import eu.europeana.metis.dereference.service.utils.VocabularyCandidates;
import java.io.Reader;
import java.io.StringReader;
import java.net.URISyntaxException;
import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Stream;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.transform.TransformerException;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class MongoDereferenceService
implements DereferenceService {
    private static final Logger LOGGER = LoggerFactory.getLogger(MongoDereferenceService.class);
    private final RdfRetriever retriever;
    private final CacheDao cacheDao;
    private final VocabularyDao vocabularyDao;
    private final EnrichmentClient enrichmentClient;

    @Autowired
    public MongoDereferenceService(RdfRetriever retriever, CacheDao cacheDao, VocabularyDao vocabularyDao, EnrichmentClient enrichmentClient) {
        this.retriever = retriever;
        this.cacheDao = cacheDao;
        this.vocabularyDao = vocabularyDao;
        this.enrichmentClient = enrichmentClient;
    }

    @Override
    public EnrichmentResultList dereference(String resourceId) throws TransformerException, JAXBException, URISyntaxException {
        if (resourceId == null) {
            throw new IllegalArgumentException("Parameter resourceId cannot be null.");
        }
        EnrichmentBase enrichedEntity = this.enrichmentClient.getByUri(resourceId);
        Collection<EnrichmentBase> resultList = enrichedEntity == null ? this.dereferenceFromSource(resourceId) : Collections.singleton(enrichedEntity);
        return new EnrichmentResultList(resultList);
    }

    private Collection<EnrichmentBase> dereferenceFromSource(String resourceId) throws JAXBException, TransformerException, URISyntaxException {
        Pair<EnrichmentBase, Vocabulary> resource = this.retrieveCachedEntity(resourceId);
        if (resource == null) {
            return Collections.emptyList();
        }
        Function<String, EnrichmentBase> valueResolver = key -> {
            try {
                Pair<EnrichmentBase, Vocabulary> result = this.retrieveCachedEntity((String)key);
                return result == null ? null : (EnrichmentBase)result.getLeft();
            }
            catch (URISyntaxException | JAXBException | TransformerException e) {
                LOGGER.warn("Problem occurred while dereferencing broader resource " + key + ".", e);
                return null;
            }
        };
        int iterations = ((Vocabulary)resource.getRight()).getIterations();
        Collection<Object> result = iterations > 0 ? GraphUtils.breadthFirstSearch(resourceId, resource.getLeft(), ((Vocabulary)resource.getRight()).getIterations(), valueResolver, this::extractBroaderResources) : Collections.singleton(resource.getLeft());
        return result;
    }

    private void extractBroaderResources(EnrichmentBase resource, Set<String> destination) {
        Stream<String> resourceIdStream = resource instanceof Concept ? MongoDereferenceService.getStream(((Concept)resource).getBroader()).map(Resource::getResource) : (resource instanceof Timespan ? MongoDereferenceService.getStream(((Timespan)resource).getIsPartOfList()).map(Part::getResource) : (resource instanceof Place ? MongoDereferenceService.getStream(((Place)resource).getIsPartOfList()).map(Part::getResource) : Stream.empty()));
        resourceIdStream.filter(Objects::nonNull).forEach(destination::add);
    }

    private static <T> Stream<T> getStream(Collection<T> collection) {
        return collection == null ? Stream.empty() : collection.stream();
    }

    private Pair<EnrichmentBase, Vocabulary> retrieveCachedEntity(String resourceId) throws JAXBException, TransformerException, URISyntaxException {
        ImmutablePair result;
        Pair<String, Vocabulary> transformedEntity;
        ProcessedEntity cachedEntity = this.cacheDao.get(resourceId);
        String entityString = null;
        Vocabulary vocabulary = null;
        if (cachedEntity != null) {
            entityString = cachedEntity.getXml();
            vocabulary = cachedEntity.getVocabularyId() == null ? null : this.vocabularyDao.get(cachedEntity.getVocabularyId());
        }
        VocabularyCandidates candidates = VocabularyCandidates.findVocabulariesForUrl(resourceId, this.vocabularyDao::getByUriSearch);
        if (entityString != null && vocabulary == null) {
            vocabulary = candidates.findVocabularyWithoutTypeRules();
        }
        if ((entityString == null || vocabulary == null) && (transformedEntity = this.retrieveTransformedEntity(resourceId, candidates)) != null) {
            entityString = (String)transformedEntity.getLeft();
            vocabulary = (Vocabulary)transformedEntity.getRight();
            ProcessedEntity entityToCache = new ProcessedEntity();
            entityToCache.setXml(entityString);
            entityToCache.setResourceId(resourceId);
            entityToCache.setVocabularyId(vocabulary.getId());
            this.cacheDao.save(entityToCache);
        }
        if (entityString != null && vocabulary != null) {
            StringReader reader = new StringReader(entityString);
            JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{EnrichmentBase.class});
            EnrichmentBase resource = (EnrichmentBase)context.createUnmarshaller().unmarshal((Reader)reader);
            result = new ImmutablePair((Object)resource, (Object)vocabulary);
        } else {
            result = null;
        }
        return result;
    }

    private Pair<String, Vocabulary> retrieveTransformedEntity(String resourceId, VocabularyCandidates candidates) throws TransformerException {
        String originalEntity = this.retrieveOriginalEntity(resourceId, candidates);
        if (originalEntity == null) {
            return null;
        }
        Vocabulary vocabulary = candidates.findVocabularyForType(originalEntity);
        if (vocabulary == null) {
            return null;
        }
        IncomingRecordToEdmConverter converter = new IncomingRecordToEdmConverter(vocabulary);
        String transformedEntity = converter.convert(originalEntity, resourceId);
        return new ImmutablePair((Object)transformedEntity, (Object)vocabulary);
    }

    private String retrieveOriginalEntity(String resourceId, VocabularyCandidates candidates) {
        if (candidates.isEmpty()) {
            return null;
        }
        String originalEntity = this.retriever.retrieve(resourceId, candidates.getCandidateSuffixes());
        if (originalEntity == null) {
            LOGGER.info("No entity XML for uri {}", (Object)resourceId);
        }
        return originalEntity;
    }
}

