/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.metis.dereference.rest.config;

import com.mongodb.client.MongoClient;
import eu.europeana.corelib.web.socks.SocksProxy;
import eu.europeana.metis.dereference.service.dao.ProcessedEntityDao;
import eu.europeana.metis.dereference.service.dao.VocabularyDao;
import eu.europeana.metis.mongo.connection.MongoClientProvider;
import eu.europeana.metis.mongo.connection.MongoProperties;
import java.util.Collections;
import javax.annotation.PreDestroy;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.PropertySource;
import org.springframework.context.support.PropertySourcesPlaceholderConfigurer;
import org.springframework.web.servlet.config.annotation.EnableWebMvc;
import org.springframework.web.servlet.config.annotation.ResourceHandlerRegistry;
import org.springframework.web.servlet.config.annotation.ViewControllerRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;
import springfox.documentation.builders.PathSelectors;
import springfox.documentation.builders.RequestHandlerSelectors;
import springfox.documentation.service.ApiInfo;
import springfox.documentation.service.Contact;
import springfox.documentation.spi.DocumentationType;
import springfox.documentation.spring.web.plugins.Docket;
import springfox.documentation.swagger2.annotations.EnableSwagger2;

@Configuration
@ComponentScan(basePackages={"eu.europeana.metis.dereference.rest", "eu.europeana.metis.dereference.rest.exceptions"})
@PropertySource(value={"classpath:dereferencing.properties"})
@EnableWebMvc
@EnableSwagger2
public class Application
implements WebMvcConfigurer,
InitializingBean {
    @Value(value="${socks.proxy.enabled}")
    private boolean socksProxyEnabled;
    @Value(value="${socks.proxy.host}")
    private String socksProxyHost;
    @Value(value="${socks.proxy.port}")
    private String socksProxyPort;
    @Value(value="${socks.proxy.username}")
    private String socksProxyUsername;
    @Value(value="${socks.proxy.password}")
    private String socksProxyPassword;
    @Value(value="${mongo.hosts}")
    private String[] mongoHosts;
    @Value(value="${mongo.port}")
    private int mongoPort;
    @Value(value="${mongo.username}")
    private String mongoUsername;
    @Value(value="${mongo.password}")
    private String mongoPassword;
    @Value(value="${mongo.application.name}")
    private String mongoApplicationName;
    @Value(value="${entity.db}")
    private String entityDb;
    @Value(value="${vocabulary.db}")
    private String vocabularyDb;
    private MongoClient mongoClientEntity;
    private MongoClient mongoClientVocabulary;

    public void afterPropertiesSet() {
        if (this.socksProxyEnabled) {
            new SocksProxy(this.socksProxyHost, this.socksProxyPort, this.socksProxyUsername, this.socksProxyPassword).init();
        }
        MongoProperties mongoProperties = new MongoProperties(IllegalArgumentException::new);
        mongoProperties.setMongoHosts(this.mongoHosts, new int[]{this.mongoPort});
        mongoProperties.setApplicationName(this.mongoApplicationName);
        this.mongoClientEntity = new MongoClientProvider(mongoProperties).createMongoClient();
        this.mongoClientVocabulary = new MongoClientProvider(mongoProperties).createMongoClient();
    }

    public void addResourceHandlers(ResourceHandlerRegistry registry) {
        registry.addResourceHandler(new String[]{"/swagger-ui/**"}).addResourceLocations(new String[]{"classpath:/META-INF/resources/webjars/springfox-swagger-ui/"}).resourceChain(false);
    }

    public void addViewControllers(ViewControllerRegistry registry) {
        registry.addRedirectViewController("/", "/swagger-ui/index.html");
    }

    MongoClient getEntityMongoClient() {
        return this.mongoClientEntity;
    }

    MongoClient getVocabularyMongoClient() {
        return this.mongoClientVocabulary;
    }

    @Bean
    ProcessedEntityDao getProcessedEntityDao() {
        return new ProcessedEntityDao(this.getEntityMongoClient(), this.entityDb);
    }

    @Bean
    VocabularyDao getVocabularyDao() {
        return new VocabularyDao(this.getVocabularyMongoClient(), this.vocabularyDb);
    }

    @Bean
    public static PropertySourcesPlaceholderConfigurer propertySourcesPlaceholderConfigurer() {
        return new PropertySourcesPlaceholderConfigurer();
    }

    @PreDestroy
    public void close() {
        if (this.mongoClientVocabulary != null) {
            this.mongoClientVocabulary.close();
        }
        if (this.mongoClientEntity != null) {
            this.mongoClientEntity.close();
        }
    }

    @Bean
    public Docket api() {
        return new Docket(DocumentationType.SWAGGER_2).useDefaultResponseMessages(false).select().apis(RequestHandlerSelectors.any()).paths(PathSelectors.regex((String)"/.*")).build().apiInfo(this.apiInfo());
    }

    private ApiInfo apiInfo() {
        return new ApiInfo("Dereference REST API", "Dereference REST API for Europeana", "v1", "API TOS", new Contact("development", "europeana.eu", "development@europeana.eu"), "EUPL Licence v1.2", "https://joinup.ec.europa.eu/collection/eupl/eupl-text-eupl-12", Collections.emptyList());
    }
}

