/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.metis.dereference.rest;

import eu.europeana.metis.dereference.Vocabulary;
import eu.europeana.metis.dereference.service.DereferencingManagementService;
import eu.europeana.metis.dereference.vocimport.exception.VocabularyImportException;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@Api(value="/")
public class DereferencingManagementController {
    private static final Logger LOGGER = LoggerFactory.getLogger(DereferencingManagementController.class);
    private final DereferencingManagementService service;

    @Autowired
    public DereferencingManagementController(DereferencingManagementService service) {
        this.service = service;
    }

    @GetMapping(value={"/vocabularies"}, produces={"application/json"})
    @ResponseBody
    @ApiOperation(value="Retrieve all the vocabularies", response=List.class)
    public List<Vocabulary> getAllVocabularies() {
        return this.service.getAllVocabularies();
    }

    @DeleteMapping(value={"/cache"})
    @ResponseBody
    @ApiOperation(value="Empty the cache")
    public void emptyCache() {
        this.service.emptyCache();
    }

    @PostMapping(value={"/load_vocabularies"})
    @ResponseBody
    @ApiOperation(value="Load and replace the vocabularies listed by the given vocabulary directory. Does NOT purge the cache.")
    @ApiResponses(value={@ApiResponse(code=200, message="Vocabularies loaded successfully."), @ApiResponse(code=400, message="Bad request parameters."), @ApiResponse(code=502, message="Problem accessing vocabulary repository.")})
    public ResponseEntity loadVocabularies(@ApiParam(value="directory_url") @RequestParam(value="directory_url") String directoryUrl) {
        try {
            this.service.loadVocabularies(new URI(directoryUrl));
            return ResponseEntity.ok().build();
        }
        catch (URISyntaxException e) {
            LOGGER.warn("Could not load vocabularies", (Throwable)e);
            return ResponseEntity.badRequest().body((Object)e.getMessage());
        }
        catch (VocabularyImportException e) {
            LOGGER.warn("Could not load vocabularies", (Throwable)e);
            return ResponseEntity.status((HttpStatus)HttpStatus.BAD_GATEWAY).body((Object)e.getMessage());
        }
    }
}

