/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.metis.dereference.rest.exceptions;

import eu.europeana.metis.dereference.rest.exceptions.RestResponseExceptionHandler;
import java.net.URISyntaxException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;

@ControllerAdvice
public class RestResponseExceptionHandler {
    @ResponseBody
    @ExceptionHandler(value={Exception.class})
    public ServerError handleResponse(HttpServletResponse response, HttpServletRequest req, Exception exception) {
        ResponseStatus annotationResponseStatus = (ResponseStatus)AnnotationUtils.findAnnotation(exception.getClass(), ResponseStatus.class);
        HttpStatus status = annotationResponseStatus == null ? HttpStatus.INTERNAL_SERVER_ERROR : annotationResponseStatus.value();
        response.setStatus(status.value());
        return new ServerError(exception.getMessage());
    }

    @ResponseBody
    @ExceptionHandler(value={URISyntaxException.class})
    public ServerError handleResponseURISystax(HttpServletResponse response, HttpServletRequest req, Exception exception) {
        response.setStatus(HttpStatus.BAD_REQUEST.value());
        return new ServerError(exception.getMessage());
    }
}

