/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.metis.dereference.rest.controller;

import eu.europeana.enrichment.api.external.model.EnrichmentResultBaseWrapper;
import eu.europeana.enrichment.api.external.model.EnrichmentResultList;
import eu.europeana.metis.dereference.DereferenceResult;
import eu.europeana.metis.dereference.rest.exceptions.DereferenceException;
import eu.europeana.metis.dereference.service.DereferenceService;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

/*
 * Exception performing whole class analysis ignored.
 */
@RestController
public class DereferencingController {
    private final DereferenceService dereferenceService;

    @Autowired
    public DereferencingController(DereferenceService dereferenceService) {
        this.dereferenceService = dereferenceService;
    }

    @GetMapping(value={"/dereference"}, produces={"application/json", "application/xml"})
    @Operation(description="Dereference a URI", responses={@ApiResponse(responseCode="200")})
    public EnrichmentResultList dereference(@Parameter(name="uri") @RequestParam(value="uri") String resourceId) {
        try {
            DereferenceResult dereferenceResult = this.dereferenceInternal(resourceId);
            return new EnrichmentResultList(List.of(new EnrichmentResultBaseWrapper(dereferenceResult.getEnrichmentBasesAsList(), dereferenceResult.getDereferenceStatus())));
        }
        catch (RuntimeException e) {
            throw new DereferenceException(DereferencingController.generateExceptionMessage((String)resourceId, (Exception)e), (Throwable)e);
        }
    }

    private DereferenceResult dereferenceInternal(String resourceId) {
        return this.dereferenceService.dereference(resourceId);
    }

    private static String generateExceptionMessage(String resourceId, Exception e) {
        return String.format("Dereferencing failed for uri: %s with root cause: %s", resourceId.replaceAll("[\r\n\t]", ""), e.getMessage());
    }

    @PostMapping(value={"/dereference"}, consumes={"application/json"}, produces={"application/json", "application/xml"})
    @Operation(description="Dereference a list URI", responses={@ApiResponse(responseCode="200")})
    public EnrichmentResultList dereference(@RequestBody List<String> resourceIds) {
        try {
            return new EnrichmentResultList(resourceIds.stream().map(arg_0 -> this.dereferenceInternal(arg_0)).map(item -> new EnrichmentResultBaseWrapper(item.getEnrichmentBasesAsList(), item.getDereferenceStatus())).toList());
        }
        catch (RuntimeException e) {
            throw new DereferenceException(DereferencingController.generateExceptionMessage((String)String.join((CharSequence)",", resourceIds), (Exception)e), (Throwable)e);
        }
    }
}

