/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.metis.dereference.rest.controller;

import eu.europeana.metis.dereference.Vocabulary;
import eu.europeana.metis.dereference.rest.config.properties.MetisDereferenceConfigurationProperties;
import eu.europeana.metis.dereference.service.DereferencingManagementService;
import eu.europeana.metis.dereference.vocimport.exception.VocabularyImportException;
import eu.europeana.metis.exception.BadContentException;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class DereferencingManagementController {
    private static final Logger LOGGER = LoggerFactory.getLogger(DereferencingManagementController.class);
    private final DereferencingManagementService service;
    private final Set<String> allowedUrlDomains;

    @Autowired
    public DereferencingManagementController(DereferencingManagementService service, MetisDereferenceConfigurationProperties metisDereferenceConfigurationProperties) {
        this.service = service;
        this.allowedUrlDomains = new HashSet<String>(Set.of(metisDereferenceConfigurationProperties.getAllowedUrlDomains()));
    }

    @GetMapping(value={"/vocabularies"}, produces={"application/json"})
    @Operation(description="Retrieve all the vocabularies", responses={@ApiResponse(responseCode="200")})
    public List<Vocabulary> getAllVocabularies() {
        return this.service.getAllVocabularies();
    }

    @DeleteMapping(value={"/cache"})
    @Operation(description="Empty the cache")
    public void emptyCache() {
        this.service.emptyCache();
    }

    @DeleteMapping(value={"/cache/emptyxml"})
    @Operation(description="Empty the cache without XML representations")
    public void emptyCacheByEmptyXml() {
        this.service.purgeByNullOrEmptyXml();
    }

    @DeleteMapping(value={"/cache/resource"})
    @Operation(description="Empty the cache by resource Id")
    public void emptyCacheByResourceId(@Parameter(description="Id (URI) of resource to clear cache", required=true) @RequestParam(value="resourceId") String resourceId) {
        this.service.purgeByResourceId(resourceId);
    }

    @DeleteMapping(value={"/cache/vocabulary"})
    @Operation(description="Empty the cache by vocabulary Id")
    public void emptyCacheByVocabularyId(@Parameter(description="Id of vocabulary to clear cache", required=true) @RequestParam(value="vocabularyId") String vocabularyId) {
        this.service.purgeByVocabularyId(vocabularyId);
    }

    @PostMapping(value={"/load_vocabularies"})
    @Operation(description="Load and replace the vocabularies listed by the given vocabulary directory. Does NOT purge the cache.", responses={@ApiResponse(responseCode="200", description="Vocabularies loaded successfully."), @ApiResponse(responseCode="400", description="Bad request parameters."), @ApiResponse(responseCode="502", description="Problem accessing vocabulary repository.")})
    public ResponseEntity<String> loadVocabularies(@Parameter(name="directory_url") @RequestParam(value="directory_url") String directoryUrl) {
        try {
            Optional validatedLocationUrl = this.getValidatedLocationUrl(directoryUrl);
            if (validatedLocationUrl.isPresent()) {
                this.service.loadVocabularies((URL)validatedLocationUrl.get());
                return ResponseEntity.ok().build();
            }
            return ResponseEntity.status((HttpStatusCode)HttpStatus.BAD_REQUEST).body((Object)"The url of the directory to import is not valid.");
        }
        catch (BadContentException e) {
            LOGGER.warn("Could not load vocabularies", (Throwable)e);
            return ResponseEntity.status((HttpStatusCode)HttpStatus.BAD_REQUEST).body((Object)e.getMessage());
        }
        catch (VocabularyImportException e) {
            LOGGER.warn("Could not load vocabularies", (Throwable)e);
            return ResponseEntity.status((HttpStatusCode)HttpStatus.BAD_GATEWAY).body((Object)e.getMessage());
        }
    }

    private Optional<URL> getValidatedLocationUrl(String directoryUrl) throws BadContentException {
        try {
            URI uri = new URI(directoryUrl);
            String scheme = uri.getScheme();
            String remoteHost = uri.getHost();
            if ("https".equals(scheme) && this.allowedUrlDomains.contains(remoteHost)) {
                return Optional.of(uri.toURL());
            }
        }
        catch (IllegalArgumentException | MalformedURLException | URISyntaxException e) {
            throw new BadContentException(String.format("Provided directoryUrl '%s', failed to parse.", directoryUrl), (Throwable)e);
        }
        return Optional.empty();
    }
}

