/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.metis.dereference.rest.config;

import com.mongodb.client.MongoClient;
import eu.europeana.metis.dereference.rest.config.properties.MetisDereferenceConfigurationProperties;
import eu.europeana.metis.dereference.service.DereferenceService;
import eu.europeana.metis.dereference.service.DereferencingManagementService;
import eu.europeana.metis.dereference.service.MongoDereferenceService;
import eu.europeana.metis.dereference.service.MongoDereferencingManagementService;
import eu.europeana.metis.dereference.service.dao.ProcessedEntityDao;
import eu.europeana.metis.dereference.service.dao.VocabularyDao;
import eu.europeana.metis.dereference.vocimport.VocabularyCollectionImporterFactory;
import eu.europeana.metis.mongo.connection.MongoClientProvider;
import eu.europeana.metis.mongo.connection.MongoProperties;
import eu.europeana.metis.utils.CustomTruststoreAppender;
import eu.europeana.metis.utils.apm.ElasticAPMConfiguration;
import jakarta.annotation.PreDestroy;
import java.lang.invoke.MethodHandles;
import java.util.Set;
import metis.common.config.properties.TruststoreConfigurationProperties;
import metis.common.config.properties.mongo.MongoConfigurationProperties;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.scheduling.annotation.EnableScheduling;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.web.filter.ForwardedHeaderFilter;

/*
 * Exception performing whole class analysis ignored.
 */
@Configuration
@EnableConfigurationProperties(value={ElasticAPMConfiguration.class, TruststoreConfigurationProperties.class, MongoConfigurationProperties.class, MetisDereferenceConfigurationProperties.class})
@EnableScheduling
@ComponentScan(basePackages={"eu.europeana.metis.dereference.rest.controller", "eu.europeana.metis.dereference.rest.exceptions"})
public class ApplicationConfiguration {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final MongoClient mongoClient;
    private ProcessedEntityDao processedEntityDao;

    @Autowired
    public ApplicationConfiguration(TruststoreConfigurationProperties truststoreConfigurationProperties, MongoConfigurationProperties mongoConfigurationProperties) throws CustomTruststoreAppender.TrustStoreConfigurationException {
        ApplicationConfiguration.initializeTruststore((TruststoreConfigurationProperties)truststoreConfigurationProperties);
        this.mongoClient = ApplicationConfiguration.getMongoClient((MongoConfigurationProperties)mongoConfigurationProperties);
    }

    static void initializeTruststore(TruststoreConfigurationProperties truststoreConfigurationProperties) throws CustomTruststoreAppender.TrustStoreConfigurationException {
        if (StringUtils.isNotEmpty((CharSequence)truststoreConfigurationProperties.getPath()) && StringUtils.isNotEmpty((CharSequence)truststoreConfigurationProperties.getPassword())) {
            CustomTruststoreAppender.appendCustomTruststoreToDefault((String)truststoreConfigurationProperties.getPath(), (String)truststoreConfigurationProperties.getPassword());
            LOGGER.info("Custom truststore appended to default truststore");
        }
    }

    public static MongoClient getMongoClient(MongoConfigurationProperties mongoConfigurationProperties) {
        MongoProperties mongoProperties = new MongoProperties(IllegalArgumentException::new);
        mongoProperties.setAllProperties(mongoConfigurationProperties.getHosts(), mongoConfigurationProperties.getPorts(), mongoConfigurationProperties.getAuthenticationDatabase(), mongoConfigurationProperties.getUsername(), mongoConfigurationProperties.getPassword(), mongoConfigurationProperties.isEnableSsl(), MongoProperties.ReadPreferenceValue.PRIMARY_PREFERRED, mongoConfigurationProperties.getApplicationName());
        return new MongoClientProvider(mongoProperties).createMongoClient();
    }

    @Bean
    public DereferenceService getDereferenceService(ProcessedEntityDao processedEntityDao, VocabularyDao vocabularyDao) {
        return new MongoDereferenceService(processedEntityDao, vocabularyDao);
    }

    @Bean
    public DereferencingManagementService getDereferencingManagementService(ProcessedEntityDao processedEntityDao, VocabularyDao vocabularyDao, VocabularyCollectionImporterFactory vocabularyCollectionImporterFactory) {
        return new MongoDereferencingManagementService(vocabularyDao, processedEntityDao, vocabularyCollectionImporterFactory);
    }

    @Bean
    public VocabularyCollectionImporterFactory getVocabularyCollectionImporterFactory() {
        return new VocabularyCollectionImporterFactory();
    }

    @Bean
    ProcessedEntityDao getProcessedEntityDao(MongoConfigurationProperties mongoConfigurationProperties) {
        this.processedEntityDao = new ProcessedEntityDao(this.mongoClient, mongoConfigurationProperties.getDatabase());
        return this.processedEntityDao;
    }

    @Bean
    VocabularyDao getVocabularyDao(MongoConfigurationProperties mongoConfigurationProperties) {
        return new VocabularyDao(this.mongoClient, mongoConfigurationProperties.getDatabase());
    }

    @Bean
    Set<String> getAllowedUrlDomains(MetisDereferenceConfigurationProperties metisDereferenceConfigurationProperties) {
        return Set.of(metisDereferenceConfigurationProperties.getAllowedUrlDomains());
    }

    @Bean
    ForwardedHeaderFilter forwardedHeaderFilter() {
        return new ForwardedHeaderFilter();
    }

    @Scheduled(cron="${metis-dereference.getPurgeEmptyXmlFrequency}")
    public void dereferenceCacheNullOrEmpty() {
        this.processedEntityDao.purgeByNullOrEmptyXml();
    }

    @Scheduled(cron="${metis-dereference.getPurgeAllFrequency}")
    public void dereferenceCachePurgeAll() {
        this.processedEntityDao.purgeAll();
    }

    @PreDestroy
    public void close() {
        if (this.mongoClient != null) {
            this.mongoClient.close();
        }
    }
}

