/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.metis.dereference.rest;

import eu.europeana.metis.dereference.Vocabulary;
import eu.europeana.metis.dereference.service.DereferencingManagementService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;

@Controller
@Api(value="/")
public class DereferencingManagementController {
    private final DereferencingManagementService service;

    @Autowired
    public DereferencingManagementController(DereferencingManagementService service) {
        this.service = service;
    }

    @PostMapping(value={"/vocabulary"}, consumes={"application/json"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiOperation(value="Save a vocabulary")
    public void saveVocabulary(@ApiParam @RequestBody Vocabulary vocabulary) {
        this.service.saveVocabulary(vocabulary);
    }

    @PutMapping(value={"/vocabulary"}, consumes={"application/json"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiOperation(value="Update a vocabulary")
    public void updateVocabulary(@ApiParam @RequestBody Vocabulary vocabulary) {
        this.service.updateVocabulary(vocabulary);
    }

    @DeleteMapping(value={"/vocabulary/{name}"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiOperation(value="Delete a vocabulary")
    public void deleteVocabulary(@ApiParam(value="name") @PathVariable(value="name") String name) {
        this.service.deleteVocabulary(name);
    }

    @GetMapping(value={"/vocabulary/{name}"}, produces={"application/json"})
    @ResponseBody
    @ApiOperation(value="Retrieve a vocabulary by name")
    public Vocabulary getVocabulary(@ApiParam(value="name") @PathVariable(value="name") String name) {
        return this.service.findByName(name);
    }

    @GetMapping(value={"/vocabularies"}, produces={"application/json"})
    @ResponseBody
    @ApiOperation(value="Retrieve all the vocabularies", response=List.class)
    public List<Vocabulary> getAllVocabularies() {
        return this.service.getAllVocabularies();
    }

    @DeleteMapping(value={"/entity/{uri}"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiOperation(value="Delete an entity")
    public void deleteEntity(@ApiParam(value="uri") @PathVariable(value="uri") String uri) {
        try {
            this.service.removeEntity(URLDecoder.decode(uri, StandardCharsets.UTF_8.name()));
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException(e.getMessage(), e);
        }
    }

    @PutMapping(value={"/entity"})
    @ResponseBody
    @ApiOperation(value="Update an entity")
    public void updateEntity(@ApiParam(value="uri") @RequestParam(value="uri") String uri, @ApiParam(value="xml") @RequestParam(value="xml") String xml) {
        this.service.updateEntity(uri, xml);
    }

    @DeleteMapping(value={"/cache"})
    @ResponseBody
    @ApiOperation(value="Empty the cache")
    public void emptyCache() {
        this.service.emptyCache();
    }
}

