/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.metis.dereference.rest;

import eu.europeana.enrichment.api.external.model.EnrichmentResultList;
import eu.europeana.metis.dereference.rest.exceptions.DereferenceException;
import eu.europeana.metis.dereference.service.DereferenceService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.net.URISyntaxException;
import java.util.List;
import javax.xml.bind.JAXBException;
import javax.xml.transform.TransformerException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@Api(value="/")
public class DereferencingController {
    private static final Logger LOGGER = LoggerFactory.getLogger(DereferencingController.class);
    private final DereferenceService dereferenceService;

    @Autowired
    public DereferencingController(DereferenceService dereferenceService) {
        this.dereferenceService = dereferenceService;
    }

    @GetMapping(value={"/dereference"}, produces={"application/json", "application/xml"})
    @ResponseBody
    @ApiOperation(value="Dereference a URI", response=EnrichmentResultList.class)
    public EnrichmentResultList dereference(@ApiParam(value="uri") @RequestParam(value="uri") String resourceId) throws URISyntaxException {
        try {
            return this.dereferenceService.dereference(resourceId);
        }
        catch (RuntimeException | JAXBException | TransformerException e) {
            LOGGER.warn(String.format("Problem occurred while dereferencing resource %s.", resourceId.replaceAll("[\r\n]", "")), e);
            throw new DereferenceException(String.format("Dereferencing failed for uri: %s with root cause: %s", resourceId, e.getMessage()), e);
        }
    }

    @PostMapping(value={"/dereference"}, consumes={"application/json"}, produces={"application/json", "application/xml"})
    @ResponseBody
    @ApiOperation(value="Dereference a list URI", response=EnrichmentResultList.class)
    public EnrichmentResultList dereference(@RequestBody List<String> resourceIds) throws URISyntaxException {
        EnrichmentResultList dereferencedEntities = new EnrichmentResultList();
        for (String resourceId : resourceIds) {
            EnrichmentResultList result = this.dereference(resourceId);
            if (result == null) continue;
            dereferencedEntities.getEnrichmentBaseWrapperList().addAll(result.getEnrichmentBaseWrapperList());
        }
        return dereferencedEntities;
    }
}

