/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.metis.dereference.rest.config;

import com.mongodb.MongoClient;
import com.mongodb.MongoClientOptions;
import eu.europeana.corelib.storage.impl.MongoProviderImpl;
import eu.europeana.corelib.web.socks.SocksProxy;
import eu.europeana.enrichment.rest.client.EnrichmentClient;
import eu.europeana.metis.cache.redis.RedisProvider;
import eu.europeana.metis.dereference.service.dao.CacheDao;
import eu.europeana.metis.dereference.service.dao.EntityDao;
import eu.europeana.metis.dereference.service.dao.VocabularyDao;
import javax.annotation.PreDestroy;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.PropertySource;
import org.springframework.context.support.PropertySourcesPlaceholderConfigurer;
import org.springframework.web.servlet.config.annotation.EnableWebMvc;
import org.springframework.web.servlet.config.annotation.ResourceHandlerRegistry;
import org.springframework.web.servlet.config.annotation.ViewControllerRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;
import springfox.documentation.builders.PathSelectors;
import springfox.documentation.builders.RequestHandlerSelectors;
import springfox.documentation.service.ApiInfo;
import springfox.documentation.service.Contact;
import springfox.documentation.spi.DocumentationType;
import springfox.documentation.spring.web.plugins.Docket;
import springfox.documentation.swagger2.annotations.EnableSwagger2;

@Configuration
@ComponentScan(basePackages={"eu.europeana.metis.dereference.rest", "eu.europeana.metis.dereference.rest.exceptions"})
@PropertySource(value={"classpath:dereferencing.properties"})
@EnableWebMvc
@EnableSwagger2
public class Application
implements WebMvcConfigurer,
InitializingBean {
    @Value(value="${socks.proxy.enabled}")
    private boolean socksProxyEnabled;
    @Value(value="${socks.proxy.host}")
    private String socksProxyHost;
    @Value(value="${socks.proxy.port}")
    private String socksProxyPort;
    @Value(value="${socks.proxy.username}")
    private String socksProxyUsername;
    @Value(value="${socks.proxy.password}")
    private String socksProxyPassword;
    @Value(value="${redis.host}")
    private String redisHost;
    @Value(value="${redis.port}")
    private int redisPort;
    @Value(value="${redis.password}")
    private String redisPassword;
    @Value(value="${mongo.hosts}")
    private String[] mongoHosts;
    @Value(value="${mongo.port}")
    private int mongoPort;
    @Value(value="${mongo.username}")
    private String mongoUsername;
    @Value(value="${mongo.password}")
    private String mongoPassword;
    @Value(value="${entity.db}")
    private String entityDb;
    @Value(value="${vocabulary.db}")
    private String vocabularyDb;
    @Value(value="${enrichment.url}")
    private String enrichmentUrl;
    private MongoProviderImpl mongoProviderEntity;
    private MongoProviderImpl mongoProviderVocabulary;
    private RedisProvider redisProvider;

    public void afterPropertiesSet() {
        if (this.socksProxyEnabled) {
            new SocksProxy(this.socksProxyHost, this.socksProxyPort, this.socksProxyUsername, this.socksProxyPassword).init();
        }
        String[] mongoPorts = new String[this.mongoHosts.length];
        for (int i = 0; i < this.mongoHosts.length; ++i) {
            mongoPorts[i] = Integer.toString(this.mongoPort);
        }
        MongoClientOptions.Builder options = MongoClientOptions.builder();
        this.mongoProviderEntity = new MongoProviderImpl(this.mongoHosts, mongoPorts, this.entityDb, this.mongoUsername, this.mongoPassword, options);
        this.mongoProviderVocabulary = new MongoProviderImpl(this.mongoHosts, mongoPorts, this.vocabularyDb, this.mongoUsername, this.mongoPassword, options);
        if (this.redisProvider == null) {
            this.redisProvider = new RedisProvider(this.redisHost, this.redisPort, this.redisPassword);
        }
    }

    public void addResourceHandlers(ResourceHandlerRegistry registry) {
        registry.addResourceHandler(new String[]{"swagger-ui.html"}).addResourceLocations(new String[]{"classpath:/META-INF/resources/"});
        registry.addResourceHandler(new String[]{"/webjars/**"}).addResourceLocations(new String[]{"classpath:/META-INF/resources/webjars/"});
    }

    public void addViewControllers(ViewControllerRegistry registry) {
        registry.addRedirectViewController("/", "swagger-ui.html");
    }

    @Bean
    EnrichmentClient getEnrichmentClient() {
        return new EnrichmentClient(this.enrichmentUrl);
    }

    MongoClient getEntityMongoClient() {
        return this.mongoProviderEntity.getMongo();
    }

    MongoClient getVocabularyMongoClient() {
        return this.mongoProviderVocabulary.getMongo();
    }

    @Bean
    CacheDao getCacheDao() {
        return new CacheDao(this.redisProvider);
    }

    @Bean
    EntityDao getEntityDao() {
        return new EntityDao(this.getEntityMongoClient(), this.entityDb);
    }

    @Bean
    VocabularyDao getVocabularyDao() {
        return new VocabularyDao(this.getVocabularyMongoClient(), this.vocabularyDb);
    }

    @Bean
    public static PropertySourcesPlaceholderConfigurer propertySourcesPlaceholderConfigurer() {
        return new PropertySourcesPlaceholderConfigurer();
    }

    @Bean
    public Docket api() {
        return new Docket(DocumentationType.SWAGGER_2).useDefaultResponseMessages(false).select().apis(RequestHandlerSelectors.any()).paths(PathSelectors.regex((String)"/.*")).build().apiInfo(this.apiInfo());
    }

    @PreDestroy
    public void close() {
        if (this.mongoProviderVocabulary != null) {
            this.mongoProviderVocabulary.close();
        }
        if (this.mongoProviderEntity != null) {
            this.mongoProviderEntity.close();
        }
    }

    private ApiInfo apiInfo() {
        return new ApiInfo("Dereference REST API", "Dereference REST API for Europeana", "v1", "API TOS", new Contact("development", "europeana.eu", "development@europeana.eu"), "EUPL Licence v1.1", "");
    }
}

