/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.metis.data.checker.service;

import com.google.common.base.Strings;
import eu.europeana.indexing.exception.IndexingException;
import eu.europeana.metis.data.checker.common.exception.DataCheckerServiceException;
import eu.europeana.metis.data.checker.common.model.DatasetProperties;
import eu.europeana.metis.data.checker.common.model.ExtendedValidationResult;
import eu.europeana.metis.data.checker.service.DataCheckerServiceConfig;
import eu.europeana.metis.data.checker.service.executor.ValidationTask;
import eu.europeana.metis.data.checker.service.executor.ValidationTaskFactory;
import eu.europeana.metis.data.checker.service.executor.ValidationTaskResult;
import eu.europeana.metis.data.checker.service.persistence.RecordIndexingService;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.PreDestroy;
import org.apache.solr.client.solrj.SolrServerException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Service;

@Service
public class DataCheckerService {
    private static final Logger LOGGER = LoggerFactory.getLogger(DataCheckerService.class);
    private final ExecutorService executor;
    private final String dataCheckerUrl;
    private final RecordIndexingService recordIndexingService;
    private final ValidationTaskFactory factory;

    @Autowired
    public DataCheckerService(DataCheckerServiceConfig dataCheckerServiceConfig, RecordIndexingService recordIndexingService, ValidationTaskFactory factory) {
        this.dataCheckerUrl = dataCheckerServiceConfig.getDataCheckerUrl();
        this.recordIndexingService = recordIndexingService;
        this.factory = factory;
        this.executor = Executors.newFixedThreadPool(dataCheckerServiceConfig.getThreadCount());
    }

    public ExtendedValidationResult createRecords(List<String> records, DatasetProperties datasetProperties, boolean applyTransformation, boolean individualRecords) throws DataCheckerServiceException {
        Date recordDate = new Date();
        Function<String, ValidationTask> validationTaskCreator = record -> this.factory.createValidationTask(applyTransformation, (String)record, recordDate, datasetProperties);
        List tasks = records.stream().map(validationTaskCreator).collect(Collectors.toList());
        ExecutorCompletionService executorCompletionService = new ExecutorCompletionService(this.executor);
        List<Future<ValidationTaskResult>> taskResultFutures = tasks.stream().map(executorCompletionService::submit).collect(Collectors.toList());
        List<ValidationTaskResult> taskResults = this.waitForTasksToComplete(taskResultFutures);
        this.commitChanges();
        return this.compileResult(taskResults, datasetProperties, individualRecords);
    }

    private void commitChanges() throws DataCheckerServiceException {
        try {
            this.recordIndexingService.commit();
        }
        catch (IndexingException e) {
            throw new DataCheckerServiceException("Updating search engine failed", (Throwable)e);
        }
    }

    private List<ValidationTaskResult> waitForTasksToComplete(List<Future<ValidationTaskResult>> taskResultFutures) throws DataCheckerServiceException {
        ArrayList<ValidationTaskResult> taskResults;
        try {
            int counter = 1;
            taskResults = new ArrayList<ValidationTaskResult>(taskResultFutures.size());
            for (Future<ValidationTaskResult> taskResultFuture : taskResultFutures) {
                LOGGER.info("Retrieving validation result {} of {}.", (Object)counter, (Object)taskResultFutures.size());
                ++counter;
                taskResults.add(taskResultFuture.get());
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new DataCheckerServiceException("Processing validations was interrupted", (Throwable)e);
        }
        catch (ExecutionException e) {
            throw new DataCheckerServiceException("Executing validations failed", (Throwable)e);
        }
        return taskResults;
    }

    private ExtendedValidationResult compileResult(List<ValidationTaskResult> taskResults, DatasetProperties datasetProperties, boolean includeRecordIds) throws DataCheckerServiceException {
        List failedResults = taskResults.stream().filter(result -> !result.isSuccess()).map(ValidationTaskResult::getValidationResult).collect(Collectors.toList());
        List succeededResults = includeRecordIds ? taskResults.stream().filter(ValidationTaskResult::isSuccess).map(ValidationTaskResult::getRecordId).filter(record -> !Strings.isNullOrEmpty((String)record)).collect(Collectors.toList()) : null;
        ExtendedValidationResult extendedValidationResult = new ExtendedValidationResult();
        extendedValidationResult.setResultList(failedResults);
        extendedValidationResult.setSuccess(failedResults.isEmpty());
        extendedValidationResult.setRecords(succeededResults);
        extendedValidationResult.setDate(new Date());
        try {
            extendedValidationResult.setPortalUrl(this.dataCheckerUrl + URLEncoder.encode(datasetProperties.getDatasetNameSolrQueryValue(), StandardCharsets.UTF_8.name()));
        }
        catch (UnsupportedEncodingException e) {
            throw new DataCheckerServiceException("Unexpected encoding issue.", (Throwable)e);
        }
        return extendedValidationResult;
    }

    @Scheduled(cron="00 00 00 * * *")
    public void deleteRecords() throws IOException, SolrServerException, IndexingException {
        this.recordIndexingService.deleteRecordIdsByTimestamp();
    }

    @PreDestroy
    public void close() {
        if (this.executor != null) {
            this.executor.shutdown();
        }
    }
}

