/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.metis.data.checker.service.executor;

import eu.europeana.corelib.definitions.jibx.Aggregation;
import eu.europeana.corelib.definitions.jibx.DatasetName;
import eu.europeana.corelib.definitions.jibx.EuropeanaAggregationType;
import eu.europeana.corelib.definitions.jibx.EuropeanaType;
import eu.europeana.corelib.definitions.jibx.ProvidedCHOType;
import eu.europeana.corelib.definitions.jibx.ProxyType;
import eu.europeana.corelib.definitions.jibx.RDF;
import eu.europeana.indexing.exception.IndexingException;
import eu.europeana.metis.data.checker.common.model.DatasetProperties;
import eu.europeana.metis.data.checker.service.executor.ValidationTaskResult;
import eu.europeana.metis.data.checker.service.executor.ValidationUtils;
import eu.europeana.metis.transformation.service.EuropeanaGeneratedIdsMap;
import eu.europeana.metis.transformation.service.EuropeanaIdCreator;
import eu.europeana.metis.transformation.service.EuropeanaIdException;
import eu.europeana.metis.transformation.service.TransformationException;
import eu.europeana.metis.transformation.service.XsltTransformer;
import eu.europeana.validation.model.ValidationResult;
import java.io.Reader;
import java.io.StringReader;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.Objects;
import java.util.concurrent.Callable;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.jibx.runtime.IBindingFactory;
import org.jibx.runtime.IUnmarshallingContext;
import org.jibx.runtime.JiBXException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ValidationTask
implements Callable<ValidationTaskResult> {
    private static final Logger LOGGER = LoggerFactory.getLogger(ValidationTask.class);
    private final ValidationUtils validationUtils;
    private final boolean applyTransformation;
    private final IBindingFactory bFact;
    private final String incomingRecord;
    private final Date recordDate;
    private final DatasetProperties datasetProperties;

    public ValidationTask(ValidationUtils validationUtils, boolean applyTransformation, IBindingFactory bFact, String incomingRecord, Date recordDate, DatasetProperties datasetProperties) {
        this.validationUtils = validationUtils;
        this.applyTransformation = applyTransformation;
        this.bFact = bFact;
        this.incomingRecord = incomingRecord;
        this.recordDate = new Date(recordDate.getTime());
        this.datasetProperties = datasetProperties;
    }

    @Override
    public ValidationTaskResult call() throws JiBXException, IndexingException, EuropeanaIdException, TransformationException {
        try {
            return this.invoke();
        }
        catch (IndexingException | EuropeanaIdException | TransformationException | JiBXException e) {
            LOGGER.error("An error occurred while processing", e);
            throw e;
        }
    }

    private ValidationTaskResult invoke() throws JiBXException, IndexingException, EuropeanaIdException, TransformationException {
        RDF rdf;
        ValidationResult validationResult = this.applyTransformation ? this.validationUtils.validateRecordBeforeTransformation(this.incomingRecord) : this.validationUtils.validateRecordAfterTransformation(this.incomingRecord);
        if (!validationResult.isSuccess()) {
            return new ValidationTaskResult(null, validationResult, false);
        }
        if (this.applyTransformation) {
            rdf = this.convertToRdf(this.transformRecord());
        } else {
            rdf = this.convertToRdf(this.incomingRecord);
            this.setDatasetProperties(rdf);
        }
        this.validationUtils.persist(rdf, this.recordDate);
        String recordId = ((ProvidedCHOType)rdf.getProvidedCHOList().get(0)).getAbout();
        return new ValidationTaskResult(recordId, validationResult, true);
    }

    private RDF convertToRdf(String rdfString) throws JiBXException {
        IUnmarshallingContext uctx = this.bFact.createUnmarshallingContext();
        return (RDF)uctx.unmarshalDocument((Reader)new StringReader(rdfString));
    }

    private String transformRecord() throws EuropeanaIdException, TransformationException {
        EuropeanaGeneratedIdsMap europeanaGeneratedIdsMap = new EuropeanaIdCreator().constructEuropeanaId(this.incomingRecord, this.datasetProperties.getDatasetId());
        XsltTransformer transformer = this.validationUtils.createTransformer(this.datasetProperties.getDatasetName(), this.datasetProperties.getEdmCountry(), this.datasetProperties.getEdmLanguage());
        return transformer.transform(this.incomingRecord.getBytes(StandardCharsets.UTF_8), europeanaGeneratedIdsMap).toString();
    }

    private static <T> Stream<T> stream(Collection<T> collection) {
        return collection == null ? Stream.empty() : collection.stream();
    }

    private static boolean isEuropeanaProxy(ProxyType proxy) {
        return proxy.getEuropeanaProxy() != null && proxy.getEuropeanaProxy().isEuropeanaProxy();
    }

    private static boolean isProviderProxy(ProxyType proxy) {
        return !ValidationTask.isEuropeanaProxy(proxy);
    }

    private void setDatasetProperties(RDF rdf) throws EuropeanaIdException {
        EuropeanaGeneratedIdsMap ids = new EuropeanaIdCreator().constructEuropeanaId(this.incomingRecord, this.datasetProperties.getDatasetId());
        ((ProvidedCHOType)rdf.getProvidedCHOList().get(0)).setAbout(ids.getEuropeanaGeneratedId());
        ValidationTask.stream(rdf.getAggregationList()).map(Aggregation::getAggregatedCHO).filter(Objects::nonNull).forEach(cho -> cho.setResource(ids.getEuropeanaGeneratedId()));
        ValidationTask.stream(rdf.getEuropeanaAggregationList()).map(EuropeanaAggregationType::getAggregatedCHO).filter(Objects::nonNull).forEach(cho -> cho.setResource(ids.getEuropeanaGeneratedId()));
        ValidationTask.stream(rdf.getProxyList()).map(ProxyType::getProxyFor).filter(Objects::nonNull).forEach(proxyFor -> proxyFor.setResource(ids.getEuropeanaGeneratedId()));
        ValidationTask.stream(rdf.getProxyList()).filter(ValidationTask::isEuropeanaProxy).map(ProxyType::getProxyInList).filter(Objects::nonNull).flatMap(Collection::stream).forEach(proxyIn -> proxyIn.setResource(ids.getEuropeanaAggregationAboutPrefixed()));
        ValidationTask.stream(rdf.getEuropeanaAggregationList()).forEach(aggregation -> aggregation.setAbout(ids.getEuropeanaAggregationAboutPrefixed()));
        ValidationTask.stream(rdf.getProxyList()).filter(ValidationTask::isProviderProxy).map(ProxyType::getProxyInList).filter(Objects::nonNull).flatMap(Collection::stream).forEach(proxyIn -> proxyIn.setResource(ids.getAggregationAboutPrefixed()));
        ValidationTask.stream(rdf.getAggregationList()).forEach(aggregation -> aggregation.setAbout(ids.getAggregationAboutPrefixed()));
        ValidationTask.stream(rdf.getProxyList()).filter(ValidationTask::isEuropeanaProxy).forEach(proxy -> proxy.setAbout(ids.getEuropeanaProxyAboutPrefixed()));
        ValidationTask.stream(rdf.getProxyList()).filter(ValidationTask::isProviderProxy).forEach(proxy -> proxy.setAbout(ids.getProxyAboutPrefixed()));
        ValidationTask.stream(rdf.getProxyList()).filter(ValidationTask::isEuropeanaProxy).map(EuropeanaType::getChoiceList).filter(Objects::nonNull).flatMap(Collection::stream).filter(EuropeanaType.Choice::ifIdentifier).map(EuropeanaType.Choice::getIdentifier).forEach(identifier -> identifier.setString(ids.getEuropeanaGeneratedId()));
        if (rdf.getEuropeanaAggregationList() == null || rdf.getEuropeanaAggregationList().isEmpty()) {
            rdf.setEuropeanaAggregationList(Arrays.asList(new EuropeanaAggregationType()));
        }
        Supplier<DatasetName> datasetNameSupplier = () -> {
            DatasetName datasetName = new DatasetName();
            datasetName.setString(this.datasetProperties.getDatasetName());
            return datasetName;
        };
        ValidationTask.stream(rdf.getEuropeanaAggregationList()).filter(Objects::nonNull).forEach(aggregation -> aggregation.setDatasetName((DatasetName)datasetNameSupplier.get()));
    }
}

