/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.metis.data.checker.service.persistence;

import eu.europeana.corelib.definitions.jibx.RDF;
import eu.europeana.corelib.mongo.server.EdmMongoServer;
import eu.europeana.corelib.solr.bean.impl.FullBeanImpl;
import eu.europeana.corelib.solr.entity.AgentImpl;
import eu.europeana.corelib.solr.entity.AggregationImpl;
import eu.europeana.corelib.solr.entity.ConceptImpl;
import eu.europeana.corelib.solr.entity.EuropeanaAggregationImpl;
import eu.europeana.corelib.solr.entity.EventImpl;
import eu.europeana.corelib.solr.entity.LicenseImpl;
import eu.europeana.corelib.solr.entity.PhysicalThingImpl;
import eu.europeana.corelib.solr.entity.PlaceImpl;
import eu.europeana.corelib.solr.entity.ProvidedCHOImpl;
import eu.europeana.corelib.solr.entity.ProxyImpl;
import eu.europeana.corelib.solr.entity.ServiceImpl;
import eu.europeana.corelib.solr.entity.TimespanImpl;
import eu.europeana.corelib.solr.entity.WebResourceImpl;
import eu.europeana.indexing.AbstractConnectionProvider;
import eu.europeana.indexing.Indexer;
import eu.europeana.indexing.IndexerFactory;
import eu.europeana.indexing.exception.IndexingException;
import java.io.IOException;
import java.util.Date;
import org.apache.solr.client.solrj.SolrClient;
import org.apache.solr.client.solrj.SolrQuery;
import org.apache.solr.client.solrj.SolrServerException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class RecordDao {
    private final SolrClient solrServer;
    private final EdmMongoServer mongoServer;
    private final Indexer indexer;

    @Autowired
    public RecordDao(AbstractConnectionProvider connectionProvider) throws IndexingException {
        this(connectionProvider.getSolrClient(), connectionProvider.getEdmMongoClient(), new IndexerFactory(connectionProvider.getEdmMongoClient(), connectionProvider.getRecordRedirectDao(), connectionProvider.getSolrClient()).getIndexer());
    }

    RecordDao(SolrClient solrServer, EdmMongoServer mongoServer, Indexer indexer) {
        this.solrServer = solrServer;
        this.mongoServer = mongoServer;
        this.indexer = indexer;
    }

    public void createRecord(RDF rdf, Date recordDate) throws IndexingException {
        this.indexer.indexRdf(rdf, recordDate, false, null, false);
    }

    public void commit() throws IndexingException {
        this.indexer.triggerFlushOfPendingChanges(true);
    }

    public void deleteRecordIdsByTimestamp() throws SolrServerException, IOException, IndexingException {
        SolrQuery query = new SolrQuery();
        query.setQuery("*:*");
        this.solrServer.deleteByQuery(query.getQuery());
        this.commit();
        this.clearCollectionFromMongo(FullBeanImpl.class);
        this.clearCollectionFromMongo(AgentImpl.class);
        this.clearCollectionFromMongo(AggregationImpl.class);
        this.clearCollectionFromMongo(ConceptImpl.class);
        this.clearCollectionFromMongo(EuropeanaAggregationImpl.class);
        this.clearCollectionFromMongo(EventImpl.class);
        this.clearCollectionFromMongo(LicenseImpl.class);
        this.clearCollectionFromMongo(PhysicalThingImpl.class);
        this.clearCollectionFromMongo(PlaceImpl.class);
        this.clearCollectionFromMongo(ProvidedCHOImpl.class);
        this.clearCollectionFromMongo(ProxyImpl.class);
        this.clearCollectionFromMongo(ServiceImpl.class);
        this.clearCollectionFromMongo(TimespanImpl.class);
        this.clearCollectionFromMongo(WebResourceImpl.class);
    }

    private void clearCollectionFromMongo(Class<?> collectionType) {
        this.mongoServer.getDatastore().delete(this.mongoServer.getDatastore().createQuery(collectionType));
    }
}

