/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.metis.data.checker.service.executor;

import eu.europeana.corelib.definitions.jibx.RDF;
import eu.europeana.metis.data.checker.common.model.DatasetProperties;
import eu.europeana.metis.data.checker.service.executor.ValidationTask;
import eu.europeana.metis.data.checker.service.executor.ValidationUtils;
import org.jibx.runtime.BindingDirectory;
import org.jibx.runtime.IBindingFactory;
import org.jibx.runtime.JiBXException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ValidationTaskFactory {
    private static final Logger LOGGER;
    private static final IBindingFactory BINDING_FACTORY;
    private final ValidationUtils validationUtils;

    @Autowired
    public ValidationTaskFactory(ValidationUtils validationUtils) {
        this.validationUtils = validationUtils;
    }

    public ValidationTask createValidationTask(boolean applyTransformation, String record, DatasetProperties datasetProperties) {
        return new ValidationTask(this.validationUtils, applyTransformation, BINDING_FACTORY, record, datasetProperties);
    }

    static {
        IBindingFactory bfactTemp;
        LOGGER = LoggerFactory.getLogger(ValidationTaskFactory.class);
        try {
            bfactTemp = BindingDirectory.getFactory(RDF.class);
        }
        catch (JiBXException e) {
            bfactTemp = null;
            LOGGER.error("Unable to get binding factory for RDF.class", (Throwable)e);
        }
        BINDING_FACTORY = bfactTemp;
    }
}

