/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.metis.data.checker.config;

import eu.europeana.corelib.web.socks.SocksProxy;
import eu.europeana.indexing.AbstractConnectionProvider;
import eu.europeana.indexing.IndexingSettings;
import eu.europeana.indexing.SettingsConnectionProvider;
import eu.europeana.indexing.exception.IndexingException;
import eu.europeana.metis.data.checker.service.ZipService;
import eu.europeana.metis.data.checker.service.executor.ValidationUtils;
import eu.europeana.metis.data.checker.service.persistence.RecordIndexingService;
import eu.europeana.metis.transformation.service.XsltTransformer;
import eu.europeana.validation.client.ValidationClient;
import java.io.IOException;
import java.net.URI;
import java.time.Duration;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import javax.annotation.PreDestroy;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.PropertySource;
import org.springframework.context.support.PropertySourcesPlaceholderConfigurer;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.converter.json.MappingJackson2HttpMessageConverter;
import org.springframework.scheduling.annotation.EnableScheduling;
import org.springframework.web.multipart.commons.CommonsMultipartResolver;
import org.springframework.web.servlet.config.annotation.EnableWebMvc;
import org.springframework.web.servlet.config.annotation.ResourceHandlerRegistry;
import org.springframework.web.servlet.config.annotation.ViewControllerRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;
import springfox.documentation.builders.PathSelectors;
import springfox.documentation.builders.RequestHandlerSelectors;
import springfox.documentation.service.ApiInfo;
import springfox.documentation.service.Contact;
import springfox.documentation.spi.DocumentationType;
import springfox.documentation.spring.web.plugins.Docket;
import springfox.documentation.swagger2.annotations.EnableSwagger2;

@Configuration
@ComponentScan(basePackages={"eu.europeana.metis.data.checker.rest", "eu.europeana.metis.data.checker.service", "eu.europeana.metis.data.checker"})
@PropertySource(value={"classpath:data.checker.properties"})
@EnableWebMvc
@EnableSwagger2
@EnableScheduling
public class Application
implements WebMvcConfigurer,
InitializingBean {
    private static final Logger LOGGER = LoggerFactory.getLogger(Application.class);
    private static final int MAX_UPLOAD_SIZE = 50000000;
    @Value(value="${socks.proxy.enabled}")
    private boolean socksProxyEnabled;
    @Value(value="${socks.proxy.host}")
    private String socksProxyHost;
    @Value(value="${socks.proxy.port}")
    private String socksProxyPort;
    @Value(value="${socks.proxy.username}")
    private String socksProxyUsername;
    @Value(value="${socks.proxy.password}")
    private String socksProxyPassword;
    @Value(value="${mongo.hosts}")
    private String[] mongoHosts;
    @Value(value="${mongo.port}")
    private int[] mongoPorts;
    @Value(value="${mongo.authentication.db}")
    private String mongoAuthenticationDb;
    @Value(value="${mongo.username}")
    private String mongoUsername;
    @Value(value="${mongo.password}")
    private String mongoPassword;
    @Value(value="${mongo.db}")
    private String mongoDb;
    @Value(value="${mongo.enableSSL}")
    private boolean mongoEnableSSL;
    @Value(value="${solr.hosts}")
    private String[] solrHosts;
    @Value(value="${zookeeper.hosts}")
    private String[] zookeeperHosts;
    @Value(value="${zookeeper.ports}")
    private int[] zookeeperPorts;
    @Value(value="${zookeeper.chroot}")
    private String zookeeperChroot;
    @Value(value="${zookeeper.default.collection}")
    private String zookeeperDefaultCollection;
    @Value(value="${zookeeper.timeout.in.secs}")
    private int zookeeperTimeoutInSecs;
    @Value(value="${validation.schema.before_transformation}")
    private String schemaBeforeTransformation;
    @Value(value="${validation.schema.after_transformation}")
    private String schemaAfterTransformation;
    @Value(value="${metis.core.uri}")
    private String metisCoreUri;
    @Value(value="${xslt.cache.expiration.in.sec}")
    private int xsltCacheExpirationInSec;
    @Value(value="${xslt.cache.unused.cleanup.in.min}")
    private int xsltCacheCleanupInMin;
    private AbstractConnectionProvider indexingConnection;

    public void afterPropertiesSet() throws Exception {
        if (this.socksProxyEnabled) {
            new SocksProxy(this.socksProxyHost, this.socksProxyPort, this.socksProxyUsername, this.socksProxyPassword).init();
        }
        IndexingSettings settings = new IndexingSettings();
        settings.getMongoProperties().setAllProperties(this.mongoHosts, this.mongoPorts, this.mongoAuthenticationDb, this.mongoUsername, this.mongoPassword, this.mongoEnableSSL, null);
        settings.setMongoDatabaseName(this.mongoDb);
        for (String host : this.solrHosts) {
            settings.addSolrHost(new URI(host));
        }
        settings.getSolrProperties().setZookeeperHosts(this.zookeeperHosts, this.zookeeperPorts);
        if (StringUtils.isNotBlank((String)this.zookeeperChroot)) {
            settings.setZookeeperChroot(this.zookeeperChroot);
        }
        if (StringUtils.isNotBlank((String)this.zookeeperDefaultCollection)) {
            settings.setZookeeperDefaultCollection(this.zookeeperDefaultCollection);
        }
        settings.setZookeeperTimeoutInSecs(this.zookeeperTimeoutInSecs);
        this.indexingConnection = new SettingsConnectionProvider(settings);
        XsltTransformer.setExpirationTime((Duration)Duration.ZERO.plusSeconds(this.xsltCacheExpirationInSec));
        XsltTransformer.setLenientWithReloads((boolean)true);
        Duration since = Duration.ofMinutes(this.xsltCacheCleanupInMin);
        ScheduledExecutorService scheduler = Executors.newScheduledThreadPool(1);
        scheduler.scheduleWithFixedDelay(() -> XsltTransformer.removeItemsNotAccessedSince((Duration)since), this.xsltCacheCleanupInMin, this.xsltCacheCleanupInMin, TimeUnit.MINUTES);
    }

    public void addViewControllers(ViewControllerRegistry registry) {
        registry.addRedirectViewController("/", "swagger-ui.html");
    }

    public void configureMessageConverters(List<HttpMessageConverter<?>> converters) {
        converters.add((HttpMessageConverter<?>)new MappingJackson2HttpMessageConverter());
    }

    public void addResourceHandlers(ResourceHandlerRegistry registry) {
        registry.addResourceHandler(new String[]{"swagger-ui.html"}).addResourceLocations(new String[]{"classpath:/META-INF/resources/"});
        registry.addResourceHandler(new String[]{"/webjars/**"}).addResourceLocations(new String[]{"classpath:/META-INF/resources/webjars/"});
    }

    @Bean(name={"datasetIdGenerator"})
    Supplier<String> getDatasetIdGenerator() {
        return () -> UUID.randomUUID().toString();
    }

    @Bean
    ValidationClient validationClient() throws IOException {
        return new ValidationClient();
    }

    @Bean
    ZipService zipService() {
        return new ZipService();
    }

    @Bean
    AbstractConnectionProvider getIndexingConnection() {
        return this.indexingConnection;
    }

    @Bean
    RecordIndexingService recordIndexingService() throws IndexingException {
        return new RecordIndexingService(this.indexingConnection);
    }

    @Bean
    public CommonsMultipartResolver multipartResolver() {
        CommonsMultipartResolver commonsMultipartResolver = new CommonsMultipartResolver();
        commonsMultipartResolver.setDefaultEncoding("utf-8");
        commonsMultipartResolver.setMaxUploadSize(50000000L);
        return commonsMultipartResolver;
    }

    @Bean
    public static PropertySourcesPlaceholderConfigurer propertySourcesPlaceholderConfigurer() {
        return new PropertySourcesPlaceholderConfigurer();
    }

    @Bean
    public Docket api() {
        return new Docket(DocumentationType.SWAGGER_2).select().apis(RequestHandlerSelectors.any()).paths(PathSelectors.regex((String)"/.*")).build().apiInfo(this.apiInfo());
    }

    @Bean
    public ValidationUtils getValidationUtils() throws IOException, IndexingException {
        return new ValidationUtils(this.validationClient(), this.recordIndexingService(), this.schemaBeforeTransformation, this.schemaAfterTransformation, this.metisCoreUri);
    }

    @PreDestroy
    public void close() throws IOException {
        LOGGER.info("Closing connections..");
        if (this.indexingConnection != null) {
            this.indexingConnection.close();
        }
    }

    private ApiInfo apiInfo() {
        Contact contact = new Contact("development", "europeana.eu", "development@europeana.eu");
        return new ApiInfo("Data Checker REST API", "Data Checker REST API for Europeana", "v1", "API TOS", contact, "EUPL Licence v1.1", "");
    }
}

