/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.metis.data.checker.config;

import eu.europeana.metis.data.checker.service.DataCheckerServiceConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.PropertySource;
import org.springframework.stereotype.Service;

@Service
@PropertySource(value={"classpath:data.checker.properties"})
public class DataCheckerServiceConfigImpl
implements DataCheckerServiceConfig {
    private static final Logger LOGGER = LoggerFactory.getLogger(DataCheckerServiceConfigImpl.class);
    private static final int DEFAULT_EXECUTOR_THREAD_COUNT = 10;
    @Value(value="${data.checker.portal.url}")
    private String dataCheckerPortalUrl;
    @Value(value="${data.checker.executor.threadCount:10}")
    private String executorThreadCount;

    public String getDataCheckerUrl() {
        return this.dataCheckerPortalUrl;
    }

    public int getThreadCount() {
        try {
            int value = Integer.parseInt(this.executorThreadCount);
            LOGGER.info("Using data.checker.executor.threadCount with value {}", (Object)value);
            return value;
        }
        catch (NumberFormatException ex) {
            LOGGER.warn("Failed to parse data.checker.executor.threadCount with value '{}'. Taking 10 as default", (Object)this.executorThreadCount);
            return 10;
        }
    }
}

