/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.metis.data.checker.common.model;

import org.apache.commons.lang3.StringUtils;
import org.apache.solr.client.solrj.util.ClientUtils;

public class DatasetProperties {
    private static final String DATASET_NAME_SEPARATOR = "_";
    private static final String DEFAULT_DATASET_NAME = "Unnamed dataset";
    private static final String DEFAULT_EDM_COUNTRY = "Netherlands";
    private static final String DEFAULT_EDM_LANGUAGE = "nl";
    private final String datasetId;
    private final String datasetName;
    private final String edmCountry;
    private final String edmLanguage;

    public DatasetProperties(String datasetId, String datasetName, String edmCountry, String edmLanguage) {
        if (datasetId == null) {
            throw new IllegalArgumentException();
        }
        this.datasetId = datasetId;
        String nonBlankDatasetName = StringUtils.isBlank((CharSequence)datasetName) ? DEFAULT_DATASET_NAME : datasetName;
        this.datasetName = datasetId + DATASET_NAME_SEPARATOR + nonBlankDatasetName;
        this.edmCountry = edmCountry != null ? edmCountry : DEFAULT_EDM_COUNTRY;
        this.edmLanguage = edmLanguage != null ? edmLanguage : DEFAULT_EDM_LANGUAGE;
    }

    public String getDatasetNameSolrQueryValue() {
        return ClientUtils.escapeQueryChars((String)(this.datasetId + DATASET_NAME_SEPARATOR)) + "*";
    }

    public String getDatasetId() {
        return this.datasetId;
    }

    public String getDatasetName() {
        return this.datasetName;
    }

    public String getEdmCountry() {
        return this.edmCountry;
    }

    public String getEdmLanguage() {
        return this.edmLanguage;
    }
}

