/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.metis.core.service;

import eu.europeana.metis.authentication.user.MetisUser;
import eu.europeana.metis.core.dao.DatasetDao;
import eu.europeana.metis.core.dao.ScheduledWorkflowDao;
import eu.europeana.metis.core.dao.WorkflowDao;
import eu.europeana.metis.core.dataset.Dataset;
import eu.europeana.metis.core.exceptions.NoDatasetFoundException;
import eu.europeana.metis.core.exceptions.NoScheduledWorkflowFoundException;
import eu.europeana.metis.core.exceptions.NoWorkflowFoundException;
import eu.europeana.metis.core.exceptions.ScheduledWorkflowAlreadyExistsException;
import eu.europeana.metis.core.service.Authorizer;
import eu.europeana.metis.core.workflow.ScheduleFrequence;
import eu.europeana.metis.core.workflow.ScheduledWorkflow;
import eu.europeana.metis.core.workflow.Workflow;
import eu.europeana.metis.exception.BadContentException;
import eu.europeana.metis.exception.GenericMetisException;
import eu.europeana.metis.exception.UserUnauthorizedException;
import java.time.LocalDateTime;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.bson.types.ObjectId;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ScheduleWorkflowService {
    private final ScheduledWorkflowDao scheduledWorkflowDao;
    private final WorkflowDao workflowDao;
    private final DatasetDao datasetDao;
    private final Authorizer authorizer;

    @Autowired
    public ScheduleWorkflowService(ScheduledWorkflowDao scheduledWorkflowDao, WorkflowDao workflowDao, DatasetDao datasetDao, Authorizer authorizer) {
        this.scheduledWorkflowDao = scheduledWorkflowDao;
        this.workflowDao = workflowDao;
        this.datasetDao = datasetDao;
        this.authorizer = authorizer;
    }

    public int getScheduledWorkflowsPerRequest() {
        return this.scheduledWorkflowDao.getScheduledWorkflowPerRequest();
    }

    public ScheduledWorkflow getScheduledWorkflowByDatasetId(MetisUser metisUser, String datasetId) throws UserUnauthorizedException, NoDatasetFoundException {
        this.authorizer.authorizeReadExistingDatasetById(metisUser, datasetId);
        return this.scheduledWorkflowDao.getScheduledWorkflowByDatasetId(datasetId);
    }

    public void scheduleWorkflow(MetisUser metisUser, ScheduledWorkflow scheduledWorkflow) throws GenericMetisException {
        this.authorizer.authorizeWriteExistingDatasetById(metisUser, scheduledWorkflow.getDatasetId());
        this.checkRestrictionsOnScheduleWorkflow(scheduledWorkflow);
        this.scheduledWorkflowDao.create(scheduledWorkflow);
    }

    public List<ScheduledWorkflow> getAllScheduledWorkflowsWithoutAuthorization(ScheduleFrequence scheduleFrequence, int nextPage) {
        return this.scheduledWorkflowDao.getAllScheduledWorkflows(scheduleFrequence, nextPage);
    }

    public List<ScheduledWorkflow> getAllScheduledWorkflows(MetisUser metisUser, ScheduleFrequence scheduleFrequence, int nextPage) throws UserUnauthorizedException {
        this.authorizer.authorizeReadAllDatasets(metisUser);
        return this.getAllScheduledWorkflowsWithoutAuthorization(scheduleFrequence, nextPage);
    }

    public List<ScheduledWorkflow> getAllScheduledWorkflowsByDateRangeONCE(LocalDateTime lowerBound, LocalDateTime upperBound, int nextPage) {
        return this.scheduledWorkflowDao.getAllScheduledWorkflowsByDateRangeONCE(lowerBound, upperBound, nextPage);
    }

    private void checkScheduledWorkflowExistenceForDatasetId(String datasetId) throws ScheduledWorkflowAlreadyExistsException {
        String id = this.scheduledWorkflowDao.existsForDatasetId(datasetId);
        if (id != null) {
            throw new ScheduledWorkflowAlreadyExistsException(String.format("ScheduledWorkflow for datasetId: %s with id %s, already exists", datasetId, id));
        }
    }

    public void updateScheduledWorkflow(MetisUser metisUser, ScheduledWorkflow scheduledWorkflow) throws GenericMetisException {
        this.authorizer.authorizeWriteExistingDatasetById(metisUser, scheduledWorkflow.getDatasetId());
        String storedId = this.checkRestrictionsOnScheduledWorkflowUpdate(scheduledWorkflow);
        scheduledWorkflow.setId(new ObjectId(storedId));
        this.scheduledWorkflowDao.update(scheduledWorkflow);
    }

    private void checkRestrictionsOnScheduleWorkflow(ScheduledWorkflow scheduledWorkflow) throws NoWorkflowFoundException, NoDatasetFoundException, ScheduledWorkflowAlreadyExistsException, BadContentException {
        this.checkDatasetExistence(scheduledWorkflow.getDatasetId());
        this.checkWorkflowExistence(scheduledWorkflow.getDatasetId());
        this.checkScheduledWorkflowExistenceForDatasetId(scheduledWorkflow.getDatasetId());
        if (scheduledWorkflow.getPointerDate() == null) {
            throw new BadContentException("PointerDate cannot be null");
        }
        if (scheduledWorkflow.getScheduleFrequence() == null || scheduledWorkflow.getScheduleFrequence() == ScheduleFrequence.NULL) {
            throw new BadContentException("NULL or null is not a valid scheduleFrequence");
        }
    }

    private String checkRestrictionsOnScheduledWorkflowUpdate(ScheduledWorkflow scheduledWorkflow) throws NoScheduledWorkflowFoundException, BadContentException, NoWorkflowFoundException {
        this.checkWorkflowExistence(scheduledWorkflow.getDatasetId());
        String storedId = this.scheduledWorkflowDao.existsForDatasetId(scheduledWorkflow.getDatasetId());
        if (StringUtils.isEmpty((CharSequence)storedId)) {
            throw new NoScheduledWorkflowFoundException(String.format("Workflow with datasetId: %s, not found", scheduledWorkflow.getDatasetId()));
        }
        if (scheduledWorkflow.getPointerDate() == null) {
            throw new BadContentException("PointerDate cannot be null");
        }
        if (scheduledWorkflow.getScheduleFrequence() == null || scheduledWorkflow.getScheduleFrequence() == ScheduleFrequence.NULL) {
            throw new BadContentException("NULL or null is not a valid scheduleFrequence");
        }
        return storedId;
    }

    public void deleteScheduledWorkflow(MetisUser metisUser, String datasetId) throws UserUnauthorizedException, NoDatasetFoundException {
        this.authorizer.authorizeWriteExistingDatasetById(metisUser, datasetId);
        this.scheduledWorkflowDao.deleteScheduledWorkflow(datasetId);
    }

    private Dataset checkDatasetExistence(String datasetId) throws NoDatasetFoundException {
        Dataset dataset = this.datasetDao.getDatasetByDatasetId(datasetId);
        if (dataset == null) {
            throw new NoDatasetFoundException(String.format("No dataset found with datasetId: %s, in METIS", datasetId));
        }
        return dataset;
    }

    private Workflow checkWorkflowExistence(String datasetId) throws NoWorkflowFoundException {
        Workflow workflow = this.workflowDao.getWorkflow(datasetId);
        if (workflow == null) {
            throw new NoWorkflowFoundException(String.format("No workflow found with datasetId: %s, in METIS", datasetId));
        }
        return workflow;
    }
}

