/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.metis.core.service;

import eu.europeana.cloud.client.dps.rest.DpsClient;
import eu.europeana.cloud.common.model.File;
import eu.europeana.cloud.common.model.Representation;
import eu.europeana.cloud.common.model.dps.StatisticsReport;
import eu.europeana.cloud.common.model.dps.SubTaskInfo;
import eu.europeana.cloud.common.model.dps.TaskErrorsInfo;
import eu.europeana.cloud.common.response.CloudTagsResponse;
import eu.europeana.cloud.common.response.ResultSlice;
import eu.europeana.cloud.mcs.driver.DataSetServiceClient;
import eu.europeana.cloud.mcs.driver.FileServiceClient;
import eu.europeana.cloud.mcs.driver.RecordServiceClient;
import eu.europeana.cloud.service.dps.exception.DpsException;
import eu.europeana.cloud.service.mcs.exception.MCSException;
import eu.europeana.metis.authentication.user.MetisUser;
import eu.europeana.metis.core.dao.WorkflowExecutionDao;
import eu.europeana.metis.core.exceptions.NoWorkflowExecutionFoundException;
import eu.europeana.metis.core.rest.ListOfIds;
import eu.europeana.metis.core.rest.PaginatedRecordsResponse;
import eu.europeana.metis.core.rest.Record;
import eu.europeana.metis.core.rest.RecordsResponse;
import eu.europeana.metis.core.rest.stats.NodePathStatistics;
import eu.europeana.metis.core.rest.stats.RecordStatistics;
import eu.europeana.metis.core.service.Authorizer;
import eu.europeana.metis.core.service.ProxiesHelper;
import eu.europeana.metis.core.workflow.WorkflowExecution;
import eu.europeana.metis.core.workflow.plugins.AbstractExecutablePlugin;
import eu.europeana.metis.core.workflow.plugins.AbstractMetisPlugin;
import eu.europeana.metis.core.workflow.plugins.ExecutablePluginType;
import eu.europeana.metis.exception.ExternalTaskException;
import eu.europeana.metis.exception.GenericMetisException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;

public class ProxiesService {
    protected final DateFormat pluginDateFormatForEcloud = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSXXX");
    private final WorkflowExecutionDao workflowExecutionDao;
    private final DataSetServiceClient ecloudDataSetServiceClient;
    private final RecordServiceClient recordServiceClient;
    private final FileServiceClient fileServiceClient;
    private final DpsClient dpsClient;
    private final String ecloudProvider;
    private final Authorizer authorizer;
    private final ProxiesHelper proxiesHelper;

    public ProxiesService(WorkflowExecutionDao workflowExecutionDao, DataSetServiceClient ecloudDataSetServiceClient, RecordServiceClient recordServiceClient, FileServiceClient fileServiceClient, DpsClient dpsClient, String ecloudProvider, Authorizer authorizer) {
        this(workflowExecutionDao, ecloudDataSetServiceClient, recordServiceClient, fileServiceClient, dpsClient, ecloudProvider, authorizer, new ProxiesHelper());
    }

    ProxiesService(WorkflowExecutionDao workflowExecutionDao, DataSetServiceClient ecloudDataSetServiceClient, RecordServiceClient recordServiceClient, FileServiceClient fileServiceClient, DpsClient dpsClient, String ecloudProvider, Authorizer authorizer, ProxiesHelper proxiesHelper) {
        this.workflowExecutionDao = workflowExecutionDao;
        this.ecloudDataSetServiceClient = ecloudDataSetServiceClient;
        this.recordServiceClient = recordServiceClient;
        this.fileServiceClient = fileServiceClient;
        this.dpsClient = dpsClient;
        this.ecloudProvider = ecloudProvider;
        this.authorizer = authorizer;
        this.proxiesHelper = proxiesHelper;
    }

    public List<SubTaskInfo> getExternalTaskLogs(MetisUser metisUser, String topologyName, long externalTaskId, int from, int to) throws GenericMetisException {
        List detailedTaskReportBetweenChunks;
        this.authorizer.authorizeReadExistingDatasetById(metisUser, this.getDatasetIdFromExternalTaskId(externalTaskId));
        try {
            detailedTaskReportBetweenChunks = this.dpsClient.getDetailedTaskReportBetweenChunks(topologyName, externalTaskId, from, to);
        }
        catch (DpsException e) {
            throw new ExternalTaskException(String.format("Getting the task detailed logs failed. topologyName: %s, externalTaskId: %s, from: %s, to: %s", topologyName, externalTaskId, from, to), (Throwable)e);
        }
        for (SubTaskInfo subTaskInfo : detailedTaskReportBetweenChunks) {
            subTaskInfo.setAdditionalInformations(null);
        }
        return detailedTaskReportBetweenChunks;
    }

    public boolean existsExternalTaskReport(MetisUser metisUser, String topologyName, long externalTaskId) throws GenericMetisException {
        this.authorizer.authorizeReadExistingDatasetById(metisUser, this.getDatasetIdFromExternalTaskId(externalTaskId));
        return this.dpsClient.checkIfErrorReportExists(topologyName, externalTaskId);
    }

    public TaskErrorsInfo getExternalTaskReport(MetisUser metisUser, String topologyName, long externalTaskId, int idsPerError) throws GenericMetisException {
        TaskErrorsInfo taskErrorsInfo;
        this.authorizer.authorizeReadExistingDatasetById(metisUser, this.getDatasetIdFromExternalTaskId(externalTaskId));
        try {
            taskErrorsInfo = this.dpsClient.getTaskErrorsReport(topologyName, externalTaskId, null, idsPerError);
        }
        catch (DpsException e) {
            throw new ExternalTaskException(String.format("Getting the task error report failed. topologyName: %s, externalTaskId: %s, idsPerError: %s", topologyName, externalTaskId, idsPerError), (Throwable)e);
        }
        return taskErrorsInfo;
    }

    public RecordStatistics getExternalTaskStatistics(MetisUser metisUser, String topologyName, long externalTaskId) throws GenericMetisException {
        StatisticsReport report;
        this.authorizer.authorizeReadExistingDatasetById(metisUser, this.getDatasetIdFromExternalTaskId(externalTaskId));
        try {
            report = this.dpsClient.getTaskStatisticsReport(topologyName, externalTaskId);
        }
        catch (DpsException e) {
            throw new ExternalTaskException(String.format("Getting the task statistics failed. topologyName: %s, externalTaskId: %s", topologyName, externalTaskId), (Throwable)e);
        }
        return this.proxiesHelper.compileRecordStatistics(report);
    }

    public NodePathStatistics getAdditionalNodeStatistics(MetisUser metisUser, String topologyName, long externalTaskId, String nodePath) throws GenericMetisException {
        List nodeReports;
        this.authorizer.authorizeReadExistingDatasetById(metisUser, this.getDatasetIdFromExternalTaskId(externalTaskId));
        try {
            nodeReports = this.dpsClient.getElementReport(topologyName, externalTaskId, nodePath);
        }
        catch (DpsException e) {
            throw new ExternalTaskException(String.format("Getting the additional node statistics failed. topologyName: %s, externalTaskId: %s", topologyName, externalTaskId), (Throwable)e);
        }
        return this.proxiesHelper.compileNodePathStatistics(nodePath, nodeReports);
    }

    private String getDatasetIdFromExternalTaskId(long externalTaskId) throws NoWorkflowExecutionFoundException {
        WorkflowExecution workflowExecution = this.workflowExecutionDao.getByExternalTaskId(externalTaskId);
        if (workflowExecution == null) {
            throw new NoWorkflowExecutionFoundException(String.format("No workflow execution found for externalTaskId: %d, in METIS", externalTaskId));
        }
        return workflowExecution.getDatasetId();
    }

    public PaginatedRecordsResponse getListOfFileContentsFromPluginExecution(MetisUser metisUser, String workflowExecutionId, ExecutablePluginType pluginType, String nextPage, int numberOfRecords) throws GenericMetisException {
        String nextPageAfterResponse;
        ResultSlice resultSlice;
        Pair<WorkflowExecution, AbstractExecutablePlugin> executionAndPlugin = this.getExecutionAndPlugin(metisUser, workflowExecutionId, pluginType);
        if (executionAndPlugin == null) {
            return new PaginatedRecordsResponse(Collections.emptyList(), null);
        }
        String datasetId = ((WorkflowExecution)executionAndPlugin.getLeft()).getEcloudDatasetId();
        String representationName = AbstractMetisPlugin.getRepresentationName();
        String revisionName = ((AbstractExecutablePlugin)executionAndPlugin.getRight()).getPluginType().name();
        String revisionTimestamp = this.pluginDateFormatForEcloud.format(((AbstractExecutablePlugin)executionAndPlugin.getRight()).getStartedDate());
        try {
            resultSlice = this.ecloudDataSetServiceClient.getDataSetRevisionsChunk(this.ecloudProvider, datasetId, representationName, revisionName, this.ecloudProvider, revisionTimestamp, nextPage, Integer.valueOf(numberOfRecords));
            nextPageAfterResponse = resultSlice.getNextSlice();
        }
        catch (MCSException e) {
            throw new ExternalTaskException(String.format("Getting record list with file content failed. workflowExecutionId: %s, pluginType: %s", workflowExecutionId, pluginType), (Throwable)e);
        }
        ArrayList<Record> records = new ArrayList<Record>();
        for (CloudTagsResponse cloudTagsResponse : resultSlice.getResults()) {
            records.add(this.getRecord((AbstractExecutablePlugin)executionAndPlugin.getRight(), cloudTagsResponse.getCloudId()));
        }
        return new PaginatedRecordsResponse(records, nextPageAfterResponse);
    }

    public RecordsResponse getListOfFileContentsFromPluginExecution(MetisUser metisUser, String workflowExecutionId, ExecutablePluginType pluginType, ListOfIds ecloudIds) throws GenericMetisException {
        Pair<WorkflowExecution, AbstractExecutablePlugin> executionAndPlugin = this.getExecutionAndPlugin(metisUser, workflowExecutionId, pluginType);
        if (executionAndPlugin == null) {
            throw new NoWorkflowExecutionFoundException(String.format("No executable plugin of type %s found for workflowExecution with id: %s", pluginType.name(), workflowExecutionId));
        }
        ArrayList<Record> records = new ArrayList<Record>();
        for (String cloudId : ecloudIds.getIds()) {
            records.add(this.getRecord((AbstractExecutablePlugin)executionAndPlugin.getRight(), cloudId));
        }
        return new RecordsResponse(records);
    }

    Pair<WorkflowExecution, AbstractExecutablePlugin> getExecutionAndPlugin(MetisUser metisUser, String workflowExecutionId, ExecutablePluginType pluginType) throws GenericMetisException {
        WorkflowExecution workflowExecution = this.workflowExecutionDao.getById(workflowExecutionId);
        if (workflowExecution == null) {
            throw new NoWorkflowExecutionFoundException(String.format("No workflow execution found for workflowExecutionId: %s, in METIS", workflowExecutionId));
        }
        this.authorizer.authorizeReadExistingDatasetById(metisUser, workflowExecution.getDatasetId());
        AbstractMetisPlugin plugin = workflowExecution.getMetisPluginWithType(pluginType.toPluginType()).orElse(null);
        if (plugin instanceof AbstractExecutablePlugin) {
            return new ImmutablePair((Object)workflowExecution, (Object)((AbstractExecutablePlugin)plugin));
        }
        return null;
    }

    Record getRecord(AbstractExecutablePlugin plugin, String ecloudId) throws ExternalTaskException {
        try {
            Representation representation = this.recordServiceClient.getRepresentationByRevision(ecloudId, AbstractMetisPlugin.getRepresentationName(), plugin.getPluginType().name(), this.ecloudProvider, this.pluginDateFormatForEcloud.format(plugin.getStartedDate()));
            InputStream inputStream = this.fileServiceClient.getFile(((File)representation.getFiles().get(0)).getContentUri().toString());
            return new Record(ecloudId, IOUtils.toString((InputStream)inputStream, (String)StandardCharsets.UTF_8.name()));
        }
        catch (MCSException e) {
            throw new ExternalTaskException(String.format("Getting record list with file content failed. externalTaskId: %s, pluginType: %s", plugin.getExternalTaskId(), plugin.getPluginType()), (Throwable)e);
        }
        catch (IOException e) {
            throw new ExternalTaskException("Getting while reading the contents of the file.", (Throwable)e);
        }
    }

    String getEcloudProvider() {
        return this.ecloudProvider;
    }
}

