/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.metis.core.service;

import eu.europeana.cloud.common.model.dps.AttributeStatistics;
import eu.europeana.cloud.common.model.dps.NodeReport;
import eu.europeana.cloud.common.model.dps.NodeStatistics;
import eu.europeana.cloud.common.model.dps.StatisticsReport;
import eu.europeana.metis.core.rest.stats.NodePathStatistics;
import eu.europeana.metis.core.rest.stats.NodeValueStatistics;
import eu.europeana.metis.core.rest.stats.RecordStatistics;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

class ProxiesHelper {
    ProxiesHelper() {
    }

    RecordStatistics compileRecordStatistics(StatisticsReport report) {
        Map<String, List<NodeStatistics>> nodesByXPath = report.getNodeStatistics().stream().collect(Collectors.groupingBy(NodeStatistics::getXpath));
        List nodePathStatisticsList = nodesByXPath.entrySet().stream().map(ProxiesHelper::compileNodePathStatistics).sorted(Comparator.comparing(NodePathStatistics::getxPath)).collect(Collectors.toList());
        RecordStatistics result = new RecordStatistics();
        result.setNodePathStatistics(nodePathStatisticsList);
        result.setTaskId(report.getTaskId());
        return result;
    }

    private static NodePathStatistics compileNodePathStatistics(Map.Entry<String, List<NodeStatistics>> nodeWithXPath) {
        return ProxiesHelper.compileNodePathStatistics(nodeWithXPath.getKey(), nodeWithXPath.getValue(), ProxiesHelper::compileNodeValueStatistics);
    }

    NodePathStatistics compileNodePathStatistics(String nodePath, List<NodeReport> nodeReports) {
        return ProxiesHelper.compileNodePathStatistics(nodePath, nodeReports, ProxiesHelper::compileNodeValueStatistics);
    }

    private static <I> NodePathStatistics compileNodePathStatistics(String nodePath, List<I> nodes, Function<I, NodeValueStatistics> nodeValueConverter) {
        List nodeValueStatisticsList = nodes.stream().map(nodeValueConverter).sorted(Comparator.comparing(NodeValueStatistics::getValue)).collect(Collectors.toList());
        NodePathStatistics nodePathStatistics = new NodePathStatistics();
        nodePathStatistics.setxPath(nodePath);
        nodePathStatistics.setNodeValueStatistics(nodeValueStatisticsList);
        return nodePathStatistics;
    }

    private static NodeValueStatistics compileNodeValueStatistics(NodeStatistics nodeStatistics) {
        return ProxiesHelper.compileNodeValueStatistics(nodeStatistics.getValue(), nodeStatistics.getOccurrence(), nodeStatistics.getAttributesStatistics());
    }

    private static NodeValueStatistics compileNodeValueStatistics(NodeReport nodeReport) {
        return ProxiesHelper.compileNodeValueStatistics(nodeReport.getNodeValue(), nodeReport.getOccurrence(), nodeReport.getAttributeStatistics());
    }

    private static NodeValueStatistics compileNodeValueStatistics(String nodeValue, long occurrence, Collection<AttributeStatistics> attributes) {
        List attributeStatistics = attributes.stream().map(ProxiesHelper::compileAttributeStatistics).sorted(Comparator.comparing(eu.europeana.metis.core.rest.stats.AttributeStatistics::getxPath).thenComparing(eu.europeana.metis.core.rest.stats.AttributeStatistics::getValue)).collect(Collectors.toList());
        NodeValueStatistics nodeValueStatistics = new NodeValueStatistics();
        nodeValueStatistics.setValue(nodeValue);
        nodeValueStatistics.setOccurrences(occurrence);
        nodeValueStatistics.setAttributeStatistics(attributeStatistics);
        return nodeValueStatistics;
    }

    private static eu.europeana.metis.core.rest.stats.AttributeStatistics compileAttributeStatistics(AttributeStatistics input) {
        eu.europeana.metis.core.rest.stats.AttributeStatistics attributeStatistics = new eu.europeana.metis.core.rest.stats.AttributeStatistics();
        attributeStatistics.setxPath(input.getName());
        attributeStatistics.setValue(input.getValue());
        attributeStatistics.setOccurrences(input.getOccurrence());
        return attributeStatistics;
    }
}

