/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.metis.core.service;

import eu.europeana.metis.RestEndpoints;
import eu.europeana.metis.core.dao.DatasetXsltDao;
import eu.europeana.metis.core.dao.WorkflowExecutionDao;
import eu.europeana.metis.core.dataset.Dataset;
import eu.europeana.metis.core.dataset.DatasetXslt;
import eu.europeana.metis.core.exceptions.PluginExecutionNotAllowed;
import eu.europeana.metis.core.execution.ExecutionRules;
import eu.europeana.metis.core.workflow.ValidationProperties;
import eu.europeana.metis.core.workflow.Workflow;
import eu.europeana.metis.core.workflow.WorkflowExecution;
import eu.europeana.metis.core.workflow.plugins.AbstractExecutablePlugin;
import eu.europeana.metis.core.workflow.plugins.AbstractExecutablePluginMetadata;
import eu.europeana.metis.core.workflow.plugins.AbstractMetisPlugin;
import eu.europeana.metis.core.workflow.plugins.AbstractMetisPluginMetadata;
import eu.europeana.metis.core.workflow.plugins.DataStatus;
import eu.europeana.metis.core.workflow.plugins.ExecutablePluginType;
import eu.europeana.metis.core.workflow.plugins.HTTPHarvestPluginMetadata;
import eu.europeana.metis.core.workflow.plugins.IndexToPreviewPluginMetadata;
import eu.europeana.metis.core.workflow.plugins.IndexToPublishPluginMetadata;
import eu.europeana.metis.core.workflow.plugins.LinkCheckingPluginMetadata;
import eu.europeana.metis.core.workflow.plugins.OaipmhHarvestPluginMetadata;
import eu.europeana.metis.core.workflow.plugins.PluginType;
import eu.europeana.metis.core.workflow.plugins.TransformationPluginMetadata;
import eu.europeana.metis.core.workflow.plugins.ValidationExternalPluginMetadata;
import eu.europeana.metis.core.workflow.plugins.ValidationInternalPluginMetadata;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.bson.types.ObjectId;

public class OrchestratorHelper {
    private final WorkflowExecutionDao workflowExecutionDao;
    private final DatasetXsltDao datasetXsltDao;
    private ValidationProperties validationExternalProperties;
    private ValidationProperties validationInternalProperties;
    private String metisCoreUrl;
    private boolean metisUseAlternativeIndexingEnvironment;
    private int defaultSamplingSizeForLinkChecking;

    public OrchestratorHelper(WorkflowExecutionDao workflowExecutionDao, DatasetXsltDao datasetXsltDao) {
        this.workflowExecutionDao = workflowExecutionDao;
        this.datasetXsltDao = datasetXsltDao;
    }

    void validateAndTrimHarvestParameters(Workflow workflow) throws MalformedURLException, URISyntaxException {
        HTTPHarvestPluginMetadata httpHarvestPluginMetadata;
        OaipmhHarvestPluginMetadata oaipmhPluginMetadata = (OaipmhHarvestPluginMetadata)workflow.getPluginMetadata(ExecutablePluginType.OAIPMH_HARVEST);
        if (oaipmhPluginMetadata != null) {
            URL url = new URL(oaipmhPluginMetadata.getUrl().trim());
            URI validatedUri = url.toURI();
            String urlWithoutQueryParameters = new URI(validatedUri.getScheme(), validatedUri.getAuthority(), validatedUri.getPath(), null, null).toString();
            oaipmhPluginMetadata.setUrl(urlWithoutQueryParameters);
            oaipmhPluginMetadata.setMetadataFormat(oaipmhPluginMetadata.getMetadataFormat() == null ? null : oaipmhPluginMetadata.getMetadataFormat().trim());
            oaipmhPluginMetadata.setSetSpec(oaipmhPluginMetadata.getSetSpec() == null ? null : oaipmhPluginMetadata.getSetSpec().trim());
        }
        if ((httpHarvestPluginMetadata = (HTTPHarvestPluginMetadata)workflow.getPluginMetadata(ExecutablePluginType.HTTP_HARVEST)) != null) {
            URL u = new URL(httpHarvestPluginMetadata.getUrl().trim());
            u.toURI();
            httpHarvestPluginMetadata.setUrl(httpHarvestPluginMetadata.getUrl().trim());
        }
    }

    private boolean doesPluginHaveAllErrorRecords(AbstractExecutablePlugin plugin) {
        return plugin != null && plugin.getExecutionProgress() != null && plugin.getExecutionProgress().getProcessedRecords() == plugin.getExecutionProgress().getErrors();
    }

    boolean addHarvestingPlugin(Dataset dataset, Workflow workflow, List<AbstractExecutablePlugin> metisPlugins) {
        AbstractExecutablePlugin plugin;
        OaipmhHarvestPluginMetadata oaipmhMetadata = (OaipmhHarvestPluginMetadata)workflow.getPluginMetadata(ExecutablePluginType.OAIPMH_HARVEST);
        HTTPHarvestPluginMetadata httpMetadata = (HTTPHarvestPluginMetadata)workflow.getPluginMetadata(ExecutablePluginType.HTTP_HARVEST);
        if (oaipmhMetadata != null && oaipmhMetadata.isEnabled()) {
            plugin = OrchestratorHelper.createPlugin((AbstractExecutablePluginMetadata)oaipmhMetadata);
            oaipmhMetadata.setDatasetId(dataset.getDatasetId());
        } else if (httpMetadata != null && httpMetadata.isEnabled()) {
            plugin = OrchestratorHelper.createPlugin((AbstractExecutablePluginMetadata)httpMetadata);
            httpMetadata.setDatasetId(dataset.getDatasetId());
        } else {
            plugin = null;
        }
        if (plugin != null) {
            metisPlugins.add(plugin);
            return true;
        }
        return false;
    }

    boolean addNonHarvestPlugins(Dataset dataset, Workflow workflow, ExecutablePluginType enforcedPluginType, List<AbstractExecutablePlugin> metisPlugins, boolean firstPluginDefined) throws PluginExecutionNotAllowed {
        firstPluginDefined = this.addNonHarvestPlugin(dataset, workflow, enforcedPluginType, metisPlugins, firstPluginDefined, ExecutablePluginType.VALIDATION_EXTERNAL);
        firstPluginDefined = this.addNonHarvestPlugin(dataset, workflow, enforcedPluginType, metisPlugins, firstPluginDefined, ExecutablePluginType.TRANSFORMATION);
        firstPluginDefined = this.addNonHarvestPlugin(dataset, workflow, enforcedPluginType, metisPlugins, firstPluginDefined, ExecutablePluginType.VALIDATION_INTERNAL);
        firstPluginDefined = this.addNonHarvestPlugin(dataset, workflow, enforcedPluginType, metisPlugins, firstPluginDefined, ExecutablePluginType.NORMALIZATION);
        firstPluginDefined = this.addNonHarvestPlugin(dataset, workflow, enforcedPluginType, metisPlugins, firstPluginDefined, ExecutablePluginType.ENRICHMENT);
        firstPluginDefined = this.addNonHarvestPlugin(dataset, workflow, enforcedPluginType, metisPlugins, firstPluginDefined, ExecutablePluginType.MEDIA_PROCESS);
        firstPluginDefined = this.addNonHarvestPlugin(dataset, workflow, enforcedPluginType, metisPlugins, firstPluginDefined, ExecutablePluginType.LINK_CHECKING);
        firstPluginDefined = this.addNonHarvestPlugin(dataset, workflow, enforcedPluginType, metisPlugins, firstPluginDefined, ExecutablePluginType.PREVIEW);
        firstPluginDefined = this.addNonHarvestPlugin(dataset, workflow, enforcedPluginType, metisPlugins, firstPluginDefined, ExecutablePluginType.PUBLISH);
        return firstPluginDefined;
    }

    private boolean addNonHarvestPlugin(Dataset dataset, Workflow workflow, ExecutablePluginType enforcedPluginType, List<AbstractExecutablePlugin> metisPlugins, boolean firstPluginDefined, ExecutablePluginType pluginType) throws PluginExecutionNotAllowed {
        AbstractExecutablePluginMetadata pluginMetadata = workflow.getPluginMetadata(pluginType);
        if (pluginMetadata != null && pluginMetadata.isEnabled()) {
            if (!firstPluginDefined) {
                AbstractExecutablePlugin previousPlugin = this.getLatestFinishedPluginByDatasetIdIfPluginTypeAllowedForExecution(dataset.getDatasetId(), pluginMetadata.getExecutablePluginType(), enforcedPluginType);
                pluginMetadata.setPreviousRevisionInformation(previousPlugin);
            }
            if (ExecutionRules.getHarvestPluginGroup().contains(pluginType)) {
                throw new PluginExecutionNotAllowed("Plugin Execution Not Allowed");
            }
            switch (pluginType) {
                case TRANSFORMATION: {
                    this.setupXsltUrlForPluginMetadata(dataset, (TransformationPluginMetadata)pluginMetadata);
                    break;
                }
                case VALIDATION_EXTERNAL: {
                    this.setupValidationForPluginMetadata(pluginMetadata, this.getValidationExternalProperties());
                    break;
                }
                case VALIDATION_INTERNAL: {
                    this.setupValidationForPluginMetadata(pluginMetadata, this.getValidationInternalProperties());
                    break;
                }
                case PREVIEW: {
                    ((IndexToPreviewPluginMetadata)pluginMetadata).setDatasetId(dataset.getDatasetId());
                    ((IndexToPreviewPluginMetadata)pluginMetadata).setUseAlternativeIndexingEnvironment(this.getMetisUseAlternativeIndexingEnvironment());
                    break;
                }
                case PUBLISH: {
                    ((IndexToPublishPluginMetadata)pluginMetadata).setDatasetId(dataset.getDatasetId());
                    ((IndexToPublishPluginMetadata)pluginMetadata).setUseAlternativeIndexingEnvironment(this.getMetisUseAlternativeIndexingEnvironment());
                    break;
                }
                case LINK_CHECKING: {
                    ((LinkCheckingPluginMetadata)pluginMetadata).setSampleSize(Integer.valueOf(this.getDefaultSamplingSizeForLinkChecking()));
                    break;
                }
            }
            AbstractExecutablePlugin plugin = OrchestratorHelper.createPlugin(pluginMetadata);
            metisPlugins.add(plugin);
            firstPluginDefined = true;
        }
        return firstPluginDefined;
    }

    private static AbstractExecutablePlugin createPlugin(AbstractExecutablePluginMetadata metadata) {
        AbstractExecutablePlugin plugin = metadata.getExecutablePluginType().getNewPlugin((AbstractMetisPluginMetadata)metadata);
        plugin.setId(new ObjectId().toString() + "-" + plugin.getPluginType().name());
        plugin.setDataStatus(DataStatus.NOT_YET_GENERATED);
        return plugin;
    }

    private void setupValidationForPluginMetadata(AbstractExecutablePluginMetadata metadata, ValidationProperties validationProperties) {
        if (metadata instanceof ValidationExternalPluginMetadata) {
            ValidationExternalPluginMetadata castMetadata = (ValidationExternalPluginMetadata)metadata;
            castMetadata.setUrlOfSchemasZip(validationProperties.getUrlOfSchemasZip());
            castMetadata.setSchemaRootPath(validationProperties.getSchemaRootPath());
            castMetadata.setSchematronRootPath(validationProperties.getSchematronRootPath());
        } else if (metadata instanceof ValidationInternalPluginMetadata) {
            ValidationInternalPluginMetadata castMetadata = (ValidationInternalPluginMetadata)metadata;
            castMetadata.setUrlOfSchemasZip(validationProperties.getUrlOfSchemasZip());
            castMetadata.setSchemaRootPath(validationProperties.getSchemaRootPath());
            castMetadata.setSchematronRootPath(validationProperties.getSchematronRootPath());
        } else {
            throw new IllegalArgumentException("The provided metadata does not have the right type. Expecting metadata for a validation plugin, but instead received metadata of type " + metadata.getClass().getName() + ".");
        }
    }

    boolean checkWorkflowForPluginType(Workflow workflow, ExecutablePluginType pluginType) {
        Set<ExecutablePluginType> pluginTypesSetThatPluginTypeCanBeBasedOn = ExecutionRules.getPluginTypesSetThatPluginTypeCanBeBasedOn(pluginType);
        return workflow.pluginTypeOccursOnlyAfter(pluginType, pluginTypesSetThatPluginTypeCanBeBasedOn);
    }

    void overwriteNewPluginMetadataOnWorkflowAndDisableOtherPluginMetadata(Workflow workflow, Workflow storedWorkflow) {
        workflow.getMetisPluginsMetadata().forEach(pluginMetadata -> pluginMetadata.setEnabled(true));
        List storedPluginsExcludingNewPlugins = storedWorkflow.getMetisPluginsMetadata().stream().filter(pluginMetadata -> workflow.getPluginMetadata(pluginMetadata.getExecutablePluginType()) == null).peek(pluginMetadata -> pluginMetadata.setEnabled(false)).collect(Collectors.toList());
        workflow.setMetisPluginsMetadata(Stream.concat(storedPluginsExcludingNewPlugins.stream(), workflow.getMetisPluginsMetadata().stream()).collect(Collectors.toList()));
    }

    public AbstractExecutablePlugin getLatestFinishedPluginByDatasetIdIfPluginTypeAllowedForExecution(String datasetId, ExecutablePluginType pluginType, ExecutablePluginType enforcedPluginType) throws PluginExecutionNotAllowed {
        AbstractExecutablePlugin latestFinishedPluginIfRequestedPluginAllowedForExecution = ExecutionRules.getLatestFinishedPluginIfRequestedPluginAllowedForExecution(pluginType, enforcedPluginType, datasetId, this.workflowExecutionDao);
        if (latestFinishedPluginIfRequestedPluginAllowedForExecution == null && !ExecutionRules.getHarvestPluginGroup().contains(pluginType) || this.doesPluginHaveAllErrorRecords(latestFinishedPluginIfRequestedPluginAllowedForExecution)) {
            throw new PluginExecutionNotAllowed("Plugin Execution Not Allowed");
        }
        return latestFinishedPluginIfRequestedPluginAllowedForExecution;
    }

    private void setupXsltUrlForPluginMetadata(Dataset dataset, TransformationPluginMetadata pluginMetadata) {
        DatasetXslt xsltObject = pluginMetadata.isCustomXslt() ? this.datasetXsltDao.getById(dataset.getXsltId().toString()) : this.datasetXsltDao.getLatestXsltForDatasetId("-1");
        if (xsltObject != null && StringUtils.isNotEmpty((CharSequence)xsltObject.getXslt())) {
            pluginMetadata.setXsltUrl(this.getMetisCoreUrl() + RestEndpoints.resolve((String)"/datasets/xslt/{xsltId}", Collections.singletonList(xsltObject.getId().toString())));
        }
        pluginMetadata.setDatasetId(dataset.getDatasetId());
        pluginMetadata.setDatasetName(dataset.getDatasetId() + "_" + dataset.getDatasetName());
        pluginMetadata.setCountry(dataset.getCountry().getName());
        pluginMetadata.setLanguage(dataset.getLanguage().name().toLowerCase(Locale.US));
    }

    Pair<WorkflowExecution, AbstractMetisPlugin> getPreviousExecutionAndPlugin(AbstractMetisPlugin plugin, String datasetId) {
        AbstractMetisPlugin previousPlugin;
        Date previousPluginTimestamp = plugin.getPluginMetadata().getRevisionTimestampPreviousPlugin();
        PluginType previousPluginType = PluginType.getPluginTypeFromEnumName((String)plugin.getPluginMetadata().getRevisionNamePreviousPlugin());
        if (previousPluginTimestamp == null || previousPluginType == null) {
            return null;
        }
        WorkflowExecution previousExecution = this.workflowExecutionDao.getByTaskExecution(previousPluginTimestamp, previousPluginType, datasetId);
        AbstractMetisPlugin abstractMetisPlugin = previousPlugin = previousExecution == null ? null : (AbstractMetisPlugin)previousExecution.getMetisPluginWithType(previousPluginType).orElse(null);
        if (previousExecution == null || previousPlugin == null) {
            return null;
        }
        return new ImmutablePair((Object)previousExecution, (Object)previousPlugin);
    }

    <T> boolean listContainsDuplicates(List<T> list) {
        return !list.stream().allMatch(new HashSet()::add);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ValidationProperties getValidationExternalProperties() {
        OrchestratorHelper orchestratorHelper = this;
        synchronized (orchestratorHelper) {
            return this.validationExternalProperties;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setValidationExternalProperties(ValidationProperties validationExternalProperties) {
        OrchestratorHelper orchestratorHelper = this;
        synchronized (orchestratorHelper) {
            this.validationExternalProperties = validationExternalProperties;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ValidationProperties getValidationInternalProperties() {
        OrchestratorHelper orchestratorHelper = this;
        synchronized (orchestratorHelper) {
            return this.validationInternalProperties;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setValidationInternalProperties(ValidationProperties validationInternalProperties) {
        OrchestratorHelper orchestratorHelper = this;
        synchronized (orchestratorHelper) {
            this.validationInternalProperties = validationInternalProperties;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMetisCoreUrl(String metisCoreUrl) {
        OrchestratorHelper orchestratorHelper = this;
        synchronized (orchestratorHelper) {
            this.metisCoreUrl = metisCoreUrl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getMetisCoreUrl() {
        OrchestratorHelper orchestratorHelper = this;
        synchronized (orchestratorHelper) {
            return this.metisCoreUrl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean getMetisUseAlternativeIndexingEnvironment() {
        OrchestratorHelper orchestratorHelper = this;
        synchronized (orchestratorHelper) {
            return this.metisUseAlternativeIndexingEnvironment;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMetisUseAlternativeIndexingEnvironment(boolean metisUseAlternativeIndexingEnvironment) {
        OrchestratorHelper orchestratorHelper = this;
        synchronized (orchestratorHelper) {
            this.metisUseAlternativeIndexingEnvironment = metisUseAlternativeIndexingEnvironment;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getDefaultSamplingSizeForLinkChecking() {
        OrchestratorHelper orchestratorHelper = this;
        synchronized (orchestratorHelper) {
            return this.defaultSamplingSizeForLinkChecking;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDefaultSamplingSizeForLinkChecking(int defaultSamplingSizeForLinkChecking) {
        OrchestratorHelper orchestratorHelper = this;
        synchronized (orchestratorHelper) {
            this.defaultSamplingSizeForLinkChecking = defaultSamplingSizeForLinkChecking;
        }
    }
}

