/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.metis.core.service;

import eu.europeana.metis.RestEndpoints;
import eu.europeana.metis.authentication.user.MetisUser;
import eu.europeana.metis.core.dao.DatasetDao;
import eu.europeana.metis.core.dao.DatasetXsltDao;
import eu.europeana.metis.core.dao.ScheduledWorkflowDao;
import eu.europeana.metis.core.dao.WorkflowDao;
import eu.europeana.metis.core.dao.WorkflowExecutionDao;
import eu.europeana.metis.core.dataset.Dataset;
import eu.europeana.metis.core.dataset.DatasetXslt;
import eu.europeana.metis.core.exceptions.DatasetAlreadyExistsException;
import eu.europeana.metis.core.exceptions.NoXsltFoundException;
import eu.europeana.metis.core.exceptions.XsltSetupException;
import eu.europeana.metis.core.rest.Record;
import eu.europeana.metis.core.service.Authorizer;
import eu.europeana.metis.exception.BadContentException;
import eu.europeana.metis.exception.GenericMetisException;
import eu.europeana.metis.transformation.service.EuropeanaGeneratedIdsMap;
import eu.europeana.metis.transformation.service.EuropeanaIdCreator;
import eu.europeana.metis.transformation.service.EuropeanaIdException;
import eu.europeana.metis.transformation.service.TransformationException;
import eu.europeana.metis.transformation.service.XsltTransformer;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import org.bson.types.ObjectId;
import org.redisson.api.RLock;
import org.redisson.api.RedissonClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DatasetService {
    private static final Logger LOGGER = LoggerFactory.getLogger(DatasetService.class);
    private static final String DATASET_CREATION_LOCK = "datasetCreationLock";
    private final Authorizer authorizer;
    private final DatasetDao datasetDao;
    private final DatasetXsltDao datasetXsltDao;
    private final WorkflowDao workflowDao;
    private final WorkflowExecutionDao workflowExecutionDao;
    private final ScheduledWorkflowDao scheduledWorkflowDao;
    private final RedissonClient redissonClient;
    private String metisCoreUrl;

    @Autowired
    public DatasetService(DatasetDao datasetDao, DatasetXsltDao datasetXsltDao, WorkflowDao workflowDao, WorkflowExecutionDao workflowExecutionDao, ScheduledWorkflowDao scheduledWorkflowDao, RedissonClient redissonClient, Authorizer authorizer) {
        this.datasetDao = datasetDao;
        this.datasetXsltDao = datasetXsltDao;
        this.workflowDao = workflowDao;
        this.workflowExecutionDao = workflowExecutionDao;
        this.scheduledWorkflowDao = scheduledWorkflowDao;
        this.redissonClient = redissonClient;
        this.authorizer = authorizer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Dataset createDataset(MetisUser metisUser, Dataset dataset) throws GenericMetisException {
        Dataset datasetObjectId;
        this.authorizer.authorizeWriteNewDataset(metisUser);
        dataset.setOrganizationId(metisUser.getOrganizationId());
        dataset.setOrganizationName(metisUser.getOrganizationName());
        RLock lock = this.redissonClient.getFairLock(DATASET_CREATION_LOCK);
        lock.lock();
        try {
            Dataset storedDataset = this.datasetDao.getDatasetByOrganizationIdAndDatasetName(dataset.getOrganizationId(), dataset.getDatasetName());
            if (storedDataset != null) {
                lock.unlock();
                throw new DatasetAlreadyExistsException(String.format("Dataset with organizationId: %s and datasetName: %s already exists..", dataset.getOrganizationId(), dataset.getDatasetName()));
            }
            dataset.setCreatedByUserId(metisUser.getUserId());
            dataset.setId(null);
            dataset.setUpdatedDate(null);
            dataset.setCreatedDate(new Date());
            dataset.setEcloudDatasetId(String.format("NOT_CREATED_YET-%s", UUID.randomUUID().toString()));
            int nextInSequenceDatasetId = this.datasetDao.findNextInSequenceDatasetId();
            dataset.setDatasetId(Integer.toString(nextInSequenceDatasetId));
            datasetObjectId = this.datasetDao.getById(this.datasetDao.create(dataset));
        }
        finally {
            lock.unlock();
        }
        return datasetObjectId;
    }

    public void updateDataset(MetisUser metisUser, Dataset dataset, String xsltString) throws GenericMetisException {
        Dataset storedDataset = this.authorizer.authorizeWriteExistingDatasetById(metisUser, dataset.getDatasetId());
        String newDatasetName = dataset.getDatasetName();
        if (!storedDataset.getDatasetName().equals(newDatasetName) && this.datasetDao.getDatasetByOrganizationIdAndDatasetName(metisUser.getOrganizationId(), newDatasetName) != null) {
            throw new DatasetAlreadyExistsException(String.format("Trying to change dataset with datasetName: %s but dataset with organizationId: %s and datasetName: %s already exists", storedDataset.getDatasetName(), metisUser.getOrganizationId(), newDatasetName));
        }
        if (this.workflowExecutionDao.existsAndNotCompleted(dataset.getDatasetId()) != null) {
            throw new BadContentException(String.format("Workflow execution is active for datasteId %s", dataset.getDatasetId()));
        }
        dataset.setOrganizationId(metisUser.getOrganizationId());
        dataset.setOrganizationName(metisUser.getOrganizationName());
        dataset.setCreatedByUserId(storedDataset.getCreatedByUserId());
        dataset.setEcloudDatasetId(storedDataset.getEcloudDatasetId());
        dataset.setCreatedDate(storedDataset.getCreatedDate());
        dataset.setOrganizationId(storedDataset.getOrganizationId());
        dataset.setOrganizationName(storedDataset.getOrganizationName());
        dataset.setCreatedByUserId(storedDataset.getCreatedByUserId());
        dataset.setId(storedDataset.getId());
        if (xsltString == null) {
            dataset.setXsltId(storedDataset.getXsltId());
        } else {
            dataset.setXsltId(new ObjectId(this.datasetXsltDao.create(new DatasetXslt(dataset.getDatasetId(), xsltString))));
        }
        dataset.setUpdatedDate(new Date());
        this.datasetDao.update(dataset);
    }

    public void deleteDatasetByDatasetId(MetisUser metisUser, String datasetId) throws GenericMetisException {
        this.authorizer.authorizeWriteExistingDatasetById(metisUser, datasetId);
        if (this.workflowExecutionDao.existsAndNotCompleted(datasetId) != null) {
            throw new BadContentException(String.format("Workflow execution is active for datasteId %s", datasetId));
        }
        this.datasetDao.deleteByDatasetId(datasetId);
        this.datasetXsltDao.deleteAllByDatasetId(datasetId);
        this.workflowDao.deleteWorkflow(datasetId);
        this.workflowExecutionDao.deleteAllByDatasetId(datasetId);
        this.scheduledWorkflowDao.deleteAllByDatasetId(datasetId);
    }

    public Dataset getDatasetByDatasetName(MetisUser metisUser, String datasetName) throws GenericMetisException {
        return this.authorizer.authorizeReadExistingDatasetByName(metisUser, datasetName);
    }

    public Dataset getDatasetByDatasetId(MetisUser metisUser, String datasetId) throws GenericMetisException {
        return this.authorizer.authorizeReadExistingDatasetById(metisUser, datasetId);
    }

    public DatasetXslt getDatasetXsltByDatasetId(MetisUser metisUser, String datasetId) throws GenericMetisException {
        Dataset dataset = this.authorizer.authorizeReadExistingDatasetById(metisUser, datasetId);
        DatasetXslt datasetXslt = this.datasetXsltDao.getById(dataset.getXsltId() == null ? null : dataset.getXsltId().toString());
        if (datasetXslt == null) {
            throw new NoXsltFoundException(String.format("No datasetXslt found for dataset with datasetId: '%s' and xsltId: '%s' in METIS", datasetId, dataset.getXsltId()));
        }
        return datasetXslt;
    }

    public DatasetXslt getDatasetXsltByXsltId(String xsltId) throws GenericMetisException {
        DatasetXslt datasetXslt = this.datasetXsltDao.getById(xsltId);
        if (datasetXslt == null) {
            throw new NoXsltFoundException(String.format("No datasetXslt found with xsltId: '%s' in METIS", xsltId));
        }
        return datasetXslt;
    }

    public DatasetXslt createDefaultXslt(MetisUser metisUser, String xsltString) throws GenericMetisException {
        this.authorizer.authorizeWriteDefaultXslt(metisUser);
        DatasetXslt datasetXslt = null;
        if (xsltString != null) {
            datasetXslt = this.datasetXsltDao.getById(this.datasetXsltDao.create(new DatasetXslt("-1", xsltString)));
        }
        return datasetXslt;
    }

    public DatasetXslt getLatestXsltForDatasetId(String datasetId) throws GenericMetisException {
        DatasetXslt datasetXslt = this.datasetXsltDao.getLatestXsltForDatasetId(datasetId);
        if (datasetXslt == null) {
            throw new NoXsltFoundException("No default datasetXslt found");
        }
        return datasetXslt;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Record> transformRecordsUsingLatestDefaultXslt(MetisUser metisUser, String datasetId, List<Record> records) throws GenericMetisException {
        String xsltUrl;
        Dataset dataset = this.authorizer.authorizeWriteExistingDatasetById(metisUser, datasetId);
        DatasetXslt datasetXslt = this.datasetXsltDao.getLatestXsltForDatasetId("-1");
        if (datasetXslt == null) {
            throw new NoXsltFoundException("Could not find default xslt");
        }
        DatasetService datasetService = this;
        synchronized (datasetService) {
            xsltUrl = this.metisCoreUrl + RestEndpoints.resolve((String)"/datasets/xslt/{xsltId}", Collections.singletonList(datasetXslt.getId().toString()));
        }
        return this.transformRecords(dataset, records, xsltUrl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Record> transformRecordsUsingLatestDatasetXslt(MetisUser metisUser, String datasetId, List<Record> records) throws GenericMetisException {
        String xsltUrl;
        Dataset dataset = this.authorizer.authorizeWriteExistingDatasetById(metisUser, datasetId);
        if (dataset.getXsltId() == null) {
            throw new NoXsltFoundException(String.format("Could not find xslt for datasetId %s", datasetId));
        }
        DatasetXslt datasetXslt = this.datasetXsltDao.getById(dataset.getXsltId().toString());
        DatasetService datasetService = this;
        synchronized (datasetService) {
            xsltUrl = this.metisCoreUrl + RestEndpoints.resolve((String)"/datasets/xslt/{xsltId}", Collections.singletonList(datasetXslt.getId().toString()));
        }
        return this.transformRecords(dataset, records, xsltUrl);
    }

    private List<Record> transformRecords(Dataset dataset, List<Record> records, String xsltUrl) throws XsltSetupException {
        EuropeanaIdCreator europeanIdCreator;
        XsltTransformer transformer;
        try {
            transformer = new XsltTransformer(xsltUrl, dataset.getDatasetName(), dataset.getCountry().getName(), dataset.getLanguage().name());
            europeanIdCreator = new EuropeanaIdCreator();
        }
        catch (TransformationException e) {
            LOGGER.info("Transformation setup failed.", (Throwable)e);
            throw new XsltSetupException("Could not setup XSL transformation.", (Exception)((Object)e));
        }
        catch (EuropeanaIdException e) {
            LOGGER.info("EuropeanaIdCreator initialization failed.", (Throwable)e);
            throw new XsltSetupException("EuropeanaIdCreator initialization failed.", (Exception)((Object)e));
        }
        return records.stream().map(record -> {
            try {
                EuropeanaGeneratedIdsMap europeanaGeneratedIdsMap = europeanIdCreator.constructEuropeanaId(record.getXmlRecord(), dataset.getDatasetId());
                return new Record(record.getEcloudId(), transformer.transform(record.getXmlRecord().getBytes(StandardCharsets.UTF_8), europeanaGeneratedIdsMap).toString());
            }
            catch (TransformationException e) {
                LOGGER.info("Record from list failed transformation", (Throwable)e);
                return new Record(record.getEcloudId(), e.getMessage());
            }
            catch (EuropeanaIdException e) {
                LOGGER.info("EuropeanaIdCreator initialization failed.", (Throwable)e);
                return new Record(record.getEcloudId(), e.getMessage());
            }
        }).collect(Collectors.toList());
    }

    public List<Dataset> getAllDatasetsByProvider(MetisUser metisUser, String provider, int nextPage) throws GenericMetisException {
        this.authorizer.authorizeReadAllDatasets(metisUser);
        return this.datasetDao.getAllDatasetsByProvider(provider, nextPage);
    }

    public List<Dataset> getAllDatasetsByIntermediateProvider(MetisUser metisUser, String intermediateProvider, int nextPage) throws GenericMetisException {
        this.authorizer.authorizeReadAllDatasets(metisUser);
        return this.datasetDao.getAllDatasetsByIntermediateProvider(intermediateProvider, nextPage);
    }

    public List<Dataset> getAllDatasetsByDataProvider(MetisUser metisUser, String dataProvider, int nextPage) throws GenericMetisException {
        this.authorizer.authorizeReadAllDatasets(metisUser);
        return this.datasetDao.getAllDatasetsByDataProvider(dataProvider, nextPage);
    }

    public List<Dataset> getAllDatasetsByOrganizationId(MetisUser metisUser, String organizationId, int nextPage) throws GenericMetisException {
        this.authorizer.authorizeReadAllDatasets(metisUser);
        return this.datasetDao.getAllDatasetsByOrganizationId(organizationId, nextPage);
    }

    public List<Dataset> getAllDatasetsByOrganizationName(MetisUser metisUser, String organizationName, int nextPage) throws GenericMetisException {
        this.authorizer.authorizeReadAllDatasets(metisUser);
        return this.datasetDao.getAllDatasetsByOrganizationName(organizationName, nextPage);
    }

    public int getDatasetsPerRequestLimit() {
        return this.datasetDao.getDatasetsPerRequest();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMetisCoreUrl(String metisCoreUrl) {
        DatasetService datasetService = this;
        synchronized (datasetService) {
            this.metisCoreUrl = metisCoreUrl;
        }
    }
}

