/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.metis.core.service;

import eu.europeana.metis.authentication.user.AccountRole;
import eu.europeana.metis.authentication.user.MetisUser;
import eu.europeana.metis.core.dao.DatasetDao;
import eu.europeana.metis.core.dataset.Dataset;
import eu.europeana.metis.core.exceptions.NoDatasetFoundException;
import eu.europeana.metis.exception.UserUnauthorizedException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class Authorizer {
    private final DatasetDao datasetDao;

    @Autowired
    public Authorizer(DatasetDao datasetDao) {
        this.datasetDao = datasetDao;
    }

    void authorizeWriteDefaultXslt(MetisUser metisUser) throws UserUnauthorizedException {
        if (metisUser == null || metisUser.getAccountRole() != AccountRole.METIS_ADMIN) {
            throw new UserUnauthorizedException("Unauthorized");
        }
    }

    void authorizeReadAllDatasets(MetisUser metisUser) throws UserUnauthorizedException {
        if (metisUser == null || metisUser.getAccountRole() != AccountRole.METIS_ADMIN && metisUser.getAccountRole() != AccountRole.EUROPEANA_DATA_OFFICER) {
            throw new UserUnauthorizedException("Unauthorized");
        }
    }

    Dataset authorizeReadExistingDatasetById(MetisUser metisUser, String datasetId) throws UserUnauthorizedException, NoDatasetFoundException {
        return this.authorizeExistingDatasetById(metisUser, datasetId, true);
    }

    Dataset authorizeWriteExistingDatasetById(MetisUser metisUser, String datasetId) throws UserUnauthorizedException, NoDatasetFoundException {
        return this.authorizeExistingDatasetById(metisUser, datasetId, false);
    }

    private Dataset authorizeExistingDatasetById(MetisUser metisUser, String datasetId, boolean allowView) throws UserUnauthorizedException, NoDatasetFoundException {
        return this.authorizeExistingDataset(metisUser, allowView, () -> {
            Dataset dataset = this.datasetDao.getDatasetByDatasetId(datasetId);
            if (dataset == null) {
                throw new NoDatasetFoundException(String.format("No dataset found with datasetId: '%s' in METIS", datasetId));
            }
            return dataset;
        });
    }

    Dataset authorizeReadExistingDatasetByName(MetisUser metisUser, String datasetName) throws UserUnauthorizedException, NoDatasetFoundException {
        return this.authorizeExistingDataset(metisUser, true, () -> {
            Dataset dataset = this.datasetDao.getDatasetByDatasetName(datasetName);
            if (dataset == null) {
                throw new NoDatasetFoundException(String.format("No dataset found with datasetName: '%s' in METIS", datasetName));
            }
            return dataset;
        });
    }

    private Dataset authorizeExistingDataset(MetisUser metisUser, boolean allowView, DatasetSupplier datasetSupplier) throws UserUnauthorizedException, NoDatasetFoundException {
        this.checkUserRoleForIndividualDatasetManagement(metisUser, allowView);
        Dataset dataset = datasetSupplier.get();
        if (metisUser.getAccountRole() != AccountRole.METIS_ADMIN && !metisUser.getOrganizationId().equals(dataset.getOrganizationId())) {
            throw new UserUnauthorizedException("Unauthorized");
        }
        return dataset;
    }

    void authorizeWriteNewDataset(MetisUser metisUser) throws UserUnauthorizedException {
        this.checkUserRoleForIndividualDatasetManagement(metisUser, false);
    }

    private void checkUserRoleForIndividualDatasetManagement(MetisUser metisUser, boolean allowView) throws UserUnauthorizedException {
        if (metisUser == null || metisUser.getAccountRole() == null || !allowView && metisUser.getAccountRole() == AccountRole.PROVIDER_VIEWER) {
            throw new UserUnauthorizedException("Unauthorized");
        }
    }

    @FunctionalInterface
    private static interface DatasetSupplier {
        public Dataset get() throws NoDatasetFoundException;
    }
}

