/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.metis.core.execution;

import com.rabbitmq.client.AMQP;
import com.rabbitmq.client.Channel;
import com.rabbitmq.client.MessageProperties;
import eu.europeana.cloud.client.dps.rest.DpsClient;
import eu.europeana.metis.core.dao.WorkflowExecutionDao;
import eu.europeana.metis.core.execution.PersistenceProvider;
import eu.europeana.metis.core.execution.WorkflowExecutionSettings;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import org.redisson.api.RedissonClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WorkflowExecutorManager
extends PersistenceProvider
implements WorkflowExecutionSettings {
    private static final Logger LOGGER = LoggerFactory.getLogger(WorkflowExecutorManager.class);
    private static final int DEFAULT_MAX_CONCURRENT_THREADS = 10;
    private static final int DEFAULT_MONITOR_CHECK_INTERVAL_IN_SECS = 5;
    private static final int DEFAULT_POLLING_TIMEOUT_FOR_CLEANING_COMPLETION_SERVICE_IN_SECS = 10;
    private static final int DEFAULT_PERIOD_OF_NO_PROCESSED_RECORDS_CHANGE_IN_MINUTES = 30;
    private int maxConcurrentThreads = 10;
    private int dpsMonitorCheckIntervalInSecs = 5;
    private int pollingTimeoutForCleaningCompletionServiceInSecs = 10;
    private int periodOfNoProcessedRecordsChangeInMinutes = 30;
    private String rabbitmqQueueName;
    private String ecloudBaseUrl;
    private String ecloudProvider;

    public WorkflowExecutorManager(WorkflowExecutionDao workflowExecutionDao, Channel rabbitmqPublisherChannel, Channel rabbitmqConsumerChannel, RedissonClient redissonClient, DpsClient dpsClient) {
        super(rabbitmqPublisherChannel, rabbitmqConsumerChannel, workflowExecutionDao, redissonClient, dpsClient);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addWorkflowExecutionToQueue(String userWorkflowExecutionObjectId, int priority) {
        Channel channel = this.getRabbitmqPublisherChannel();
        synchronized (channel) {
            AMQP.BasicProperties basicProperties = MessageProperties.PERSISTENT_TEXT_PLAIN.builder().priority(Integer.valueOf(priority)).build();
            try {
                this.getRabbitmqPublisherChannel().basicPublish("", this.rabbitmqQueueName, basicProperties, userWorkflowExecutionObjectId.getBytes(StandardCharsets.UTF_8));
            }
            catch (IOException e) {
                LOGGER.error("WorkflowExecution with objectId: {} not added in queue..", (Object)userWorkflowExecutionObjectId, (Object)e);
            }
        }
    }

    public void setRabbitmqQueueName(String rabbitmqQueueName) {
        this.rabbitmqQueueName = rabbitmqQueueName;
    }

    public void setMaxConcurrentThreads(int maxConcurrentThreads) {
        this.maxConcurrentThreads = maxConcurrentThreads;
    }

    public void setEcloudBaseUrl(String ecloudBaseUrl) {
        this.ecloudBaseUrl = ecloudBaseUrl;
    }

    public void setEcloudProvider(String ecloudProvider) {
        this.ecloudProvider = ecloudProvider;
    }

    public void setDpsMonitorCheckIntervalInSecs(int dpsMonitorCheckIntervalInSecs) {
        this.dpsMonitorCheckIntervalInSecs = dpsMonitorCheckIntervalInSecs;
    }

    public void setPollingTimeoutForCleaningCompletionServiceInSecs(int pollingTimeoutForCleaningCompletionServiceInSecs) {
        this.pollingTimeoutForCleaningCompletionServiceInSecs = pollingTimeoutForCleaningCompletionServiceInSecs;
    }

    public void setPeriodOfNoProcessedRecordsChangeInMinutes(int periodOfNoProcessedRecordsChangeInMinutes) {
        this.periodOfNoProcessedRecordsChangeInMinutes = periodOfNoProcessedRecordsChangeInMinutes;
    }

    @Override
    public int getDpsMonitorCheckIntervalInSecs() {
        return this.dpsMonitorCheckIntervalInSecs;
    }

    @Override
    public int getMaxConcurrentThreads() {
        return this.maxConcurrentThreads;
    }

    @Override
    public int getPollingTimeoutForCleaningCompletionServiceInSecs() {
        return this.pollingTimeoutForCleaningCompletionServiceInSecs;
    }

    @Override
    public int getPeriodOfNoProcessedRecordsChangeInMinutes() {
        return this.periodOfNoProcessedRecordsChangeInMinutes;
    }

    @Override
    public String getEcloudBaseUrl() {
        return this.ecloudBaseUrl;
    }

    @Override
    public String getEcloudProvider() {
        return this.ecloudProvider;
    }
}

