/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.metis.core.execution;

import eu.europeana.cloud.client.dps.rest.DpsClient;
import eu.europeana.cloud.common.model.dps.TaskState;
import eu.europeana.metis.core.dao.WorkflowExecutionDao;
import eu.europeana.metis.core.execution.ExecutionRules;
import eu.europeana.metis.core.execution.PersistenceProvider;
import eu.europeana.metis.core.execution.WorkflowExecutionMonitor;
import eu.europeana.metis.core.execution.WorkflowExecutionSettings;
import eu.europeana.metis.core.workflow.WorkflowExecution;
import eu.europeana.metis.core.workflow.WorkflowStatus;
import eu.europeana.metis.core.workflow.plugins.AbstractExecutablePlugin;
import eu.europeana.metis.core.workflow.plugins.AbstractExecutablePluginMetadata;
import eu.europeana.metis.core.workflow.plugins.AbstractMetisPlugin;
import eu.europeana.metis.core.workflow.plugins.EcloudBasePluginParameters;
import eu.europeana.metis.core.workflow.plugins.PluginStatus;
import eu.europeana.metis.core.workflow.plugins.PluginType;
import eu.europeana.metis.exception.ExternalTaskException;
import eu.europeana.metis.utils.ExternalRequestUtil;
import java.net.UnknownHostException;
import java.util.Collections;
import java.util.Date;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.client.HttpServerErrorException;

public class WorkflowExecutor
implements Callable<WorkflowExecution> {
    private static final String EXECUTION_ERROR_PREFIX = "Execution of external task presented with an error. ";
    private static final String MONITOR_ERROR_PREFIX = "An error occurred while monitoring the external task. ";
    private static final String TRIGGER_ERROR_PREFIX = "An error occurred while triggering the external task. ";
    private static final Logger LOGGER = LoggerFactory.getLogger(WorkflowExecutor.class);
    private static final int MAX_CANCEL_OR_MONITOR_FAILURES = 3;
    private final String workflowExecutionId;
    private final WorkflowExecutionMonitor workflowExecutionMonitor;
    private final WorkflowExecutionDao workflowExecutionDao;
    private final int monitorCheckIntervalInSecs;
    private final long periodOfNoProcessedRecordsChangeInSeconds;
    private final DpsClient dpsClient;
    private final String ecloudBaseUrl;
    private final String ecloudProvider;
    private WorkflowExecution workflowExecution;
    private static final Map<Class<?>, String> mapWithRetriableExceptions;

    WorkflowExecutor(String workflowExecutionId, PersistenceProvider persistenceProvider, WorkflowExecutionSettings workflowExecutionSettings, WorkflowExecutionMonitor workflowExecutionMonitor) {
        this.workflowExecutionId = workflowExecutionId;
        this.workflowExecutionDao = persistenceProvider.getWorkflowExecutionDao();
        this.dpsClient = persistenceProvider.getDpsClient();
        this.monitorCheckIntervalInSecs = workflowExecutionSettings.getDpsMonitorCheckIntervalInSecs();
        this.periodOfNoProcessedRecordsChangeInSeconds = TimeUnit.MINUTES.toSeconds(workflowExecutionSettings.getPeriodOfNoProcessedRecordsChangeInMinutes());
        this.ecloudBaseUrl = workflowExecutionSettings.getEcloudBaseUrl();
        this.ecloudProvider = workflowExecutionSettings.getEcloudProvider();
        this.workflowExecutionMonitor = workflowExecutionMonitor;
    }

    @Override
    public WorkflowExecution call() {
        try {
            return this.callInternal();
        }
        catch (RuntimeException e) {
            LOGGER.warn("Exception occurred in workflow executor", (Throwable)e);
            throw e;
        }
    }

    private WorkflowExecution callInternal() {
        LOGGER.info("Claiming workflow execution with id: {}", (Object)this.workflowExecutionId);
        this.workflowExecution = this.workflowExecutionMonitor.claimExecution(this.workflowExecutionId);
        if (this.workflowExecution == null) {
            LOGGER.info("Discarding WorkflowExecution with id: {}, it could not be claimed.", (Object)this.workflowExecutionId);
            return null;
        }
        LOGGER.info("Starting user workflow execution with id: {} and priority {}", (Object)this.workflowExecution.getId(), (Object)this.workflowExecution.getWorkflowPriority());
        Date finishDate = this.runInqueueOrRunningStateWorkflowExecution();
        if (finishDate == null && this.workflowExecutionDao.isCancelling(this.workflowExecution.getId())) {
            this.workflowExecution.setWorkflowAndAllQualifiedPluginsToCancelled();
            LOGGER.info("Cancelled running user workflow execution with id: {}", (Object)this.workflowExecution.getId());
        } else if (finishDate == null) {
            this.workflowExecution.checkAndSetAllRunningAndInqueuePluginsToCancelledIfOnePluginHasFailed();
        } else {
            this.workflowExecution.setFinishedDate(finishDate);
            this.workflowExecution.setWorkflowStatus(WorkflowStatus.FINISHED);
            this.workflowExecution.setCancelling(false);
            LOGGER.info("Finished user workflow execution with id: {}", (Object)this.workflowExecution.getId());
        }
        this.workflowExecutionDao.update(this.workflowExecution);
        return this.workflowExecution;
    }

    private Date runInqueueOrRunningStateWorkflowExecution() {
        AbstractMetisPlugin lastPlugin;
        int firstPluginPositionToStart = 0;
        for (int i = 0; i < this.workflowExecution.getMetisPlugins().size(); ++i) {
            AbstractMetisPlugin metisPlugin = (AbstractMetisPlugin)this.workflowExecution.getMetisPlugins().get(i);
            if (metisPlugin.getPluginStatus() != PluginStatus.INQUEUE && metisPlugin.getPluginStatus() != PluginStatus.RUNNING && metisPlugin.getPluginStatus() != PluginStatus.CLEANING && metisPlugin.getPluginStatus() != PluginStatus.PENDING) continue;
            firstPluginPositionToStart = i;
            break;
        }
        AbstractMetisPlugin previousPlugin = null;
        for (int i = firstPluginPositionToStart; i < this.workflowExecution.getMetisPlugins().size(); ++i) {
            AbstractMetisPlugin plugin = (AbstractMetisPlugin)this.workflowExecution.getMetisPlugins().get(i);
            Date startDateToUse = i == 0 ? this.workflowExecution.getStartedDate() : new Date();
            this.runMetisPlugin(previousPlugin, plugin, startDateToUse);
            if (this.workflowExecutionDao.isCancelling(this.workflowExecution.getId()) && plugin.getFinishedDate() == null || plugin.getPluginStatus() == PluginStatus.FAILED) break;
            previousPlugin = plugin;
        }
        Date finishDate = (lastPlugin = (AbstractMetisPlugin)this.workflowExecution.getMetisPlugins().get(this.workflowExecution.getMetisPlugins().size() - 1)).getPluginStatus() == PluginStatus.FINISHED ? lastPlugin.getFinishedDate() : null;
        return finishDate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runMetisPlugin(AbstractMetisPlugin previousPluginUnchecked, AbstractMetisPlugin pluginUnchecked, Date startDateToUse) {
        AbstractExecutablePlugin plugin;
        if (pluginUnchecked == null) {
            throw new IllegalStateException("Plugin cannot be null.");
        }
        try {
            plugin = WorkflowExecutor.expectExecutablePlugin(pluginUnchecked);
            AbstractExecutablePlugin previousPlugin = WorkflowExecutor.expectExecutablePlugin(previousPluginUnchecked);
            if (previousPlugin != null) {
                ((AbstractExecutablePluginMetadata)plugin.getPluginMetadata()).setPreviousRevisionInformation(previousPlugin);
            }
            if (StringUtils.isEmpty((CharSequence)plugin.getExternalTaskId())) {
                if (plugin.getPluginStatus() == PluginStatus.INQUEUE) {
                    plugin.setStartedDate(startDateToUse);
                }
                EcloudBasePluginParameters ecloudBasePluginParameters = new EcloudBasePluginParameters(this.ecloudBaseUrl, this.ecloudProvider, this.workflowExecution.getEcloudDatasetId(), this.resolvePreviousExternalTaskId(previousPlugin, plugin));
                plugin.execute(this.dpsClient, ecloudBasePluginParameters);
            }
        }
        catch (ExternalTaskException | RuntimeException e) {
            LOGGER.warn("Execution of external task failed", e);
            pluginUnchecked.setFinishedDate(null);
            pluginUnchecked.setPluginStatusAndResetFailMessage(PluginStatus.FAILED);
            pluginUnchecked.setFailMessage(TRIGGER_ERROR_PREFIX + e.getMessage());
            return;
        }
        finally {
            this.workflowExecutionDao.updateWorkflowPlugins(this.workflowExecution);
        }
        long sleepTime = TimeUnit.SECONDS.toMillis(this.monitorCheckIntervalInSecs);
        this.periodicCheckingLoop(sleepTime, plugin);
    }

    private String resolvePreviousExternalTaskId(AbstractExecutablePlugin providedPreviousPlugin, AbstractExecutablePlugin<?> plugin) {
        String previousExternalTaskId = null;
        if (providedPreviousPlugin == null && !ExecutionRules.getHarvestPluginGroup().contains(((AbstractExecutablePluginMetadata)plugin.getPluginMetadata()).getExecutablePluginType())) {
            AbstractExecutablePlugin computedPreviousPlugin;
            PluginType previousPluginType = PluginType.getPluginTypeFromEnumName((String)((AbstractExecutablePluginMetadata)plugin.getPluginMetadata()).getRevisionNamePreviousPlugin());
            Date previousPluginStartDate = ((AbstractExecutablePluginMetadata)plugin.getPluginMetadata()).getRevisionTimestampPreviousPlugin();
            WorkflowExecution previousExecution = this.workflowExecutionDao.getByTaskExecution(previousPluginStartDate, previousPluginType, this.workflowExecution.getDatasetId());
            AbstractExecutablePlugin abstractExecutablePlugin = computedPreviousPlugin = previousExecution == null ? null : (AbstractExecutablePlugin)previousExecution.getMetisPluginWithType(previousPluginType).map(WorkflowExecutor::expectExecutablePlugin).orElse(null);
            if (computedPreviousPlugin != null) {
                previousExternalTaskId = computedPreviousPlugin.getExternalTaskId();
            }
        } else if (providedPreviousPlugin != null) {
            previousExternalTaskId = providedPreviousPlugin.getExternalTaskId();
        }
        return previousExternalTaskId;
    }

    private static AbstractExecutablePlugin expectExecutablePlugin(AbstractMetisPlugin plugin) {
        if (plugin == null || plugin instanceof AbstractExecutablePlugin) {
            return (AbstractExecutablePlugin)plugin;
        }
        throw new IllegalStateException("Workflow executor found plugin with ID " + plugin.getId() + " that is not an executable plugin.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void periodicCheckingLoop(long sleepTime, AbstractExecutablePlugin plugin) {
        AbstractExecutablePlugin.MonitorResult monitorResult = null;
        int consecutiveCancelOrMonitorFailures = 0;
        boolean externalCancelCallSent = false;
        AtomicInteger previousProcessedRecords = new AtomicInteger(0);
        AtomicLong checkPointDateOfProcessedRecordsPeriodInMillis = new AtomicLong(System.currentTimeMillis());
        do {
            try {
                Thread.sleep(sleepTime);
                if (!externalCancelCallSent && this.shouldPluginBeCancelled(plugin, previousProcessedRecords, checkPointDateOfProcessedRecordsPeriodInMillis)) {
                    this.workflowExecution = this.workflowExecutionDao.getById(this.workflowExecution.getId().toString());
                    plugin.cancel(this.dpsClient, this.workflowExecution.getCancelledBy());
                    externalCancelCallSent = true;
                }
                monitorResult = plugin.monitor(this.dpsClient);
                consecutiveCancelOrMonitorFailures = 0;
                plugin.setPluginStatusAndResetFailMessage(monitorResult.getTaskState() == TaskState.REMOVING_FROM_SOLR_AND_MONGO ? PluginStatus.CLEANING : PluginStatus.RUNNING);
            }
            catch (InterruptedException e) {
                LOGGER.warn("Thread was interrupted during monitoring of external task", (Throwable)e);
                Thread.currentThread().interrupt();
                return;
            }
            catch (ExternalTaskException e) {
                if (ExternalRequestUtil.doesExceptionCauseMatchAnyOfProvidedExceptions(mapWithRetriableExceptions, (Exception)((Object)e))) {
                    LOGGER.warn(String.format("Monitoring of external task failed %s consecutive times. After exceeding %s retries, pending status will be set", ++consecutiveCancelOrMonitorFailures, 3), (Throwable)e);
                    if (consecutiveCancelOrMonitorFailures != 3) continue;
                    plugin.setPluginStatusAndResetFailMessage(PluginStatus.PENDING);
                    continue;
                }
                plugin.setFinishedDate(null);
                plugin.setPluginStatusAndResetFailMessage(PluginStatus.FAILED);
                plugin.setFailMessage(MONITOR_ERROR_PREFIX + e.getMessage());
                return;
            }
            finally {
                Date updatedDate = new Date();
                plugin.setUpdatedDate(updatedDate);
                this.workflowExecution.setUpdatedDate(updatedDate);
                this.workflowExecutionDao.updateMonitorInformation(this.workflowExecution);
            }
        } while (monitorResult == null || monitorResult.getTaskState() != TaskState.DROPPED && monitorResult.getTaskState() != TaskState.PROCESSED);
        this.preparePluginStateAndFinishedDate(plugin, monitorResult);
    }

    private boolean shouldPluginBeCancelled(AbstractExecutablePlugin plugin, AtomicInteger previousProcessedRecords, AtomicLong checkPointDateOfProcessedRecordsPeriodInMillis) {
        boolean notCleaningAndCancelling = plugin.getPluginStatus() != PluginStatus.CLEANING && this.workflowExecutionDao.isCancelling(this.workflowExecution.getId());
        boolean notCleaningOrPending = plugin.getPluginStatus() != PluginStatus.CLEANING && plugin.getPluginStatus() != PluginStatus.PENDING;
        boolean isMinuteCapExceeded = this.isMinuteCapOverWithoutChangeInProcessedRecords(plugin, previousProcessedRecords, checkPointDateOfProcessedRecordsPeriodInMillis);
        return notCleaningAndCancelling || notCleaningOrPending && isMinuteCapExceeded;
    }

    private boolean isMinuteCapOverWithoutChangeInProcessedRecords(AbstractExecutablePlugin<?> plugin, AtomicInteger previousProcessedRecords, AtomicLong checkPointDateOfProcessedRecordsPeriodInMillis) {
        boolean isMinuteCapOverWithoutChangeInProcessedRecords;
        int processedRecords = plugin.getExecutionProgress().getProcessedRecords();
        if (plugin.getPluginStatus() == PluginStatus.CLEANING || plugin.getPluginStatus() == PluginStatus.PENDING || previousProcessedRecords.get() != processedRecords) {
            checkPointDateOfProcessedRecordsPeriodInMillis.set(System.currentTimeMillis());
            previousProcessedRecords.set(processedRecords);
            return false;
        }
        boolean bl = isMinuteCapOverWithoutChangeInProcessedRecords = TimeUnit.MILLISECONDS.toSeconds(System.currentTimeMillis() - checkPointDateOfProcessedRecordsPeriodInMillis.get()) >= this.periodOfNoProcessedRecordsChangeInSeconds;
        if (isMinuteCapOverWithoutChangeInProcessedRecords) {
            this.workflowExecutionDao.setCancellingState(this.workflowExecution, null);
        }
        return isMinuteCapOverWithoutChangeInProcessedRecords;
    }

    private void preparePluginStateAndFinishedDate(AbstractExecutablePlugin<?> plugin, AbstractExecutablePlugin.MonitorResult monitorResult) {
        if (monitorResult.getTaskState() == TaskState.PROCESSED) {
            plugin.setFinishedDate(new Date());
            plugin.setPluginStatusAndResetFailMessage(PluginStatus.FINISHED);
        } else if (monitorResult.getTaskState() == TaskState.DROPPED && !this.workflowExecutionDao.isCancelling(this.workflowExecution.getId())) {
            plugin.setPluginStatusAndResetFailMessage(PluginStatus.FAILED);
            String failMessage = StringUtils.isBlank((CharSequence)monitorResult.getTaskInfo()) ? "No further information received." : monitorResult.getTaskInfo();
            plugin.setFailMessage(EXECUTION_ERROR_PREFIX + failMessage);
        }
        this.workflowExecutionDao.updateWorkflowPlugins(this.workflowExecution);
    }

    static {
        ConcurrentHashMap<Class, String> retriableExceptionMap = new ConcurrentHashMap<Class, String>();
        retriableExceptionMap.put(UnknownHostException.class, "");
        retriableExceptionMap.put(HttpServerErrorException.class, "");
        mapWithRetriableExceptions = Collections.unmodifiableMap(retriableExceptionMap);
    }
}

