/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.metis.core.execution;

import eu.europeana.metis.core.dao.WorkflowExecutionDao;
import eu.europeana.metis.core.execution.WorkflowExecutorManager;
import eu.europeana.metis.core.rest.ResponseListWrapper;
import eu.europeana.metis.core.workflow.OrderField;
import eu.europeana.metis.core.workflow.WorkflowExecution;
import eu.europeana.metis.core.workflow.WorkflowStatus;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.redisson.api.RLock;
import org.redisson.api.RedissonClient;
import org.redisson.client.RedisConnectionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WorkflowExecutionMonitor {
    private static final Logger LOGGER = LoggerFactory.getLogger(WorkflowExecutionMonitor.class);
    private static final String FAILSAFE_LOCK = "failsafeLock";
    private final WorkflowExecutionDao workflowExecutionDao;
    private final WorkflowExecutorManager workflowExecutorManager;
    private final Duration failsafeLeniency;
    private final RLock lock;
    private Map<String, WorkflowExecutionEntry> currentRunningExecutions = Collections.emptyMap();

    public WorkflowExecutionMonitor(WorkflowExecutorManager workflowExecutorManager, WorkflowExecutionDao workflowExecutionDao, RedissonClient redissonClient, Duration failsafeLeniency) {
        this.failsafeLeniency = failsafeLeniency;
        this.workflowExecutionDao = workflowExecutionDao;
        this.workflowExecutorManager = workflowExecutorManager;
        this.lock = redissonClient.getFairLock(FAILSAFE_LOCK);
    }

    List<WorkflowExecution> updateCurrentRunningExecutions() {
        List<WorkflowExecution> allRunningWorkflowExecutions = this.getWorkflowExecutionsWithStatus(WorkflowStatus.RUNNING);
        HashMap<String, WorkflowExecutionEntry> newExecutions = new HashMap<String, WorkflowExecutionEntry>(allRunningWorkflowExecutions.size());
        for (WorkflowExecution execution : allRunningWorkflowExecutions) {
            WorkflowExecutionEntry currentEntry = this.getEntry(execution);
            WorkflowExecutionEntry newEntry = currentEntry != null && currentEntry.updateTimeValueIsEqual(execution.getUpdatedDate()) ? currentEntry : new WorkflowExecutionEntry(execution.getUpdatedDate());
            newExecutions.put(execution.getId().toString(), newEntry);
        }
        this.currentRunningExecutions = Collections.unmodifiableMap(newExecutions);
        return allRunningWorkflowExecutions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void performFailsafe() {
        try {
            this.lock.lock();
            List<WorkflowExecution> allRunningWorkflowExecutions = this.updateCurrentRunningExecutions();
            ArrayList<WorkflowExecution> toBeRequeued = new ArrayList<WorkflowExecution>();
            for (WorkflowExecution runningExecution : allRunningWorkflowExecutions) {
                WorkflowExecutionEntry executionEntry = this.getEntry(runningExecution);
                if (executionEntry != null && !executionEntry.assumeHanging(this.failsafeLeniency)) continue;
                toBeRequeued.add(runningExecution);
            }
            toBeRequeued.addAll(this.getWorkflowExecutionsWithStatus(WorkflowStatus.INQUEUE));
            for (WorkflowExecution workflowExecution : toBeRequeued) {
                this.workflowExecutorManager.addWorkflowExecutionToQueue(workflowExecution.getId().toString(), workflowExecution.getWorkflowPriority());
            }
        }
        catch (RuntimeException e) {
            LOGGER.warn("Exception thrown from rabbitmq channel or Redis disconnection, failsafe thread continues", (Throwable)e);
        }
        finally {
            try {
                this.lock.unlock();
            }
            catch (RedisConnectionException e) {
                LOGGER.warn("Cannot connect to unlock, failsafe thread continues", (Throwable)e);
            }
        }
    }

    List<WorkflowExecution> getWorkflowExecutionsWithStatus(WorkflowStatus workflowStatus) {
        ArrayList<WorkflowExecution> workflowExecutions = new ArrayList<WorkflowExecution>();
        int nextPage = 0;
        ResponseListWrapper userWorkflowExecutionResponseListWrapper = new ResponseListWrapper();
        do {
            userWorkflowExecutionResponseListWrapper.clear();
            userWorkflowExecutionResponseListWrapper.setResultsAndLastPage(this.workflowExecutionDao.getAllWorkflowExecutions(null, EnumSet.of(workflowStatus), OrderField.ID, true, nextPage), this.workflowExecutionDao.getWorkflowExecutionsPerRequest(), nextPage);
            workflowExecutions.addAll(userWorkflowExecutionResponseListWrapper.getResults());
        } while ((nextPage = userWorkflowExecutionResponseListWrapper.getNextPage()) != -1);
        return workflowExecutions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WorkflowExecution claimExecution(String workflowExecutionId) {
        try {
            this.lock.lock();
            WorkflowExecution workflowExecution = this.workflowExecutionDao.getById(workflowExecutionId);
            if (!this.mayClaimExecution(workflowExecution)) {
                WorkflowExecution workflowExecution2 = null;
                return workflowExecution2;
            }
            Date now = new Date();
            workflowExecution.setUpdatedDate(now);
            if (workflowExecution.getWorkflowStatus() != WorkflowStatus.RUNNING) {
                workflowExecution.setStartedDate(now);
                workflowExecution.setWorkflowStatus(WorkflowStatus.RUNNING);
            }
            this.workflowExecutionDao.updateMonitorInformation(workflowExecution);
            WorkflowExecution workflowExecution3 = workflowExecution;
            return workflowExecution3;
        }
        catch (RuntimeException e) {
            LOGGER.warn("Exception thrown while claiming workflow execution.", (Throwable)e);
            WorkflowExecution workflowExecution = null;
            return workflowExecution;
        }
        finally {
            this.lock.unlock();
        }
    }

    boolean mayClaimExecution(WorkflowExecution workflowExecution) {
        boolean result;
        if (workflowExecution.getWorkflowStatus() != WorkflowStatus.RUNNING) {
            boolean result2;
            boolean bl = result2 = workflowExecution.getWorkflowStatus() == WorkflowStatus.INQUEUE;
            if (!result2) {
                LOGGER.info("Claim for execution {} denied: workflow not in RUNNING or INQUEUE state.", (Object)workflowExecution.getId());
            }
            return result2;
        }
        WorkflowExecutionEntry currentExecution = this.getEntry(workflowExecution);
        if (currentExecution == null) {
            LOGGER.info("Claim for execution {} denied: wait for scheduled monitoring task to monitor this RUNNING execution.", (Object)workflowExecution.getId());
            return false;
        }
        boolean bl = result = currentExecution.updateTimeValueIsEqual(workflowExecution.getUpdatedDate()) && currentExecution.assumeHanging(this.failsafeLeniency);
        if (!result) {
            LOGGER.info("Claim for execution {} denied: RUNNING execution does not (yet) appear to be hanging.", (Object)workflowExecution.getId());
        }
        return result;
    }

    WorkflowExecutionEntry getEntry(WorkflowExecution workflowExecution) {
        return this.currentRunningExecutions.get(workflowExecution.getId().toString());
    }

    static class WorkflowExecutionEntry {
        private final Instant executionUpdateTime;
        private final Instant timeOfLastUpdateTimeChange;

        public WorkflowExecutionEntry(Date updateTime) {
            this.executionUpdateTime = updateTime == null ? null : updateTime.toInstant();
            this.timeOfLastUpdateTimeChange = Instant.now();
        }

        public boolean updateTimeValueIsEqual(Date otherUpdateTime) {
            Instant otherInstant = otherUpdateTime == null ? null : otherUpdateTime.toInstant();
            return Objects.equals(otherInstant, this.executionUpdateTime);
        }

        public boolean assumeHanging(Duration leniency) {
            return this.getLastValueChange().plus(leniency).isBefore(this.getNow());
        }

        public Instant getLastValueChange() {
            return this.timeOfLastUpdateTimeChange;
        }

        Instant getNow() {
            return Instant.now();
        }
    }
}

