/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.metis.core.execution;

import eu.europeana.metis.core.rest.ResponseListWrapper;
import eu.europeana.metis.core.service.OrchestratorService;
import eu.europeana.metis.core.service.ScheduleWorkflowService;
import eu.europeana.metis.core.workflow.ScheduleFrequence;
import eu.europeana.metis.core.workflow.ScheduledWorkflow;
import eu.europeana.metis.exception.GenericMetisException;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.redisson.api.RLock;
import org.redisson.api.RedissonClient;
import org.redisson.client.RedisConnectionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SchedulerExecutor {
    private static final Logger LOGGER = LoggerFactory.getLogger(SchedulerExecutor.class);
    private final RLock lock;
    private final OrchestratorService orchestratorService;
    private final ScheduleWorkflowService scheduleWorkflowService;
    private static final String SCHEDULER_LOCK = "schedulerLock";
    private LocalDateTime lastExecutionTime = LocalDateTime.now();

    public SchedulerExecutor(OrchestratorService orchestratorService, ScheduleWorkflowService scheduleWorkflowService, RedissonClient redissonClient) {
        this.orchestratorService = orchestratorService;
        this.scheduleWorkflowService = scheduleWorkflowService;
        this.lock = redissonClient.getFairLock(SCHEDULER_LOCK);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void performScheduling() {
        try {
            this.lock.lock();
            LocalDateTime thisExecutionTime = LocalDateTime.now();
            LOGGER.info("Date range checking lowerbound: {}, upperBound:{}", (Object)this.lastExecutionTime, (Object)thisExecutionTime);
            List<ScheduledWorkflow> allCleanedScheduledWorkflows = this.getCleanedScheduledUserWorkflows(this.lastExecutionTime, thisExecutionTime);
            for (ScheduledWorkflow scheduledWorkflow : allCleanedScheduledWorkflows) {
                LOGGER.info("Adding ScheduledWorkflow with DatasetId: {},pointerDate: {}, frequence: {}", new Object[]{scheduledWorkflow.getDatasetId(), scheduledWorkflow.getPointerDate(), scheduledWorkflow.getScheduleFrequence()});
                this.tryAddUserWorkflowInQueueOfUserWorkflowExecutions(scheduledWorkflow);
            }
            this.lastExecutionTime = thisExecutionTime;
        }
        catch (RuntimeException e) {
            LOGGER.warn("Exception thrown from rabbitmq channel or Redis disconnection, scheduler thread continues", (Throwable)e);
        }
        finally {
            try {
                this.lock.unlock();
            }
            catch (RedisConnectionException e) {
                LOGGER.warn("Cannot connect to unlock, scheduler thread continues", (Throwable)e);
            }
        }
    }

    private List<ScheduledWorkflow> getCleanedScheduledUserWorkflows(LocalDateTime lowerBound, LocalDateTime upperBound) {
        ArrayList<ScheduledWorkflow> scheduledWorkflows = new ArrayList<ScheduledWorkflow>();
        scheduledWorkflows.addAll(this.getScheduledUserWorkflowsFrequenceOnce(lowerBound, upperBound));
        scheduledWorkflows.addAll(this.getScheduledUserWorkflowsFrequenceDaily(lowerBound, upperBound));
        scheduledWorkflows.addAll(this.getScheduledUserWorkflowsFrequenceWeekly(lowerBound, upperBound));
        scheduledWorkflows.addAll(this.getScheduledUserWorkflowsFrequenceMonthly(lowerBound, upperBound));
        return scheduledWorkflows;
    }

    private List<ScheduledWorkflow> getScheduledUserWorkflowsFrequenceOnce(LocalDateTime lowerBound, LocalDateTime upperBound) {
        int nextPage = 0;
        ArrayList<ScheduledWorkflow> scheduledWorkflows = new ArrayList<ScheduledWorkflow>();
        ResponseListWrapper scheduledUserWorkflowResponseListWrapper = new ResponseListWrapper();
        do {
            scheduledUserWorkflowResponseListWrapper.clear();
            scheduledUserWorkflowResponseListWrapper.setResultsAndLastPage(this.scheduleWorkflowService.getAllScheduledWorkflowsByDateRangeONCE(lowerBound, upperBound, nextPage), this.scheduleWorkflowService.getScheduledWorkflowsPerRequest(), nextPage);
            scheduledWorkflows.addAll(scheduledUserWorkflowResponseListWrapper.getResults());
        } while ((nextPage = scheduledUserWorkflowResponseListWrapper.getNextPage()) != -1);
        return scheduledWorkflows;
    }

    private List<ScheduledWorkflow> getScheduledUserWorkflowsFrequenceDaily(LocalDateTime lowerBound, LocalDateTime upperBound) {
        List<ScheduledWorkflow> scheduledWorkflows = this.getScheduledUserWorkflows(ScheduleFrequence.DAILY);
        Iterator<ScheduledWorkflow> iterator = scheduledWorkflows.iterator();
        while (iterator.hasNext()) {
            ScheduledWorkflow scheduledWorkflow = iterator.next();
            LocalDateTime pointerDate = LocalDateTime.ofInstant(scheduledWorkflow.getPointerDate().toInstant(), ZoneId.systemDefault());
            LocalDateTime localDateToCheck = lowerBound.withYear(lowerBound.getYear()).withMonth(lowerBound.getMonthValue()).withHour(pointerDate.getHour()).withMinute(pointerDate.getMinute()).withSecond(pointerDate.getSecond()).withNano(pointerDate.getNano());
            if (!localDateToCheck.isBefore(lowerBound) && !localDateToCheck.isEqual(upperBound) && !localDateToCheck.isAfter(upperBound)) continue;
            iterator.remove();
        }
        return scheduledWorkflows;
    }

    private List<ScheduledWorkflow> getScheduledUserWorkflowsFrequenceWeekly(LocalDateTime lowerBound, LocalDateTime upperBound) {
        List<ScheduledWorkflow> scheduledWorkflows = this.getScheduledUserWorkflows(ScheduleFrequence.WEEKLY);
        Iterator<ScheduledWorkflow> scheduledWorkflowIterator = scheduledWorkflows.iterator();
        while (scheduledWorkflowIterator.hasNext()) {
            LocalDateTime localDateToCheck = this.getLocalDateTimeBasedOnLowerBound(lowerBound, scheduledWorkflowIterator.next());
            if (lowerBound.getDayOfWeek() == localDateToCheck.getDayOfWeek()) {
                localDateToCheck = localDateToCheck.withDayOfMonth(lowerBound.getDayOfMonth());
            }
            if (!localDateToCheck.isBefore(lowerBound) && !localDateToCheck.isEqual(upperBound) && !localDateToCheck.isAfter(upperBound)) continue;
            scheduledWorkflowIterator.remove();
        }
        return scheduledWorkflows;
    }

    private List<ScheduledWorkflow> getScheduledUserWorkflowsFrequenceMonthly(LocalDateTime lowerBound, LocalDateTime upperBound) {
        List<ScheduledWorkflow> scheduledWorkflows = this.getScheduledUserWorkflows(ScheduleFrequence.MONTHLY);
        Iterator<ScheduledWorkflow> scheduledWorkflowIterator = scheduledWorkflows.iterator();
        while (scheduledWorkflowIterator.hasNext()) {
            LocalDateTime localDateToCheck = this.getLocalDateTimeBasedOnLowerBound(lowerBound, scheduledWorkflowIterator.next());
            if (lowerBound.getDayOfMonth() == localDateToCheck.getDayOfMonth()) {
                localDateToCheck = localDateToCheck.withMonth(lowerBound.getMonthValue());
            }
            if (!localDateToCheck.isBefore(lowerBound) && !localDateToCheck.isEqual(upperBound) && !localDateToCheck.isAfter(upperBound)) continue;
            scheduledWorkflowIterator.remove();
        }
        return scheduledWorkflows;
    }

    private LocalDateTime getLocalDateTimeBasedOnLowerBound(LocalDateTime lowerBound, ScheduledWorkflow scheduledWorkflow) {
        LocalDateTime pointerDate = LocalDateTime.ofInstant(scheduledWorkflow.getPointerDate().toInstant(), ZoneId.systemDefault());
        return lowerBound.withYear(lowerBound.getYear()).withMonth(pointerDate.getMonthValue()).withDayOfMonth(pointerDate.getDayOfMonth()).withHour(pointerDate.getHour()).withMinute(pointerDate.getMinute()).withSecond(pointerDate.getSecond()).withNano(pointerDate.getNano());
    }

    private List<ScheduledWorkflow> getScheduledUserWorkflows(ScheduleFrequence scheduleFrequence) {
        int nextPage = 0;
        ArrayList<ScheduledWorkflow> scheduledWorkflows = new ArrayList<ScheduledWorkflow>();
        ResponseListWrapper scheduledUserWorkflowResponseListWrapper = new ResponseListWrapper();
        do {
            scheduledUserWorkflowResponseListWrapper.clear();
            scheduledUserWorkflowResponseListWrapper.setResultsAndLastPage(this.scheduleWorkflowService.getAllScheduledWorkflowsWithoutAuthorization(scheduleFrequence, nextPage), this.scheduleWorkflowService.getScheduledWorkflowsPerRequest(), nextPage);
            scheduledWorkflows.addAll(scheduledUserWorkflowResponseListWrapper.getResults());
        } while ((nextPage = scheduledUserWorkflowResponseListWrapper.getNextPage()) != -1);
        return scheduledWorkflows;
    }

    private void tryAddUserWorkflowInQueueOfUserWorkflowExecutions(ScheduledWorkflow scheduledWorkflow) {
        try {
            this.orchestratorService.addWorkflowInQueueOfWorkflowExecutionsWithoutAuthorization(scheduledWorkflow.getDatasetId(), null, scheduledWorkflow.getWorkflowPriority());
        }
        catch (GenericMetisException e) {
            LOGGER.warn("Scheduled execution was not added to queue", (Throwable)e);
        }
    }
}

