/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.metis.core.execution;

import eu.europeana.metis.core.dao.WorkflowExecutionDao;
import eu.europeana.metis.core.workflow.plugins.AbstractExecutablePlugin;
import eu.europeana.metis.core.workflow.plugins.ExecutablePluginType;
import eu.europeana.metis.core.workflow.plugins.OaipmhHarvestPluginMetadata;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Set;

public final class ExecutionRules {
    private static final Set<ExecutablePluginType> HARVEST_PLUGIN_GROUP = Collections.unmodifiableSet(EnumSet.of(ExecutablePluginType.OAIPMH_HARVEST, ExecutablePluginType.HTTP_HARVEST));
    private static final Set<ExecutablePluginType> PROCESS_PLUGIN_GROUP = Collections.unmodifiableSet(EnumSet.of(ExecutablePluginType.VALIDATION_EXTERNAL, new ExecutablePluginType[]{ExecutablePluginType.TRANSFORMATION, ExecutablePluginType.VALIDATION_INTERNAL, ExecutablePluginType.NORMALIZATION, ExecutablePluginType.ENRICHMENT, ExecutablePluginType.MEDIA_PROCESS, ExecutablePluginType.LINK_CHECKING}));
    private static final Set<ExecutablePluginType> INDEX_PLUGIN_GROUP = Collections.unmodifiableSet(EnumSet.of(ExecutablePluginType.PREVIEW, ExecutablePluginType.PUBLISH));

    private ExecutionRules() {
    }

    public static AbstractExecutablePlugin getLatestFinishedPluginIfRequestedPluginAllowedForExecution(ExecutablePluginType pluginType, ExecutablePluginType enforcedPluginType, String datasetId, WorkflowExecutionDao workflowExecutionDao) {
        AbstractExecutablePlugin plugin = null;
        if (enforcedPluginType != null) {
            plugin = workflowExecutionDao.getLastFinishedWorkflowExecutionPluginByDatasetIdAndPluginType(datasetId, EnumSet.of(enforcedPluginType), true);
        } else if (PROCESS_PLUGIN_GROUP.contains(pluginType) || INDEX_PLUGIN_GROUP.contains(pluginType)) {
            AbstractExecutablePlugin latestOaiPlugin;
            plugin = ExecutionRules.getLatestFinishedPluginAllowedForExecution(pluginType, datasetId, workflowExecutionDao);
            if (pluginType.equals((Object)ExecutablePluginType.MEDIA_PROCESS) && plugin == null && (latestOaiPlugin = workflowExecutionDao.getLastFinishedWorkflowExecutionPluginByDatasetIdAndPluginType(datasetId, EnumSet.of(ExecutablePluginType.OAIPMH_HARVEST), true)) != null && "https://oai-pmh.eanadev.org/oai".equalsIgnoreCase(((OaipmhHarvestPluginMetadata)latestOaiPlugin.getPluginMetadata()).getUrl().trim())) {
                plugin = latestOaiPlugin;
            }
        }
        return plugin;
    }

    private static AbstractExecutablePlugin getLatestFinishedPluginAllowedForExecution(ExecutablePluginType pluginType, String datasetId, WorkflowExecutionDao workflowExecutionDao) {
        AbstractExecutablePlugin latestFinishedWorkflowExecutionByDatasetIdAndPluginType = null;
        Set<ExecutablePluginType> pluginTypesSetThatPluginTypeCanBeBasedOn = ExecutionRules.getPluginTypesSetThatPluginTypeCanBeBasedOn(pluginType);
        if (!pluginTypesSetThatPluginTypeCanBeBasedOn.isEmpty()) {
            latestFinishedWorkflowExecutionByDatasetIdAndPluginType = workflowExecutionDao.getLastFinishedWorkflowExecutionPluginByDatasetIdAndPluginType(datasetId, pluginTypesSetThatPluginTypeCanBeBasedOn, true);
        }
        return latestFinishedWorkflowExecutionByDatasetIdAndPluginType;
    }

    public static Set<ExecutablePluginType> getPluginTypesSetThatPluginTypeCanBeBasedOn(ExecutablePluginType pluginType) {
        Set<Object> pluginTypesSetThatPluginTypeCanBeBasedOn;
        switch (pluginType) {
            case VALIDATION_EXTERNAL: {
                pluginTypesSetThatPluginTypeCanBeBasedOn = HARVEST_PLUGIN_GROUP;
                break;
            }
            case TRANSFORMATION: {
                pluginTypesSetThatPluginTypeCanBeBasedOn = EnumSet.of(ExecutablePluginType.VALIDATION_EXTERNAL);
                break;
            }
            case VALIDATION_INTERNAL: {
                pluginTypesSetThatPluginTypeCanBeBasedOn = EnumSet.of(ExecutablePluginType.TRANSFORMATION);
                break;
            }
            case NORMALIZATION: {
                pluginTypesSetThatPluginTypeCanBeBasedOn = EnumSet.of(ExecutablePluginType.VALIDATION_INTERNAL);
                break;
            }
            case ENRICHMENT: {
                pluginTypesSetThatPluginTypeCanBeBasedOn = EnumSet.of(ExecutablePluginType.NORMALIZATION);
                break;
            }
            case MEDIA_PROCESS: {
                pluginTypesSetThatPluginTypeCanBeBasedOn = EnumSet.of(ExecutablePluginType.ENRICHMENT);
                break;
            }
            case PREVIEW: {
                pluginTypesSetThatPluginTypeCanBeBasedOn = EnumSet.of(ExecutablePluginType.MEDIA_PROCESS);
                break;
            }
            case PUBLISH: {
                pluginTypesSetThatPluginTypeCanBeBasedOn = EnumSet.of(ExecutablePluginType.PREVIEW);
                break;
            }
            case LINK_CHECKING: {
                pluginTypesSetThatPluginTypeCanBeBasedOn = new HashSet<ExecutablePluginType>(PROCESS_PLUGIN_GROUP);
                pluginTypesSetThatPluginTypeCanBeBasedOn.addAll(INDEX_PLUGIN_GROUP);
                break;
            }
            default: {
                pluginTypesSetThatPluginTypeCanBeBasedOn = Collections.emptySet();
            }
        }
        return pluginTypesSetThatPluginTypeCanBeBasedOn;
    }

    public static Set<ExecutablePluginType> getHarvestPluginGroup() {
        return HARVEST_PLUGIN_GROUP;
    }

    public static Set<ExecutablePluginType> getProcessPluginGroup() {
        return PROCESS_PLUGIN_GROUP;
    }

    public static Set<ExecutablePluginType> getIndexPluginGroup() {
        return INDEX_PLUGIN_GROUP;
    }
}

