/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.metis.core.dao;

import com.mongodb.WriteResult;
import eu.europeana.metis.authentication.user.MetisUser;
import eu.europeana.metis.core.dao.MetisDao;
import eu.europeana.metis.core.dataset.Dataset;
import eu.europeana.metis.core.mongo.MorphiaDatastoreProvider;
import eu.europeana.metis.core.rest.RequestLimits;
import eu.europeana.metis.core.workflow.CancelledSystemId;
import eu.europeana.metis.core.workflow.OrderField;
import eu.europeana.metis.core.workflow.WorkflowExecution;
import eu.europeana.metis.core.workflow.WorkflowStatus;
import eu.europeana.metis.core.workflow.plugins.AbstractExecutablePlugin;
import eu.europeana.metis.core.workflow.plugins.AbstractMetisPlugin;
import eu.europeana.metis.core.workflow.plugins.DataStatus;
import eu.europeana.metis.core.workflow.plugins.ExecutablePluginType;
import eu.europeana.metis.core.workflow.plugins.PluginStatus;
import eu.europeana.metis.core.workflow.plugins.PluginType;
import eu.europeana.metis.utils.ExternalRequestUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.bson.types.ObjectId;
import org.mongodb.morphia.Key;
import org.mongodb.morphia.aggregation.AggregationPipeline;
import org.mongodb.morphia.aggregation.Projection;
import org.mongodb.morphia.query.Criteria;
import org.mongodb.morphia.query.CriteriaContainerImpl;
import org.mongodb.morphia.query.FilterOperator;
import org.mongodb.morphia.query.FindOptions;
import org.mongodb.morphia.query.Query;
import org.mongodb.morphia.query.Sort;
import org.mongodb.morphia.query.UpdateOperations;
import org.mongodb.morphia.query.UpdateResults;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;
import org.springframework.util.CollectionUtils;

@Repository
public class WorkflowExecutionDao
implements MetisDao<WorkflowExecution, String> {
    private static final Logger LOGGER = LoggerFactory.getLogger(WorkflowExecutionDao.class);
    private static final String WORKFLOW_STATUS = "workflowStatus";
    private static final String PLUGIN_STATUS = "pluginStatus";
    private static final String PLUGIN_TYPE = "pluginType";
    private static final String DATASET_ID = "datasetId";
    private static final String METIS_PLUGINS = "metisPlugins";
    private static final String MONGO_COND_OPERATOR = "$cond";
    private static final int INQUEUE_POSITION_IN_OVERVIEW = 1;
    private static final int RUNNING_POSITION_IN_OVERVIEW = 2;
    private static final int DEFAULT_POSITION_IN_OVERVIEW = 3;
    private final MorphiaDatastoreProvider morphiaDatastoreProvider;
    private int workflowExecutionsPerRequest = RequestLimits.WORKFLOW_EXECUTIONS_PER_REQUEST.getLimit();

    @Autowired
    public WorkflowExecutionDao(MorphiaDatastoreProvider morphiaDatastoreProvider) {
        this.morphiaDatastoreProvider = morphiaDatastoreProvider;
    }

    @Override
    public String create(WorkflowExecution workflowExecution) {
        Key workflowExecutionKey = (Key)ExternalRequestUtil.retryableExternalRequestConnectionReset(() -> this.morphiaDatastoreProvider.getDatastore().save((Object)workflowExecution));
        LOGGER.debug("WorkflowExecution for datasetId '{}' created in Mongo", (Object)workflowExecution.getDatasetId());
        return workflowExecutionKey == null ? null : workflowExecutionKey.getId().toString();
    }

    @Override
    public String update(WorkflowExecution workflowExecution) {
        Key workflowExecutionKey = (Key)ExternalRequestUtil.retryableExternalRequestConnectionReset(() -> this.morphiaDatastoreProvider.getDatastore().save((Object)workflowExecution));
        LOGGER.debug("WorkflowExecution for datasetId '{}' updated in Mongo", (Object)workflowExecution.getDatasetId());
        return workflowExecutionKey == null ? null : workflowExecutionKey.getId().toString();
    }

    public void updateWorkflowPlugins(WorkflowExecution workflowExecution) {
        UpdateOperations workflowExecutionUpdateOperations = this.morphiaDatastoreProvider.getDatastore().createUpdateOperations(WorkflowExecution.class);
        Query query = this.morphiaDatastoreProvider.getDatastore().find(WorkflowExecution.class).filter("_id", (Object)workflowExecution.getId());
        workflowExecutionUpdateOperations.set(METIS_PLUGINS, (Object)workflowExecution.getMetisPlugins());
        UpdateResults updateResults = (UpdateResults)ExternalRequestUtil.retryableExternalRequestConnectionReset(() -> this.morphiaDatastoreProvider.getDatastore().update(query, workflowExecutionUpdateOperations));
        LOGGER.debug("WorkflowExecution metisPlugins for datasetId '{}' updated in Mongo. (UpdateResults: {})", (Object)workflowExecution.getDatasetId(), (Object)(updateResults == null ? 0 : updateResults.getUpdatedCount()));
    }

    public void updateMonitorInformation(WorkflowExecution workflowExecution) {
        UpdateOperations workflowExecutionUpdateOperations = this.morphiaDatastoreProvider.getDatastore().createUpdateOperations(WorkflowExecution.class);
        Query query = this.morphiaDatastoreProvider.getDatastore().find(WorkflowExecution.class).filter("_id", (Object)workflowExecution.getId());
        workflowExecutionUpdateOperations.set(WORKFLOW_STATUS, (Object)workflowExecution.getWorkflowStatus());
        if (workflowExecution.getStartedDate() != null) {
            workflowExecutionUpdateOperations.set("startedDate", (Object)workflowExecution.getStartedDate());
        }
        if (workflowExecution.getUpdatedDate() != null) {
            workflowExecutionUpdateOperations.set("updatedDate", (Object)workflowExecution.getUpdatedDate());
        }
        workflowExecutionUpdateOperations.set(METIS_PLUGINS, (Object)workflowExecution.getMetisPlugins());
        UpdateResults updateResults = (UpdateResults)ExternalRequestUtil.retryableExternalRequestConnectionReset(() -> this.morphiaDatastoreProvider.getDatastore().update(query, workflowExecutionUpdateOperations));
        LOGGER.debug("WorkflowExecution monitor information for datasetId '{}' updated in Mongo. (UpdateResults: {})", (Object)workflowExecution.getDatasetId(), (Object)(updateResults == null ? 0 : updateResults.getUpdatedCount()));
    }

    public void setCancellingState(WorkflowExecution workflowExecution, MetisUser metisUser) {
        UpdateOperations workflowExecutionUpdateOperations = this.morphiaDatastoreProvider.getDatastore().createUpdateOperations(WorkflowExecution.class);
        Query query = this.morphiaDatastoreProvider.getDatastore().find(WorkflowExecution.class).filter("_id", (Object)workflowExecution.getId());
        workflowExecutionUpdateOperations.set("cancelling", (Object)Boolean.TRUE);
        String cancelledBy = metisUser == null || metisUser.getUserId() == null ? CancelledSystemId.SYSTEM_MINUTE_CAP_EXPIRE.name() : metisUser.getUserId();
        workflowExecutionUpdateOperations.set("cancelledBy", (Object)cancelledBy);
        UpdateResults updateResults = (UpdateResults)ExternalRequestUtil.retryableExternalRequestConnectionReset(() -> this.morphiaDatastoreProvider.getDatastore().update(query, workflowExecutionUpdateOperations));
        LOGGER.debug("WorkflowExecution cancelling for datasetId '{}' set to true in Mongo. (UpdateResults: {})", (Object)workflowExecution.getDatasetId(), (Object)(updateResults == null ? 0 : updateResults.getUpdatedCount()));
    }

    @Override
    public WorkflowExecution getById(String id) {
        Query query = (Query)this.morphiaDatastoreProvider.getDatastore().find(WorkflowExecution.class).field("_id").equal((Object)new ObjectId(id));
        return (WorkflowExecution)ExternalRequestUtil.retryableExternalRequestConnectionReset(() -> ((Query)query).get());
    }

    @Override
    public boolean delete(WorkflowExecution workflowExecution) {
        return false;
    }

    public WorkflowExecution getRunningOrInQueueExecution(String datasetId) {
        Query query = (Query)this.morphiaDatastoreProvider.getDatastore().find(WorkflowExecution.class).field(DATASET_ID).equal((Object)datasetId);
        query.or(new Criteria[]{(Criteria)query.criteria(WORKFLOW_STATUS).equal((Object)WorkflowStatus.INQUEUE), (Criteria)query.criteria(WORKFLOW_STATUS).equal((Object)WorkflowStatus.RUNNING)});
        return (WorkflowExecution)ExternalRequestUtil.retryableExternalRequestConnectionReset(() -> ((Query)query).get());
    }

    public boolean exists(WorkflowExecution workflowExecution) {
        return ExternalRequestUtil.retryableExternalRequestConnectionReset(() -> (WorkflowExecution)((Query)this.morphiaDatastoreProvider.getDatastore().find(WorkflowExecution.class).field(DATASET_ID).equal((Object)workflowExecution.getDatasetId())).project("_id", true).get()) != null;
    }

    public String existsAndNotCompleted(String datasetId) {
        Query query = (Query)this.morphiaDatastoreProvider.getDatastore().find(WorkflowExecution.class).field(DATASET_ID).equal((Object)datasetId);
        query.or(new Criteria[]{(Criteria)query.criteria(WORKFLOW_STATUS).equal((Object)WorkflowStatus.INQUEUE), (Criteria)query.criteria(WORKFLOW_STATUS).equal((Object)WorkflowStatus.RUNNING)});
        query.project("_id", true);
        query.project(WORKFLOW_STATUS, true);
        WorkflowExecution storedWorkflowExecution = (WorkflowExecution)ExternalRequestUtil.retryableExternalRequestConnectionReset(() -> ((Query)query).get());
        if (storedWorkflowExecution != null) {
            return storedWorkflowExecution.getId().toString();
        }
        return null;
    }

    public AbstractExecutablePlugin getFirstFinishedWorkflowExecutionPluginByDatasetIdAndPluginType(String datasetId, Set<ExecutablePluginType> pluginTypes) {
        return this.getFirstOrLastFinishedWorkflowExecutionPluginByDatasetIdAndPluginType(datasetId, pluginTypes, false, true);
    }

    public AbstractExecutablePlugin getLastFinishedWorkflowExecutionPluginByDatasetIdAndPluginType(String datasetId, Set<ExecutablePluginType> pluginTypes, boolean limitToValidData) {
        return this.getFirstOrLastFinishedWorkflowExecutionPluginByDatasetIdAndPluginType(datasetId, pluginTypes, limitToValidData, false);
    }

    AbstractExecutablePlugin getFirstOrLastFinishedWorkflowExecutionPluginByDatasetIdAndPluginType(String datasetId, Set<ExecutablePluginType> pluginTypes, boolean limitToValidData, boolean firstFinished) {
        String orderField;
        Iterator metisPluginsIterator;
        AbstractMetisPlugin uncastResult;
        Query query = this.morphiaDatastoreProvider.getDatastore().createQuery(WorkflowExecution.class);
        AggregationPipeline aggregation = this.morphiaDatastoreProvider.getDatastore().createAggregation(WorkflowExecution.class);
        Criteria[] criteria = new Criteria[]{(Criteria)query.criteria(DATASET_ID).equal((Object)datasetId), (Criteria)query.criteria("metisPlugins.pluginStatus").equal((Object)PluginStatus.FINISHED)};
        query.and(criteria);
        ArrayList<Object> criteriaContainer = new ArrayList<Object>();
        if (pluginTypes != null) {
            for (ExecutablePluginType pluginType : pluginTypes) {
                if (pluginType == null) continue;
                criteriaContainer.add(query.criteria("metisPlugins.pluginType").equal((Object)pluginType.toPluginType()));
            }
        }
        if (!criteriaContainer.isEmpty()) {
            query.or((Criteria[])criteriaContainer.toArray(new CriteriaContainerImpl[0]));
        }
        if ((uncastResult = (AbstractMetisPlugin)Optional.ofNullable(metisPluginsIterator = (Iterator)ExternalRequestUtil.retryableExternalRequestConnectionReset(() -> WorkflowExecutionDao.lambda$getFirstOrLastFinishedWorkflowExecutionPluginByDatasetIdAndPluginType$6(aggregation, query, firstFinished, orderField = "metisPlugins." + OrderField.FINISHED_DATE.getOrderFieldName()))).filter(Iterator::hasNext).map(Iterator::next).map(WorkflowExecution::getMetisPlugins).filter(plugins -> !plugins.isEmpty()).map(plugins -> (AbstractMetisPlugin)plugins.get(0)).orElse(null)) == null) {
            return null;
        }
        if (!(uncastResult instanceof AbstractExecutablePlugin)) {
            LOGGER.warn("Found plugin {} for executable plugin type {} that is not itself executable.", (Object)uncastResult.getId(), (Object)uncastResult.getPluginType());
            return null;
        }
        AbstractExecutablePlugin castResult = (AbstractExecutablePlugin)uncastResult;
        Object result = limitToValidData && AbstractExecutablePlugin.getDataStatus((AbstractExecutablePlugin)castResult) != DataStatus.VALID ? null : castResult;
        return result;
    }

    public List<WorkflowExecution> getAllWorkflowExecutions(Set<String> datasetIds, Set<WorkflowStatus> workflowStatuses, OrderField orderField, boolean ascending, int nextPage) {
        Query query = this.morphiaDatastoreProvider.getDatastore().createQuery(WorkflowExecution.class);
        if (datasetIds != null && !datasetIds.isEmpty()) {
            query.field(DATASET_ID).in(datasetIds);
        }
        if (!CollectionUtils.isEmpty(workflowStatuses)) {
            query.field(WORKFLOW_STATUS).in(workflowStatuses);
        }
        if (orderField != null) {
            if (ascending) {
                query.order(orderField.getOrderFieldName());
            } else {
                query.order("-" + orderField.getOrderFieldName());
            }
        }
        return (List)ExternalRequestUtil.retryableExternalRequestConnectionReset(() -> query.asList(new FindOptions().skip(nextPage * this.getWorkflowExecutionsPerRequest()).limit(this.getWorkflowExecutionsPerRequest())));
    }

    public List<ExecutionDatasetPair> getWorkflowExecutionsOverview(Set<String> datasetIds, Set<PluginStatus> pluginStatuses, Set<PluginType> pluginTypes, Date fromDate, Date toDate, int nextPage, int pageCount) {
        AggregationPipeline pipeline = this.morphiaDatastoreProvider.getDatastore().createAggregation(WorkflowExecution.class);
        Query<WorkflowExecution> query = this.createQueryFilters(datasetIds, pluginStatuses, pluginTypes, fromDate, toDate);
        pipeline.match(query);
        String statusIndexField = this.determineOrderingStatusIndex(pipeline);
        pipeline.sort(new Sort[]{Sort.ascending((String)statusIndexField), Sort.descending((String)OrderField.CREATED_DATE.getOrderFieldName())});
        pipeline.skip(nextPage * this.getWorkflowExecutionsPerRequest()).limit(this.getWorkflowExecutionsPerRequest() * pageCount);
        this.joinDatasetAndWorkflowExecution(pipeline);
        ArrayList<ExecutionDatasetPair> result = new ArrayList<ExecutionDatasetPair>();
        pipeline.aggregate(ExecutionDatasetPair.class).forEachRemaining(result::add);
        return result;
    }

    private Query<WorkflowExecution> createQueryFilters(Set<String> datasetIds, Set<PluginStatus> pluginStatuses, Set<PluginType> pluginTypes, Date fromDate, Date toDate) {
        Query query = this.morphiaDatastoreProvider.getDatastore().createQuery(WorkflowExecution.class).disableValidation();
        if (datasetIds != null) {
            query.field(DATASET_ID).in(datasetIds);
        }
        Query metisPluginsSubQuery = this.morphiaDatastoreProvider.getDatastore().createQuery(AbstractMetisPlugin.class);
        if (!CollectionUtils.isEmpty(pluginTypes)) {
            metisPluginsSubQuery.field(PLUGIN_TYPE).in(pluginTypes);
        }
        if (!CollectionUtils.isEmpty(pluginStatuses)) {
            metisPluginsSubQuery.field(PLUGIN_STATUS).in(pluginStatuses);
        }
        if (fromDate != null) {
            metisPluginsSubQuery.field(OrderField.STARTED_DATE.getOrderFieldName()).greaterThanOrEq((Object)fromDate);
        }
        if (toDate != null) {
            metisPluginsSubQuery.field(OrderField.STARTED_DATE.getOrderFieldName()).lessThan((Object)toDate);
        }
        query.field(METIS_PLUGINS).elemMatch(metisPluginsSubQuery);
        return query;
    }

    private String determineOrderingStatusIndex(AggregationPipeline pipeline) {
        String statusInQueueField = "statusInQueue";
        String statusRunningField = "statusRunning";
        pipeline.project(new Projection[]{Projection.projection((String)"statusInQueue", (Projection)Projection.expression((String)MONGO_COND_OPERATOR, (Object[])new Object[]{Projection.expression((String)FilterOperator.EQUAL.val(), (Object[])new Object[]{WorkflowStatus.INQUEUE.name(), "$workflowStatus"}), 1, 0}), (Projection[])new Projection[0]), Projection.projection((String)"statusRunning", (Projection)Projection.expression((String)MONGO_COND_OPERATOR, (Object[])new Object[]{Projection.expression((String)FilterOperator.EQUAL.val(), (Object[])new Object[]{WorkflowStatus.RUNNING.name(), "$workflowStatus"}), 2, 0}), (Projection[])new Projection[0]), Projection.projection((String)OrderField.CREATED_DATE.getOrderFieldName()), Projection.projection((String)DATASET_ID)});
        String statusIndexField = "statusIndex";
        Projection sumExpression = Projection.add((Object[])new Object[]{"$statusInQueue", "$statusRunning"});
        pipeline.project(new Projection[]{Projection.projection((String)"statusIndex", (Projection)Projection.expression((String)MONGO_COND_OPERATOR, (Object[])new Object[]{Projection.expression((String)FilterOperator.EQUAL.val(), (Object[])new Object[]{sumExpression, 0}), 3, sumExpression}), (Projection[])new Projection[0]), Projection.projection((String)OrderField.CREATED_DATE.getOrderFieldName()), Projection.projection((String)DATASET_ID)});
        return "statusIndex";
    }

    private void joinDatasetAndWorkflowExecution(AggregationPipeline pipeline) {
        String datasetCollectionName = this.morphiaDatastoreProvider.getDatastore().getCollection(Dataset.class).getName();
        String executionCollectionName = this.morphiaDatastoreProvider.getDatastore().getCollection(WorkflowExecution.class).getName();
        String datasetListField = "datasetList";
        String executionListField = "executionList";
        pipeline.lookup(datasetCollectionName, DATASET_ID, DATASET_ID, "datasetList");
        pipeline.lookup(executionCollectionName, "_id", "_id", "executionList");
        String datasetField = "dataset";
        String executionField = "execution";
        pipeline.project(new Projection[]{Projection.projection((String)"dataset", (Projection)Projection.expression((String)"$arrayElemAt", (Object[])new Object[]{"$datasetList", 0}), (Projection[])new Projection[0]), Projection.projection((String)"execution", (Projection)Projection.expression((String)"$arrayElemAt", (Object[])new Object[]{"$executionList", 0}), (Projection[])new Projection[0]), Projection.projection((String)"_id").suppress()});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getWorkflowExecutionsPerRequest() {
        WorkflowExecutionDao workflowExecutionDao = this;
        synchronized (workflowExecutionDao) {
            return this.workflowExecutionsPerRequest;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setWorkflowExecutionsPerRequest(int workflowExecutionsPerRequest) {
        WorkflowExecutionDao workflowExecutionDao = this;
        synchronized (workflowExecutionDao) {
            this.workflowExecutionsPerRequest = workflowExecutionsPerRequest;
        }
    }

    public boolean isCancelled(ObjectId id) {
        WorkflowExecution workflowExecution = (WorkflowExecution)ExternalRequestUtil.retryableExternalRequestConnectionReset(() -> (WorkflowExecution)((Query)this.morphiaDatastoreProvider.getDatastore().find(WorkflowExecution.class).field("_id").equal((Object)id)).project(WORKFLOW_STATUS, true).get());
        return workflowExecution != null && workflowExecution.getWorkflowStatus() == WorkflowStatus.CANCELLED;
    }

    public boolean isCancelling(ObjectId id) {
        WorkflowExecution workflowExecution = (WorkflowExecution)ExternalRequestUtil.retryableExternalRequestConnectionReset(() -> (WorkflowExecution)((Query)this.morphiaDatastoreProvider.getDatastore().find(WorkflowExecution.class).field("_id").equal((Object)id)).project("cancelling", true).get());
        return workflowExecution != null && workflowExecution.isCancelling();
    }

    public boolean deleteAllByDatasetId(String datasetId) {
        Query query = this.morphiaDatastoreProvider.getDatastore().createQuery(WorkflowExecution.class);
        query.field(DATASET_ID).equal((Object)datasetId);
        WriteResult delete = (WriteResult)ExternalRequestUtil.retryableExternalRequestConnectionReset(() -> this.morphiaDatastoreProvider.getDatastore().delete(query));
        LOGGER.debug("WorkflowExecution with datasetId: {}, deleted from Mongo", (Object)datasetId);
        return (delete == null ? 0 : delete.getN()) >= 1;
    }

    public WorkflowExecution getByExternalTaskId(long externalTaskId) {
        Query subQuery = this.morphiaDatastoreProvider.getDatastore().createQuery(AbstractExecutablePlugin.class);
        subQuery.field("externalTaskId").equal((Object)Long.toString(externalTaskId));
        Query query = this.morphiaDatastoreProvider.getDatastore().createQuery(WorkflowExecution.class).disableValidation();
        query.field(METIS_PLUGINS).elemMatch(subQuery);
        List resultList = (List)ExternalRequestUtil.retryableExternalRequestConnectionReset(() -> query.asList(new FindOptions().limit(1)));
        return CollectionUtils.isEmpty((Collection)resultList) ? null : (WorkflowExecution)resultList.get(0);
    }

    public WorkflowExecution getByTaskExecution(Date startedDate, PluginType pluginType, String datasetId) {
        Query subQuery = this.morphiaDatastoreProvider.getDatastore().createQuery(AbstractMetisPlugin.class);
        subQuery.field(OrderField.STARTED_DATE.getOrderFieldName()).equal((Object)startedDate);
        subQuery.field(PLUGIN_TYPE).equal((Object)pluginType);
        Query query = this.morphiaDatastoreProvider.getDatastore().createQuery(WorkflowExecution.class);
        query.field(DATASET_ID).equal((Object)datasetId);
        query.field(METIS_PLUGINS).elemMatch(subQuery);
        List resultList = (List)ExternalRequestUtil.retryableExternalRequestConnectionReset(() -> query.asList(new FindOptions().limit(1)));
        return CollectionUtils.isEmpty((Collection)resultList) ? null : (WorkflowExecution)resultList.get(0);
    }

    private static /* synthetic */ Iterator lambda$getFirstOrLastFinishedWorkflowExecutionPluginByDatasetIdAndPluginType$6(AggregationPipeline aggregation, Query query, boolean firstFinished, String orderField) {
        return aggregation.match(query).unwind(METIS_PLUGINS).match(query).sort(new Sort[]{firstFinished ? Sort.ascending((String)orderField) : Sort.descending((String)orderField)}).limit(1).aggregate(WorkflowExecution.class);
    }

    public static class ExecutionDatasetPair {
        private Dataset dataset;
        private WorkflowExecution execution;

        public ExecutionDatasetPair() {
        }

        public ExecutionDatasetPair(Dataset dataset, WorkflowExecution execution) {
            this.dataset = dataset;
            this.execution = execution;
        }

        public Dataset getDataset() {
            return this.dataset;
        }

        public WorkflowExecution getExecution() {
            return this.execution;
        }
    }
}

