/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.metis.core.dao;

import com.mongodb.WriteResult;
import eu.europeana.metis.core.dao.MetisDao;
import eu.europeana.metis.core.mongo.MorphiaDatastoreProvider;
import eu.europeana.metis.core.rest.RequestLimits;
import eu.europeana.metis.core.workflow.Workflow;
import eu.europeana.metis.utils.ExternalRequestUtil;
import org.bson.types.ObjectId;
import org.mongodb.morphia.Key;
import org.mongodb.morphia.query.Query;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Repository;

@Repository
public class WorkflowDao
implements MetisDao<Workflow, String> {
    private static final Logger LOGGER = LoggerFactory.getLogger(WorkflowDao.class);
    private static final String DATASET_ID = "datasetId";
    private int workflowsPerRequest = RequestLimits.WORKFLOWS_PER_REQUEST.getLimit();
    private final MorphiaDatastoreProvider morphiaDatastoreProvider;

    public WorkflowDao(MorphiaDatastoreProvider morphiaDatastoreProvider) {
        this.morphiaDatastoreProvider = morphiaDatastoreProvider;
    }

    @Override
    public String create(Workflow workflow) {
        Key workflowKey = (Key)ExternalRequestUtil.retryableExternalRequestConnectionReset(() -> this.morphiaDatastoreProvider.getDatastore().save((Object)workflow));
        LOGGER.info("Workflow for datasetId '{}' created in Mongo", (Object)workflow.getDatasetId());
        return workflowKey == null ? null : workflowKey.getId().toString();
    }

    @Override
    public String update(Workflow workflow) {
        Key workflowKey = (Key)ExternalRequestUtil.retryableExternalRequestConnectionReset(() -> this.morphiaDatastoreProvider.getDatastore().save((Object)workflow));
        LOGGER.info("Workflow for datasetId '{}' updated in Mongo", (Object)workflow.getDatasetId());
        return workflowKey == null ? null : workflowKey.getId().toString();
    }

    @Override
    public Workflow getById(String id) {
        Query query = (Query)this.morphiaDatastoreProvider.getDatastore().find(Workflow.class).field("_id").equal((Object)new ObjectId(id));
        return (Workflow)ExternalRequestUtil.retryableExternalRequestConnectionReset(() -> ((Query)query).get());
    }

    @Override
    public boolean delete(Workflow workflow) {
        return this.deleteWorkflow(workflow.getDatasetId());
    }

    public boolean deleteWorkflow(String datasetId) {
        Query query = this.morphiaDatastoreProvider.getDatastore().createQuery(Workflow.class);
        query.field(DATASET_ID).equal((Object)datasetId);
        WriteResult delete = (WriteResult)ExternalRequestUtil.retryableExternalRequestConnectionReset(() -> this.morphiaDatastoreProvider.getDatastore().delete(query));
        LOGGER.info("Workflow with datasetId {}, deleted from Mongo", (Object)datasetId);
        return (delete == null ? 0 : delete.getN()) == 1;
    }

    public String exists(Workflow workflow) {
        Workflow storedWorkflow = (Workflow)ExternalRequestUtil.retryableExternalRequestConnectionReset(() -> (Workflow)((Query)this.morphiaDatastoreProvider.getDatastore().find(Workflow.class).field(DATASET_ID).equal((Object)workflow.getDatasetId())).project("_id", true).get());
        return storedWorkflow == null ? null : storedWorkflow.getId().toString();
    }

    public Workflow getWorkflow(String datasetId) {
        return (Workflow)ExternalRequestUtil.retryableExternalRequestConnectionReset(() -> (Workflow)((Query)this.morphiaDatastoreProvider.getDatastore().find(Workflow.class).field(DATASET_ID).equal((Object)datasetId)).get());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getWorkflowsPerRequest() {
        WorkflowDao workflowDao = this;
        synchronized (workflowDao) {
            return this.workflowsPerRequest;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setWorkflowsPerRequest(int workflowsPerRequest) {
        WorkflowDao workflowDao = this;
        synchronized (workflowDao) {
            this.workflowsPerRequest = workflowsPerRequest;
        }
    }
}

