/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.metis.core.dao;

import com.mongodb.WriteResult;
import eu.europeana.metis.core.dao.MetisDao;
import eu.europeana.metis.core.mongo.MorphiaDatastoreProvider;
import eu.europeana.metis.core.rest.RequestLimits;
import eu.europeana.metis.core.workflow.OrderField;
import eu.europeana.metis.core.workflow.ScheduleFrequence;
import eu.europeana.metis.core.workflow.ScheduledWorkflow;
import eu.europeana.metis.utils.ExternalRequestUtil;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.Date;
import java.util.List;
import org.bson.types.ObjectId;
import org.mongodb.morphia.Key;
import org.mongodb.morphia.query.Criteria;
import org.mongodb.morphia.query.CriteriaContainerImpl;
import org.mongodb.morphia.query.FindOptions;
import org.mongodb.morphia.query.Query;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@Repository
public class ScheduledWorkflowDao
implements MetisDao<ScheduledWorkflow, String> {
    private static final Logger LOGGER = LoggerFactory.getLogger(ScheduledWorkflowDao.class);
    private static final String DATASET_ID = "datasetId";
    private int scheduledWorkflowPerRequest = RequestLimits.SCHEDULED_EXECUTIONS_PER_REQUEST.getLimit();
    private final MorphiaDatastoreProvider morphiaDatastoreProvider;

    @Autowired
    public ScheduledWorkflowDao(MorphiaDatastoreProvider morphiaDatastoreProvider) {
        this.morphiaDatastoreProvider = morphiaDatastoreProvider;
    }

    @Override
    public String create(ScheduledWorkflow scheduledWorkflow) {
        Key scheduledWorkflowKey = (Key)ExternalRequestUtil.retryableExternalRequestConnectionReset(() -> this.morphiaDatastoreProvider.getDatastore().save((Object)scheduledWorkflow));
        LOGGER.debug("ScheduledWorkflow for datasetName: '{}' created in Mongo", (Object)scheduledWorkflow.getDatasetId());
        return scheduledWorkflowKey == null ? null : scheduledWorkflowKey.getId().toString();
    }

    @Override
    public String update(ScheduledWorkflow scheduledWorkflow) {
        Key scheduledWorkflowKey = (Key)ExternalRequestUtil.retryableExternalRequestConnectionReset(() -> this.morphiaDatastoreProvider.getDatastore().save((Object)scheduledWorkflow));
        LOGGER.debug("ScheduledWorkflow with datasetId: '{}' updated in Mongo", (Object)scheduledWorkflow.getDatasetId());
        return scheduledWorkflowKey == null ? null : scheduledWorkflowKey.getId().toString();
    }

    @Override
    public ScheduledWorkflow getById(String id) {
        Query query = (Query)this.morphiaDatastoreProvider.getDatastore().find(ScheduledWorkflow.class).field("_id").equal((Object)new ObjectId(id));
        return (ScheduledWorkflow)ExternalRequestUtil.retryableExternalRequestConnectionReset(() -> ((Query)query).get());
    }

    @Override
    public boolean delete(ScheduledWorkflow scheduledWorkflow) {
        return false;
    }

    public ScheduledWorkflow getScheduledWorkflow(String datasetId) {
        return (ScheduledWorkflow)ExternalRequestUtil.retryableExternalRequestConnectionReset(() -> (ScheduledWorkflow)((Query)this.morphiaDatastoreProvider.getDatastore().find(ScheduledWorkflow.class).field(DATASET_ID).equal((Object)datasetId)).get());
    }

    public ScheduledWorkflow getScheduledWorkflowByDatasetId(String datasetId) {
        return (ScheduledWorkflow)ExternalRequestUtil.retryableExternalRequestConnectionReset(() -> (ScheduledWorkflow)((Query)this.morphiaDatastoreProvider.getDatastore().find(ScheduledWorkflow.class).field(DATASET_ID).equal((Object)datasetId)).get());
    }

    public boolean exists(ScheduledWorkflow scheduledWorkflow) {
        return ExternalRequestUtil.retryableExternalRequestConnectionReset(() -> (ScheduledWorkflow)((Query)this.morphiaDatastoreProvider.getDatastore().find(ScheduledWorkflow.class).field(DATASET_ID).equal((Object)scheduledWorkflow.getDatasetId())).project("_id", true).get()) != null;
    }

    public String existsForDatasetId(String datasetId) {
        ScheduledWorkflow storedScheduledWorkflow = (ScheduledWorkflow)ExternalRequestUtil.retryableExternalRequestConnectionReset(() -> (ScheduledWorkflow)((Query)this.morphiaDatastoreProvider.getDatastore().find(ScheduledWorkflow.class).field(DATASET_ID).equal((Object)datasetId)).project("_id", true).get());
        return storedScheduledWorkflow == null ? null : storedScheduledWorkflow.getId().toString();
    }

    public boolean deleteScheduledWorkflow(String datasetId) {
        Query query = this.morphiaDatastoreProvider.getDatastore().createQuery(ScheduledWorkflow.class);
        query.field(DATASET_ID).equal((Object)datasetId);
        WriteResult delete = (WriteResult)ExternalRequestUtil.retryableExternalRequestConnectionReset(() -> this.morphiaDatastoreProvider.getDatastore().delete(query));
        LOGGER.debug("ScheduledWorkflow with datasetId: {} deleted from Mongo", (Object)datasetId);
        return (delete == null ? 0 : delete.getN()) == 1;
    }

    public boolean deleteAllByDatasetId(String datasetId) {
        Query query = this.morphiaDatastoreProvider.getDatastore().createQuery(ScheduledWorkflow.class);
        query.field(DATASET_ID).equal((Object)datasetId);
        WriteResult delete = (WriteResult)ExternalRequestUtil.retryableExternalRequestConnectionReset(() -> this.morphiaDatastoreProvider.getDatastore().delete(query));
        LOGGER.debug("ScheduledWorkflows with datasetId: {} deleted from Mongo", (Object)datasetId);
        return (delete == null ? 0 : delete.getN()) >= 1;
    }

    public List<ScheduledWorkflow> getAllScheduledWorkflows(ScheduleFrequence scheduleFrequence, int nextPage) {
        Query query = this.morphiaDatastoreProvider.getDatastore().createQuery(ScheduledWorkflow.class);
        if (scheduleFrequence != null && scheduleFrequence != ScheduleFrequence.NULL) {
            query.field("scheduleFrequence").equal((Object)scheduleFrequence);
        }
        query.order(OrderField.ID.getOrderFieldName());
        return (List)ExternalRequestUtil.retryableExternalRequestConnectionReset(() -> query.asList(new FindOptions().skip(nextPage * this.getScheduledWorkflowPerRequest()).limit(this.getScheduledWorkflowPerRequest())));
    }

    public List<ScheduledWorkflow> getAllScheduledWorkflowsByDateRangeONCE(LocalDateTime lowerBound, LocalDateTime upperBound, int nextPage) {
        Query query = this.morphiaDatastoreProvider.getDatastore().createQuery(ScheduledWorkflow.class);
        ((CriteriaContainerImpl)query.criteria("scheduleFrequence").equal((Object)ScheduleFrequence.ONCE)).and(new Criteria[]{(Criteria)query.criteria("pointerDate").greaterThanOrEq((Object)Date.from(lowerBound.atZone(ZoneId.systemDefault()).toInstant()))}).and(new Criteria[]{(Criteria)query.criteria("pointerDate").lessThan((Object)Date.from(upperBound.atZone(ZoneId.systemDefault()).toInstant()))});
        query.order(OrderField.ID.getOrderFieldName());
        return (List)ExternalRequestUtil.retryableExternalRequestConnectionReset(() -> query.asList(new FindOptions().skip(nextPage * this.getScheduledWorkflowPerRequest()).limit(this.getScheduledWorkflowPerRequest())));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getScheduledWorkflowPerRequest() {
        ScheduledWorkflowDao scheduledWorkflowDao = this;
        synchronized (scheduledWorkflowDao) {
            return this.scheduledWorkflowPerRequest;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setScheduledWorkflowPerRequest(int scheduledWorkflowPerRequest) {
        ScheduledWorkflowDao scheduledWorkflowDao = this;
        synchronized (scheduledWorkflowDao) {
            this.scheduledWorkflowPerRequest = scheduledWorkflowPerRequest;
        }
    }
}

