/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.metis.core.dao;

import com.mongodb.WriteResult;
import eu.europeana.metis.core.dao.MetisDao;
import eu.europeana.metis.core.dataset.DatasetXslt;
import eu.europeana.metis.core.mongo.MorphiaDatastoreProvider;
import eu.europeana.metis.utils.ExternalRequestUtil;
import org.bson.types.ObjectId;
import org.mongodb.morphia.Key;
import org.mongodb.morphia.query.Query;
import org.mongodb.morphia.query.Sort;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@Repository
public class DatasetXsltDao
implements MetisDao<DatasetXslt, String> {
    private static final Logger LOGGER = LoggerFactory.getLogger(DatasetXsltDao.class);
    private static final String ID = "_id";
    private static final String DATASET_ID = "datasetId";
    public static final String DEFAULT_DATASET_ID = "-1";
    private final MorphiaDatastoreProvider morphiaDatastoreProvider;

    @Autowired
    public DatasetXsltDao(MorphiaDatastoreProvider morphiaDatastoreProvider) {
        this.morphiaDatastoreProvider = morphiaDatastoreProvider;
    }

    @Override
    public String create(DatasetXslt datasetXslt) {
        Key datasetKey = (Key)ExternalRequestUtil.retryableExternalRequestConnectionReset(() -> this.morphiaDatastoreProvider.getDatastore().save((Object)datasetXslt));
        LOGGER.debug("DatasetXslt for datasetId: '{}'created in Mongo", (Object)datasetXslt.getDatasetId());
        return datasetKey == null ? null : datasetKey.getId().toString();
    }

    @Override
    public String update(DatasetXslt datasetXslt) {
        Key datasetKey = (Key)ExternalRequestUtil.retryableExternalRequestConnectionReset(() -> this.morphiaDatastoreProvider.getDatastore().save((Object)datasetXslt));
        LOGGER.debug("DatasetXslt for datasetId: '{}' updated in Mongo", (Object)datasetXslt.getDatasetId());
        return datasetKey == null ? null : datasetKey.getId().toString();
    }

    @Override
    public DatasetXslt getById(String id) {
        return (DatasetXslt)ExternalRequestUtil.retryableExternalRequestConnectionReset(() -> (DatasetXslt)this.morphiaDatastoreProvider.getDatastore().find(DatasetXslt.class).filter(ID, (Object)new ObjectId(id)).get());
    }

    @Override
    public boolean delete(DatasetXslt datasetXslt) {
        ExternalRequestUtil.retryableExternalRequestConnectionReset(() -> this.morphiaDatastoreProvider.getDatastore().delete((Query)this.morphiaDatastoreProvider.getDatastore().createQuery(DatasetXslt.class).field(ID).equal((Object)datasetXslt.getId())));
        LOGGER.debug("DatasetXslt with objectId: '{}', datasetId: '{}'deleted in Mongo", (Object)datasetXslt.getId(), (Object)datasetXslt.getDatasetId());
        return true;
    }

    public boolean deleteAllByDatasetId(String datasetId) {
        Query query = this.morphiaDatastoreProvider.getDatastore().createQuery(DatasetXslt.class);
        query.field(DATASET_ID).equal((Object)datasetId);
        WriteResult delete = (WriteResult)ExternalRequestUtil.retryableExternalRequestConnectionReset(() -> this.morphiaDatastoreProvider.getDatastore().delete(query));
        LOGGER.debug("Xslts with datasetId: {}, deleted from Mongo", (Object)datasetId);
        return (delete == null ? 0 : delete.getN()) >= 1;
    }

    public DatasetXslt getLatestXsltForDatasetId(String datasetId) {
        return (DatasetXslt)ExternalRequestUtil.retryableExternalRequestConnectionReset(() -> (DatasetXslt)this.morphiaDatastoreProvider.getDatastore().find(DatasetXslt.class).filter(DATASET_ID, (Object)datasetId).order(new Sort[]{Sort.descending((String)"createdDate")}).get());
    }
}

