/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.metis.core.dao;

import eu.europeana.cloud.mcs.driver.DataSetServiceClient;
import eu.europeana.cloud.service.mcs.exception.DataSetAlreadyExistsException;
import eu.europeana.cloud.service.mcs.exception.MCSException;
import eu.europeana.metis.core.dao.MetisDao;
import eu.europeana.metis.core.dataset.Dataset;
import eu.europeana.metis.core.dataset.DatasetIdSequence;
import eu.europeana.metis.core.mongo.MorphiaDatastoreProvider;
import eu.europeana.metis.core.rest.RequestLimits;
import eu.europeana.metis.core.workflow.OrderField;
import eu.europeana.metis.exception.ExternalTaskException;
import eu.europeana.metis.utils.ExternalRequestUtil;
import java.util.List;
import java.util.UUID;
import java.util.function.UnaryOperator;
import org.apache.commons.lang3.StringUtils;
import org.bson.types.ObjectId;
import org.mongodb.morphia.Key;
import org.mongodb.morphia.query.FindOptions;
import org.mongodb.morphia.query.Query;
import org.mongodb.morphia.query.UpdateOperations;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@Repository
public class DatasetDao
implements MetisDao<Dataset, String> {
    private static final Logger LOGGER = LoggerFactory.getLogger(DatasetDao.class);
    private static final String DATASET_NAME = "datasetName";
    static final String DATASET_ID = "datasetId";
    private int datasetsPerRequest = RequestLimits.DATASETS_PER_REQUEST.getLimit();
    private final MorphiaDatastoreProvider morphiaDatastoreProvider;
    private final DataSetServiceClient ecloudDataSetServiceClient;
    private String ecloudProvider;

    @Autowired
    public DatasetDao(MorphiaDatastoreProvider morphiaDatastoreProvider, DataSetServiceClient ecloudDataSetServiceClient) {
        this.morphiaDatastoreProvider = morphiaDatastoreProvider;
        this.ecloudDataSetServiceClient = ecloudDataSetServiceClient;
    }

    @Override
    public String create(Dataset dataset) {
        Key datasetKey = (Key)ExternalRequestUtil.retryableExternalRequestConnectionReset(() -> this.morphiaDatastoreProvider.getDatastore().save((Object)dataset));
        LOGGER.debug("Dataset with datasetId: '{}', datasetName: '{}' and OrganizationId: '{}' created in Mongo", new Object[]{dataset.getDatasetId(), dataset.getDatasetName(), dataset.getOrganizationId()});
        return datasetKey == null ? null : datasetKey.getId().toString();
    }

    @Override
    public String update(Dataset dataset) {
        Key datasetKey = (Key)ExternalRequestUtil.retryableExternalRequestConnectionReset(() -> this.morphiaDatastoreProvider.getDatastore().save((Object)dataset));
        LOGGER.debug("Dataset with datasetId: '{}', datasetName: '{}' and OrganizationId: '{}' updated in Mongo", new Object[]{dataset.getDatasetId(), dataset.getDatasetName(), dataset.getOrganizationId()});
        return datasetKey == null ? null : datasetKey.getId().toString();
    }

    @Override
    public Dataset getById(String id) {
        return (Dataset)ExternalRequestUtil.retryableExternalRequestConnectionReset(() -> (Dataset)this.morphiaDatastoreProvider.getDatastore().find(Dataset.class).filter("_id", (Object)new ObjectId(id)).get());
    }

    @Override
    public boolean delete(Dataset dataset) {
        ExternalRequestUtil.retryableExternalRequestConnectionReset(() -> this.morphiaDatastoreProvider.getDatastore().delete((Query)this.morphiaDatastoreProvider.getDatastore().createQuery(Dataset.class).field(DATASET_ID).equal((Object)dataset.getDatasetId())));
        LOGGER.debug("Dataset with datasetId: '{}', datasetName: '{}' and OrganizationId: '{}' deleted in Mongo", new Object[]{dataset.getDatasetId(), dataset.getDatasetName(), dataset.getOrganizationId()});
        return true;
    }

    public boolean deleteByDatasetId(String datasetId) {
        Dataset dataset = new Dataset();
        dataset.setDatasetId(datasetId);
        return this.delete(dataset);
    }

    public Dataset getDatasetByDatasetName(String datasetName) {
        return (Dataset)ExternalRequestUtil.retryableExternalRequestConnectionReset(() -> (Dataset)((Query)this.morphiaDatastoreProvider.getDatastore().find(Dataset.class).field(DATASET_NAME).equal((Object)datasetName)).get());
    }

    public Dataset getDatasetByDatasetId(String datasetId) {
        return (Dataset)ExternalRequestUtil.retryableExternalRequestConnectionReset(() -> (Dataset)this.morphiaDatastoreProvider.getDatastore().find(Dataset.class).filter(DATASET_ID, (Object)datasetId).get());
    }

    public Dataset getDatasetByOrganizationIdAndDatasetName(String organizationId, String datasetName) {
        return (Dataset)ExternalRequestUtil.retryableExternalRequestConnectionReset(() -> (Dataset)((Query)((Query)this.morphiaDatastoreProvider.getDatastore().find(Dataset.class).field("organizationId").equal((Object)organizationId)).field(DATASET_NAME).equal((Object)datasetName)).get());
    }

    boolean existsDatasetByDatasetName(String datasetName) {
        return ExternalRequestUtil.retryableExternalRequestConnectionReset(() -> (Dataset)((Query)this.morphiaDatastoreProvider.getDatastore().find(Dataset.class).field(DATASET_NAME).equal((Object)datasetName)).project("_id", true).get()) != null;
    }

    public List<Dataset> getAllDatasetsByProvider(String provider, int nextPage) {
        Query query = this.morphiaDatastoreProvider.getDatastore().createQuery(Dataset.class);
        query.field("provider").equal((Object)provider);
        query.order(OrderField.ID.getOrderFieldName());
        return (List)ExternalRequestUtil.retryableExternalRequestConnectionReset(() -> query.asList(new FindOptions().skip(nextPage * this.getDatasetsPerRequest()).limit(this.getDatasetsPerRequest())));
    }

    public List<Dataset> getAllDatasetsByIntermediateProvider(String intermediateProvider, int nextPage) {
        Query query = this.morphiaDatastoreProvider.getDatastore().createQuery(Dataset.class);
        query.field("intermediateProvider").equal((Object)intermediateProvider);
        query.order(OrderField.ID.getOrderFieldName());
        return (List)ExternalRequestUtil.retryableExternalRequestConnectionReset(() -> query.asList(new FindOptions().skip(nextPage * this.getDatasetsPerRequest()).limit(this.getDatasetsPerRequest())));
    }

    public List<Dataset> getAllDatasetsByDataProvider(String dataProvider, int nextPage) {
        Query query = this.morphiaDatastoreProvider.getDatastore().createQuery(Dataset.class);
        query.field("dataProvider").equal((Object)dataProvider);
        query.order(OrderField.ID.getOrderFieldName());
        return (List)ExternalRequestUtil.retryableExternalRequestConnectionReset(() -> query.asList(new FindOptions().skip(nextPage * this.getDatasetsPerRequest()).limit(this.getDatasetsPerRequest())));
    }

    public List<Dataset> getAllDatasetsByOrganizationId(String organizationId, int nextPage) {
        return this.getAllDatasetsByOrganizationId(organizationId, options -> options.skip(nextPage * this.getDatasetsPerRequest()).limit(this.getDatasetsPerRequest()));
    }

    public List<Dataset> getAllDatasetsByOrganizationId(String organizationId) {
        return this.getAllDatasetsByOrganizationId(organizationId, UnaryOperator.identity());
    }

    private List<Dataset> getAllDatasetsByOrganizationId(String organizationId, UnaryOperator<FindOptions> options) {
        Query query = this.morphiaDatastoreProvider.getDatastore().createQuery(Dataset.class);
        query.field("organizationId").equal((Object)organizationId);
        query.order(OrderField.ID.getOrderFieldName());
        return (List)ExternalRequestUtil.retryableExternalRequestConnectionReset(() -> query.asList((FindOptions)options.apply(new FindOptions())));
    }

    public List<Dataset> getAllDatasetsByOrganizationName(String organizationName, int nextPage) {
        Query query = this.morphiaDatastoreProvider.getDatastore().createQuery(Dataset.class);
        query.field("organizationName").equal((Object)organizationName);
        query.order(OrderField.ID.getOrderFieldName());
        return (List)ExternalRequestUtil.retryableExternalRequestConnectionReset(() -> query.asList(new FindOptions().skip(nextPage * this.getDatasetsPerRequest()).limit(this.getDatasetsPerRequest())));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getDatasetsPerRequest() {
        DatasetDao datasetDao = this;
        synchronized (datasetDao) {
            return this.datasetsPerRequest;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDatasetsPerRequest(int datasetsPerRequest) {
        DatasetDao datasetDao = this;
        synchronized (datasetDao) {
            this.datasetsPerRequest = datasetsPerRequest;
        }
    }

    public int findNextInSequenceDatasetId() {
        Dataset dataset;
        DatasetIdSequence datasetIdSequence = (DatasetIdSequence)this.morphiaDatastoreProvider.getDatastore().find(DatasetIdSequence.class).get();
        do {
            datasetIdSequence.setSequence(datasetIdSequence.getSequence() + 1);
        } while ((dataset = this.getDatasetByDatasetId(Integer.toString(datasetIdSequence.getSequence()))) != null);
        Query updateQuery = (Query)this.morphiaDatastoreProvider.getDatastore().createQuery(DatasetIdSequence.class).field("_id").equal((Object)datasetIdSequence.getId());
        UpdateOperations updateOperations = this.morphiaDatastoreProvider.getDatastore().createUpdateOperations(DatasetIdSequence.class).set("sequence", (Object)datasetIdSequence.getSequence());
        ExternalRequestUtil.retryableExternalRequestConnectionReset(() -> this.morphiaDatastoreProvider.getDatastore().update(updateQuery, updateOperations));
        return datasetIdSequence.getSequence();
    }

    public String checkAndCreateDatasetInEcloud(Dataset dataset) throws ExternalTaskException {
        if (StringUtils.isEmpty((CharSequence)dataset.getEcloudDatasetId()) || dataset.getEcloudDatasetId().startsWith("NOT_CREATED_YET")) {
            String uuid = UUID.randomUUID().toString();
            dataset.setEcloudDatasetId(uuid);
            try {
                this.ecloudDataSetServiceClient.createDataSet(this.getEcloudProvider(), uuid, "Metis generated dataset");
                this.update(dataset);
            }
            catch (DataSetAlreadyExistsException e) {
                LOGGER.info("Dataset already exist, not recreating", (Throwable)e);
                throw new ExternalTaskException("Dataset already exist, not recreating", (Throwable)e);
            }
            catch (MCSException e) {
                LOGGER.error("An error has occurred during ecloud dataset creation.", (Throwable)e);
                throw new ExternalTaskException("An error has occurred during ecloud dataset creation.", (Throwable)e);
            }
        } else {
            LOGGER.info("Dataset with datasetId {} already has a dataset initialized in Ecloud with id {}", (Object)dataset.getDatasetId(), (Object)dataset.getEcloudDatasetId());
        }
        return dataset.getEcloudDatasetId();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setEcloudProvider(String ecloudProvider) {
        DatasetDao datasetDao = this;
        synchronized (datasetDao) {
            this.ecloudProvider = ecloudProvider;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getEcloudProvider() {
        DatasetDao datasetDao = this;
        synchronized (datasetDao) {
            return this.ecloudProvider;
        }
    }
}

