/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.metis.core.rest.config;

import com.mongodb.client.MongoClient;
import eu.europeana.corelib.web.socks.SocksProxy;
import eu.europeana.metis.core.rest.config.ConfigurationPropertiesHolder;
import eu.europeana.metis.mongo.connection.MongoClientProvider;
import eu.europeana.metis.utils.CustomTruststoreAppender;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class ApplicationInitUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(ApplicationInitUtils.class);

    private ApplicationInitUtils() {
    }

    static MongoClient initializeApplication(ConfigurationPropertiesHolder propertiesHolder) throws CustomTruststoreAppender.TrustStoreConfigurationException {
        if (StringUtils.isNotEmpty((CharSequence)propertiesHolder.getTruststorePath()) && StringUtils.isNotEmpty((CharSequence)propertiesHolder.getTruststorePassword())) {
            CustomTruststoreAppender.appendCustomTrustoreToDefault((String)propertiesHolder.getTruststorePath(), (String)propertiesHolder.getTruststorePassword());
            LOGGER.info("Custom truststore appended to default truststore");
        }
        if (propertiesHolder.isSocksProxyEnabled()) {
            new SocksProxy(propertiesHolder.getSocksProxyHost(), propertiesHolder.getSocksProxyPort(), propertiesHolder.getSocksProxyUsername(), propertiesHolder.getSocksProxyPassword()).init();
            LOGGER.info("Socks proxy enabled");
        }
        return new MongoClientProvider(propertiesHolder.getMongoProperties()).createMongoClient();
    }
}

