/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.metis.core.rest.exception;

import eu.europeana.metis.exception.GenericMetisException;
import eu.europeana.metis.exception.StructuredExceptionWrapper;
import javax.servlet.http.HttpServletResponse;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.http.HttpStatus;
import org.springframework.http.converter.HttpMessageNotReadableException;
import org.springframework.web.HttpRequestMethodNotSupportedException;
import org.springframework.web.bind.MissingRequestHeaderException;
import org.springframework.web.bind.MissingServletRequestParameterException;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.method.annotation.MethodArgumentTypeMismatchException;

@ControllerAdvice
public class RestResponseExceptionHandler {
    private static final String AUTHORIZATION_HEADER = "Authorization";

    @ExceptionHandler(value={GenericMetisException.class})
    @ResponseBody
    public StructuredExceptionWrapper handleException(Exception exception, HttpServletResponse response) {
        ResponseStatus annotationResponseStatus = (ResponseStatus)AnnotationUtils.findAnnotation(exception.getClass(), ResponseStatus.class);
        HttpStatus status = annotationResponseStatus == null ? HttpStatus.INTERNAL_SERVER_ERROR : annotationResponseStatus.value();
        response.setStatus(status.value());
        return new StructuredExceptionWrapper(exception.getMessage());
    }

    @ExceptionHandler(value={HttpMessageNotReadableException.class})
    @ResponseBody
    public StructuredExceptionWrapper handleMessageNotReadable(HttpMessageNotReadableException exception, HttpServletResponse response) {
        response.setStatus(HttpStatus.NOT_ACCEPTABLE.value());
        return new StructuredExceptionWrapper("Message body not readable. It is missing or malformed\n" + exception.getMessage());
    }

    @ExceptionHandler(value={MissingServletRequestParameterException.class})
    @ResponseBody
    public StructuredExceptionWrapper handleMissingParams(MissingServletRequestParameterException exception, HttpServletResponse response) {
        response.setStatus(HttpStatus.NOT_ACCEPTABLE.value());
        return new StructuredExceptionWrapper(exception.getParameterName() + " parameter is missing");
    }

    @ExceptionHandler(value={HttpRequestMethodNotSupportedException.class})
    @ResponseBody
    public StructuredExceptionWrapper handleMissingParams(HttpRequestMethodNotSupportedException exception, HttpServletResponse response) {
        response.setStatus(HttpStatus.METHOD_NOT_ALLOWED.value());
        return new StructuredExceptionWrapper("Method not allowed: " + exception.getMessage());
    }

    @ExceptionHandler(value={IllegalStateException.class, MethodArgumentTypeMismatchException.class})
    @ResponseBody
    public StructuredExceptionWrapper handleMessageNotReadable(Exception exception, HttpServletResponse response) {
        response.setStatus(HttpStatus.NOT_ACCEPTABLE.value());
        return new StructuredExceptionWrapper("Request not readable.\n" + exception.getMessage());
    }

    @ExceptionHandler(value={MissingRequestHeaderException.class})
    @ResponseBody
    public StructuredExceptionWrapper handleMissingRequestHeaderException(MissingRequestHeaderException exception, HttpServletResponse response) {
        StructuredExceptionWrapper output;
        if (AUTHORIZATION_HEADER.equalsIgnoreCase(exception.getHeaderName())) {
            response.setStatus(HttpStatus.UNAUTHORIZED.value());
            output = new StructuredExceptionWrapper("Authorization header is missing in the request.");
        } else {
            output = new StructuredExceptionWrapper(exception.getMessage());
            response.setStatus(HttpStatus.BAD_REQUEST.value());
        }
        return output;
    }
}

