/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.metis.core.rest.config;

import com.rabbitmq.client.Channel;
import eu.europeana.cloud.client.dps.rest.DpsClient;
import eu.europeana.cloud.mcs.driver.DataSetServiceClient;
import eu.europeana.cloud.mcs.driver.FileServiceClient;
import eu.europeana.cloud.mcs.driver.RecordServiceClient;
import eu.europeana.metis.core.dao.DatasetDao;
import eu.europeana.metis.core.dao.DatasetXsltDao;
import eu.europeana.metis.core.dao.DepublishRecordIdDao;
import eu.europeana.metis.core.dao.ScheduledWorkflowDao;
import eu.europeana.metis.core.dao.WorkflowDao;
import eu.europeana.metis.core.dao.WorkflowExecutionDao;
import eu.europeana.metis.core.dao.WorkflowUtils;
import eu.europeana.metis.core.execution.SchedulerExecutor;
import eu.europeana.metis.core.execution.SemaphoresPerPluginManager;
import eu.europeana.metis.core.execution.WorkflowExecutionMonitor;
import eu.europeana.metis.core.execution.WorkflowExecutorManager;
import eu.europeana.metis.core.execution.WorkflowPostProcessor;
import eu.europeana.metis.core.mongo.MorphiaDatastoreProvider;
import eu.europeana.metis.core.rest.RequestLimits;
import eu.europeana.metis.core.rest.config.ConfigurationPropertiesHolder;
import eu.europeana.metis.core.service.Authorizer;
import eu.europeana.metis.core.service.OrchestratorService;
import eu.europeana.metis.core.service.ProxiesService;
import eu.europeana.metis.core.service.ScheduleWorkflowService;
import eu.europeana.metis.core.service.WorkflowExecutionFactory;
import java.io.File;
import java.net.MalformedURLException;
import java.time.Duration;
import java.util.concurrent.TimeUnit;
import javax.annotation.PreDestroy;
import org.apache.commons.lang3.StringUtils;
import org.redisson.Redisson;
import org.redisson.api.RedissonClient;
import org.redisson.config.Config;
import org.redisson.config.SingleServerConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.scheduling.annotation.EnableScheduling;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;

@Configuration
@ComponentScan(basePackages={"eu.europeana.metis.core.rest"})
@EnableScheduling
public class OrchestratorConfig
implements WebMvcConfigurer {
    private static final Logger LOGGER = LoggerFactory.getLogger(OrchestratorConfig.class);
    private final ConfigurationPropertiesHolder propertiesHolder;
    private SchedulerExecutor schedulerExecutor;
    private WorkflowExecutionMonitor workflowExecutionMonitor;
    private RedissonClient redissonClient;

    @Autowired
    public OrchestratorConfig(ConfigurationPropertiesHolder propertiesHolder) {
        this.propertiesHolder = propertiesHolder;
    }

    @Bean
    RedissonClient getRedissonClient() throws MalformedURLException {
        SingleServerConfig singleServerConfig;
        Config config = new Config();
        if (this.propertiesHolder.isRedisEnableSSL()) {
            singleServerConfig = config.useSingleServer().setAddress(String.format("rediss://%s:%s", this.propertiesHolder.getRedisHost(), this.propertiesHolder.getRedisPort()));
            if (this.propertiesHolder.isRedisEnableCustomTruststore()) {
                singleServerConfig.setSslTruststore(new File(this.propertiesHolder.getTruststorePath()).toURI().toURL());
                singleServerConfig.setSslTruststorePassword(this.propertiesHolder.getTruststorePassword());
            }
        } else {
            singleServerConfig = config.useSingleServer().setAddress(String.format("redis://%s:%s", this.propertiesHolder.getRedisHost(), this.propertiesHolder.getRedisPort()));
        }
        if (StringUtils.isNotEmpty((CharSequence)this.propertiesHolder.getRedisPassword())) {
            singleServerConfig.setPassword(this.propertiesHolder.getRedisPassword());
        }
        config.setLockWatchdogTimeout(TimeUnit.SECONDS.toMillis(this.propertiesHolder.getRedissonLockWatchdogTimeoutInSecs()));
        this.redissonClient = Redisson.create((Config)config);
        return this.redissonClient;
    }

    @Bean
    public OrchestratorService getOrchestratorService(WorkflowDao workflowDao, WorkflowExecutionDao workflowExecutionDao, WorkflowUtils workflowUtils, DatasetDao datasetDao, WorkflowExecutionFactory workflowExecutionFactory, WorkflowExecutorManager workflowExecutorManager, Authorizer authorizer, DepublishRecordIdDao depublishRecordIdDao) {
        OrchestratorService orchestratorService = new OrchestratorService(workflowExecutionFactory, workflowDao, workflowExecutionDao, workflowUtils, datasetDao, workflowExecutorManager, this.redissonClient, authorizer, depublishRecordIdDao);
        orchestratorService.setSolrCommitPeriodInMins(this.propertiesHolder.getSolrCommitPeriodInMins());
        return orchestratorService;
    }

    @Bean
    public WorkflowExecutionFactory getWorkflowExecutionFactory(WorkflowExecutionDao workflowExecutionDao, WorkflowUtils workflowUtils, DatasetXsltDao datasetXsltDao, DepublishRecordIdDao depublishRecordIdDao) {
        WorkflowExecutionFactory workflowExecutionFactory = new WorkflowExecutionFactory(datasetXsltDao, depublishRecordIdDao, workflowExecutionDao, workflowUtils);
        workflowExecutionFactory.setValidationExternalProperties(this.propertiesHolder.getValidationExternalProperties());
        workflowExecutionFactory.setValidationInternalProperties(this.propertiesHolder.getValidationInternalProperties());
        workflowExecutionFactory.setMetisUseAlternativeIndexingEnvironment(this.propertiesHolder.isMetisUseAlternativeIndexingEnvironment());
        workflowExecutionFactory.setDefaultSamplingSizeForLinkChecking(this.propertiesHolder.getMetisLinkCheckingDefaultSamplingSize());
        return workflowExecutionFactory;
    }

    @Bean
    public ScheduleWorkflowService getScheduleWorkflowService(ScheduledWorkflowDao scheduledWorkflowDao, WorkflowDao workflowDao, DatasetDao datasetDao, Authorizer authorizer) {
        return new ScheduleWorkflowService(scheduledWorkflowDao, workflowDao, datasetDao, authorizer);
    }

    @Bean
    public ProxiesService getProxiesService(WorkflowExecutionDao workflowExecutionDao, DataSetServiceClient ecloudDataSetServiceClient, RecordServiceClient recordServiceClient, FileServiceClient fileServiceClient, DpsClient dpsClient, Authorizer authorizer) {
        return new ProxiesService(workflowExecutionDao, ecloudDataSetServiceClient, recordServiceClient, fileServiceClient, dpsClient, this.propertiesHolder.getEcloudProvider(), authorizer);
    }

    @Bean
    public WorkflowPostProcessor workflowPostProcessor(DepublishRecordIdDao depublishRecordIdDao, DatasetDao datasetDao, WorkflowExecutionDao workflowExecutionDao, DpsClient dpsClient) {
        return new WorkflowPostProcessor(depublishRecordIdDao, datasetDao, workflowExecutionDao, dpsClient);
    }

    @Bean
    public SemaphoresPerPluginManager semaphoresPerPluginManager() {
        return new SemaphoresPerPluginManager(this.propertiesHolder.getMaxConcurrentThreads());
    }

    @Bean
    public WorkflowExecutorManager getWorkflowExecutorManager(SemaphoresPerPluginManager semaphoresPerPluginManager, WorkflowExecutionDao workflowExecutionDao, WorkflowPostProcessor workflowPostProcessor, @Qualifier(value="rabbitmqPublisherChannel") Channel rabbitmqPublisherChannel, @Qualifier(value="rabbitmqConsumerChannel") Channel rabbitmqConsumerChannel, RedissonClient redissonClient, DpsClient dpsClient) {
        WorkflowExecutorManager workflowExecutorManager = new WorkflowExecutorManager(semaphoresPerPluginManager, workflowExecutionDao, workflowPostProcessor, rabbitmqPublisherChannel, rabbitmqConsumerChannel, redissonClient, dpsClient);
        workflowExecutorManager.setRabbitmqQueueName(this.propertiesHolder.getRabbitmqQueueName());
        workflowExecutorManager.setDpsMonitorCheckIntervalInSecs(this.propertiesHolder.getDpsMonitorCheckIntervalInSecs());
        workflowExecutorManager.setPeriodOfNoProcessedRecordsChangeInMinutes(this.propertiesHolder.getPeriodOfNoProcessedRecordsChangeInMinutes());
        workflowExecutorManager.setEcloudBaseUrl(this.propertiesHolder.getEcloudBaseUrl());
        workflowExecutorManager.setEcloudProvider(this.propertiesHolder.getEcloudProvider());
        workflowExecutorManager.setMetisCoreBaseUrl(this.propertiesHolder.getMetisCoreBaseUrl());
        return workflowExecutorManager;
    }

    @Bean
    public WorkflowExecutionDao getWorkflowExecutionDao(MorphiaDatastoreProvider morphiaDatastoreProvider) {
        WorkflowExecutionDao workflowExecutionDao = new WorkflowExecutionDao(morphiaDatastoreProvider);
        workflowExecutionDao.setWorkflowExecutionsPerRequest(RequestLimits.WORKFLOW_EXECUTIONS_PER_REQUEST.getLimit());
        workflowExecutionDao.setMaxServedExecutionListLength(this.propertiesHolder.getMaxServedExecutionListLength());
        return workflowExecutionDao;
    }

    @Bean
    WorkflowUtils getWorkflowUtils(WorkflowExecutionDao workflowExecutionDao, DepublishRecordIdDao depublishRecordIdDao) {
        return new WorkflowUtils(workflowExecutionDao, depublishRecordIdDao);
    }

    @Bean
    public ScheduledWorkflowDao getScheduledWorkflowDao(MorphiaDatastoreProvider morphiaDatastoreProvider) {
        return new ScheduledWorkflowDao(morphiaDatastoreProvider);
    }

    @Bean
    public WorkflowDao getWorkflowDao(MorphiaDatastoreProvider morphiaDatastoreProvider) {
        return new WorkflowDao(morphiaDatastoreProvider);
    }

    @Bean
    public WorkflowExecutionMonitor getWorkflowExecutionMonitor(WorkflowExecutorManager workflowExecutorManager, WorkflowExecutionDao workflowExecutionDao, RedissonClient redissonClient) {
        Duration failsafeLeniency = Duration.ZERO.plusMillis(this.propertiesHolder.getDpsConnectTimeoutInMillisecs()).plusMillis(this.propertiesHolder.getDpsReadTimeoutInMillisecs()).plusSeconds(this.propertiesHolder.getDpsMonitorCheckIntervalInSecs()).plusSeconds(this.propertiesHolder.getFailsafeMarginOfInactivityInSecs());
        this.workflowExecutionMonitor = new WorkflowExecutionMonitor(workflowExecutorManager, workflowExecutionDao, redissonClient, failsafeLeniency);
        return this.workflowExecutionMonitor;
    }

    @Bean
    public SchedulerExecutor getSchedulingExecutor(OrchestratorService orchestratorService, ScheduleWorkflowService scheduleWorkflowService, RedissonClient redissonClient) {
        this.schedulerExecutor = new SchedulerExecutor(orchestratorService, scheduleWorkflowService, redissonClient);
        return this.schedulerExecutor;
    }

    @Scheduled(fixedDelayString="${periodic.failsafe.check.in.millisecs}")
    public void runFailsafeExecutor() {
        LOGGER.info("Failsafe task started (runs every {} milliseconds).", (Object)this.propertiesHolder.getPeriodicFailsafeCheckInMillisecs());
        this.workflowExecutionMonitor.performFailsafe();
        LOGGER.info("Failsafe task finished.");
    }

    @Scheduled(fixedDelayString="${periodic.scheduler.check.in.millisecs}", initialDelayString="${periodic.scheduler.check.in.millisecs}")
    public void runSchedulingExecutor() {
        LOGGER.info("Scheduler task started (runs every {} milliseconds).", (Object)this.propertiesHolder.getPeriodicSchedulerCheckInMillisecs());
        this.schedulerExecutor.performScheduling();
        LOGGER.info("Scheduler task finished.");
    }

    @PreDestroy
    public void close() {
        if (this.redissonClient != null && !this.redissonClient.isShuttingDown()) {
            this.redissonClient.shutdown();
        }
    }
}

