/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.metis.core.rest.config;

import eu.europeana.cloud.client.dps.rest.DpsClient;
import eu.europeana.cloud.mcs.driver.DataSetServiceClient;
import eu.europeana.cloud.mcs.driver.FileServiceClient;
import eu.europeana.cloud.mcs.driver.RecordServiceClient;
import eu.europeana.metis.core.rest.config.ConfigurationPropertiesHolder;
import javax.annotation.PreDestroy;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;

@Configuration
@ComponentScan(basePackages={"eu.europeana.metis.core.rest"})
public class ECloudConfig
implements WebMvcConfigurer {
    private final ConfigurationPropertiesHolder propertiesHolder;
    private DataSetServiceClient dataSetServiceClient;
    private RecordServiceClient recordServiceClient;
    private FileServiceClient fileServiceClient;
    private DpsClient dpsClient;

    @Autowired
    public ECloudConfig(ConfigurationPropertiesHolder propertiesHolder) {
        this.propertiesHolder = propertiesHolder;
    }

    @Bean
    DataSetServiceClient dataSetServiceClient() {
        this.dataSetServiceClient = new DataSetServiceClient(this.propertiesHolder.getEcloudBaseUrl(), null, this.propertiesHolder.getEcloudUsername(), this.propertiesHolder.getEcloudPassword(), this.propertiesHolder.getDpsConnectTimeoutInMillisecs(), this.propertiesHolder.getDpsReadTimeoutInMillisecs());
        return this.dataSetServiceClient;
    }

    @Bean
    RecordServiceClient recordServiceClient() {
        this.recordServiceClient = new RecordServiceClient(this.propertiesHolder.getEcloudBaseUrl(), null, this.propertiesHolder.getEcloudUsername(), this.propertiesHolder.getEcloudPassword(), this.propertiesHolder.getDpsConnectTimeoutInMillisecs(), this.propertiesHolder.getDpsReadTimeoutInMillisecs());
        return this.recordServiceClient;
    }

    @Bean
    FileServiceClient fileServiceClient() {
        this.fileServiceClient = new FileServiceClient(this.propertiesHolder.getEcloudBaseUrl(), null, this.propertiesHolder.getEcloudUsername(), this.propertiesHolder.getEcloudPassword(), this.propertiesHolder.getDpsConnectTimeoutInMillisecs(), this.propertiesHolder.getDpsReadTimeoutInMillisecs());
        return this.fileServiceClient;
    }

    @Bean
    DpsClient dpsClient() {
        this.dpsClient = new DpsClient(this.propertiesHolder.getEcloudDpsBaseUrl(), this.propertiesHolder.getEcloudUsername(), this.propertiesHolder.getEcloudPassword(), this.propertiesHolder.getDpsConnectTimeoutInMillisecs(), this.propertiesHolder.getDpsReadTimeoutInMillisecs());
        return this.dpsClient;
    }

    @PreDestroy
    public void close() {
        if (this.dataSetServiceClient != null) {
            this.dataSetServiceClient.close();
        }
        if (this.recordServiceClient != null) {
            this.recordServiceClient.close();
        }
        if (this.fileServiceClient != null) {
            this.fileServiceClient.close();
        }
        if (this.dpsClient != null) {
            this.dpsClient.close();
        }
    }
}

