/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.metis.core.rest;

import eu.europeana.metis.authentication.rest.client.AuthenticationClient;
import eu.europeana.metis.authentication.user.MetisUser;
import eu.europeana.metis.core.rest.DepublicationInfoView;
import eu.europeana.metis.core.rest.ResponseListWrapper;
import eu.europeana.metis.core.service.DepublishRecordIdService;
import eu.europeana.metis.core.util.DepublishRecordIdSortField;
import eu.europeana.metis.core.util.SortDirection;
import eu.europeana.metis.core.workflow.WorkflowExecution;
import eu.europeana.metis.exception.GenericMetisException;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RequestPart;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.multipart.MultipartFile;

@Controller
public class DepublishRecordIdController {
    private static final Logger LOGGER = LoggerFactory.getLogger(DepublishRecordIdController.class);
    private static final Pattern CRLF_PATTERN = Pattern.compile("[\r\n]");
    private final DepublishRecordIdService depublishRecordIdService;
    private final AuthenticationClient authenticationClient;

    @Autowired
    public DepublishRecordIdController(DepublishRecordIdService depublishRecordIdService, AuthenticationClient authenticationClient) {
        this.depublishRecordIdService = depublishRecordIdService;
        this.authenticationClient = authenticationClient;
    }

    @PostMapping(value={"/depublish/record_ids/{datasetId}"}, consumes={"text/plain"})
    @ResponseStatus(value=HttpStatus.CREATED)
    public void createRecordIdsToBeDepublished(@RequestHeader(value="Authorization") String authorization, @PathVariable(value="datasetId") String datasetId, @RequestBody String recordIdsInSeparateLines) throws GenericMetisException {
        MetisUser metisUser = this.authenticationClient.getUserByAccessTokenInHeader(authorization);
        int added = this.depublishRecordIdService.addRecordIdsToBeDepublished(metisUser, datasetId, recordIdsInSeparateLines);
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("{} Depublish record ids added to dataset with datasetId: {}", (Object)added, (Object)CRLF_PATTERN.matcher(datasetId).replaceAll(""));
        }
    }

    @PostMapping(value={"/depublish/record_ids/{datasetId}"}, consumes={"multipart/form-data"})
    @ResponseStatus(value=HttpStatus.CREATED)
    public void createRecordIdsToBeDepublished(@RequestHeader(value="Authorization") String authorization, @PathVariable(value="datasetId") String datasetId, @RequestPart(value="depublicationFile") MultipartFile recordIdsFile) throws GenericMetisException, IOException {
        this.createRecordIdsToBeDepublished(authorization, datasetId, new String(recordIdsFile.getBytes(), StandardCharsets.UTF_8));
    }

    @DeleteMapping(value={"/depublish/record_ids/{datasetId}"}, consumes={"text/plain"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void deletePendingRecordIds(@RequestHeader(value="Authorization") String authorization, @PathVariable(value="datasetId") String datasetId, @RequestBody String recordIdsInSeparateLines) throws GenericMetisException {
        MetisUser metisUser = this.authenticationClient.getUserByAccessTokenInHeader(authorization);
        Long removedRecordIds = this.depublishRecordIdService.deletePendingRecordIds(metisUser, datasetId, recordIdsInSeparateLines);
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("{} Depublish record ids removed from database with datasetId: {}", (Object)removedRecordIds, (Object)CRLF_PATTERN.matcher(datasetId).replaceAll(""));
        }
    }

    @GetMapping(value={"/depublish/record_ids/{datasetId}"}, produces={"application/json", "application/xml"})
    @ResponseStatus(value=HttpStatus.OK)
    @ResponseBody
    public DepublicationInfoView getDepublishRecordIds(@RequestHeader(value="Authorization") String authorization, @PathVariable(value="datasetId") String datasetId, @RequestParam(value="page", defaultValue="0") int page, @RequestParam(value="sortField", required=false) DepublishRecordIdSortField sortField, @RequestParam(value="sortAscending", defaultValue="true") boolean sortAscending, @RequestParam(value="searchQuery", required=false) String searchQuery) throws GenericMetisException {
        MetisUser metisUser = this.authenticationClient.getUserByAccessTokenInHeader(authorization);
        ResponseListWrapper recordIds = this.depublishRecordIdService.getDepublishRecordIds(metisUser, datasetId, page, sortField == null ? DepublishRecordIdSortField.RECORD_ID : sortField, sortAscending ? SortDirection.ASCENDING : SortDirection.DESCENDING, searchQuery);
        boolean canDepublish = this.depublishRecordIdService.canTriggerDepublication(metisUser, datasetId);
        return new DepublicationInfoView(recordIds, canDepublish);
    }

    @PostMapping(value={"/depublish/execute/{datasetId}"}, produces={"application/json", "application/xml"})
    @ResponseStatus(value=HttpStatus.CREATED)
    @ResponseBody
    public WorkflowExecution addDepublishWorkflowInQueueOfWorkflowExecutions(@RequestHeader(value="Authorization") String authorization, @PathVariable(value="datasetId") String datasetId, @RequestParam(value="datasetDepublish", defaultValue="true") boolean datasetDepublish, @RequestParam(value="priority", defaultValue="0") int priority, @RequestBody(required=false) String recordIdsInSeparateLines) throws GenericMetisException {
        MetisUser metisUser = this.authenticationClient.getUserByAccessTokenInHeader(authorization);
        return this.depublishRecordIdService.createAndAddInQueueDepublishWorkflowExecution(metisUser, datasetId, datasetDepublish, priority, recordIdsInSeparateLines);
    }
}

