/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.metis.core.rest.controller;

import eu.europeana.metis.authentication.rest.client.AuthenticationClient;
import eu.europeana.metis.authentication.user.MetisUserView;
import eu.europeana.metis.core.rest.ResponseListWrapper;
import eu.europeana.metis.core.service.ScheduleWorkflowService;
import eu.europeana.metis.core.workflow.ScheduleFrequence;
import eu.europeana.metis.core.workflow.ScheduledWorkflow;
import eu.europeana.metis.exception.BadContentException;
import eu.europeana.metis.exception.GenericMetisException;
import eu.europeana.metis.utils.CommonStringValues;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class ScheduleWorkflowController {
    private static final Logger LOGGER = LoggerFactory.getLogger(ScheduleWorkflowController.class);
    private final ScheduleWorkflowService scheduleWorkflowService;
    private final AuthenticationClient authenticationClient;

    public ScheduleWorkflowController(ScheduleWorkflowService scheduleWorkflowService, AuthenticationClient authenticationClient) {
        this.scheduleWorkflowService = scheduleWorkflowService;
        this.authenticationClient = authenticationClient;
    }

    @PostMapping(value={"/orchestrator/workflows/schedule"}, consumes={"application/json", "application/xml"}, produces={"application/json", "application/xml"})
    @ResponseStatus(value=HttpStatus.CREATED)
    public void scheduleWorkflowExecution(@RequestHeader(value="Authorization") String authorization, @RequestBody ScheduledWorkflow scheduledWorkflow) throws GenericMetisException {
        MetisUserView metisUserView = this.authenticationClient.getUserByAccessTokenInHeader(authorization);
        this.scheduleWorkflowService.scheduleWorkflow(metisUserView, scheduledWorkflow);
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("ScheduledWorkflowExecution for datasetId '{}', pointerDate at '{}', scheduled '{}'", new Object[]{CommonStringValues.CRLF_PATTERN.matcher(scheduledWorkflow.getDatasetId()), scheduledWorkflow.getPointerDate(), CommonStringValues.CRLF_PATTERN.matcher(scheduledWorkflow.getScheduleFrequence().name()).replaceAll("")});
        }
    }

    @GetMapping(value={"/orchestrator/workflows/schedule/{datasetId}"}, produces={"application/json", "application/xml"})
    @ResponseStatus(value=HttpStatus.OK)
    public ScheduledWorkflow getScheduledWorkflow(@RequestHeader(value="Authorization") String authorization, @PathVariable(value="datasetId") String datasetId) throws GenericMetisException {
        MetisUserView metisUserView = this.authenticationClient.getUserByAccessTokenInHeader(authorization);
        ScheduledWorkflow scheduledWorkflow = this.scheduleWorkflowService.getScheduledWorkflowByDatasetId(metisUserView, datasetId);
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("ScheduledWorkflow with with datasetId '{}' found", (Object)datasetId.replaceAll("[\r\n\t]", ""));
        }
        return scheduledWorkflow;
    }

    @GetMapping(value={"/orchestrator/workflows/schedule"}, produces={"application/json", "application/xml"})
    @ResponseStatus(value=HttpStatus.OK)
    public ResponseListWrapper<ScheduledWorkflow> getAllScheduledWorkflows(@RequestHeader(value="Authorization") String authorization, @RequestParam(value="nextPage", required=false, defaultValue="0") int nextPage) throws GenericMetisException {
        if (nextPage < 0) {
            throw new BadContentException("nextPage cannot be a negative number");
        }
        ResponseListWrapper responseListWrapper = new ResponseListWrapper();
        MetisUserView metisUserView = this.authenticationClient.getUserByAccessTokenInHeader(authorization);
        responseListWrapper.setResultsAndLastPage(this.scheduleWorkflowService.getAllScheduledWorkflows(metisUserView, ScheduleFrequence.NULL, nextPage), this.scheduleWorkflowService.getScheduledWorkflowsPerRequest(), nextPage);
        LOGGER.info("Batch of: {} scheduledWorkflows returned, using batch nextPage: {}", (Object)responseListWrapper.getListSize(), (Object)nextPage);
        return responseListWrapper;
    }

    @PutMapping(value={"/orchestrator/workflows/schedule"}, produces={"application/json", "application/xml"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void updateScheduledWorkflow(@RequestHeader(value="Authorization") String authorization, @RequestBody ScheduledWorkflow scheduledWorkflow) throws GenericMetisException {
        MetisUserView metisUserView = this.authenticationClient.getUserByAccessTokenInHeader(authorization);
        this.scheduleWorkflowService.updateScheduledWorkflow(metisUserView, scheduledWorkflow);
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("ScheduledWorkflow with with datasetId '{}' updated", (Object)CommonStringValues.CRLF_PATTERN.matcher(scheduledWorkflow.getDatasetId()).replaceAll(""));
        }
    }

    @DeleteMapping(value={"/orchestrator/workflows/schedule/{datasetId}"}, produces={"application/json", "application/xml"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void deleteScheduledWorkflowExecution(@RequestHeader(value="Authorization") String authorization, @PathVariable(value="datasetId") String datasetId) throws GenericMetisException {
        MetisUserView metisUserView = this.authenticationClient.getUserByAccessTokenInHeader(authorization);
        this.scheduleWorkflowService.deleteScheduledWorkflow(metisUserView, datasetId);
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("ScheduledWorkflowExecution for datasetId '{}' deleted", (Object)datasetId.replaceAll("[\r\n\t]", ""));
        }
    }
}

