/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.metis.core.rest.controller;

import eu.europeana.cloud.common.model.dps.SubTaskInfo;
import eu.europeana.cloud.common.model.dps.TaskErrorsInfo;
import eu.europeana.metis.authentication.rest.client.AuthenticationClient;
import eu.europeana.metis.authentication.user.MetisUserView;
import eu.europeana.metis.core.rest.ListOfIds;
import eu.europeana.metis.core.rest.Record;
import eu.europeana.metis.core.rest.RecordsResponse;
import eu.europeana.metis.core.rest.stats.NodePathStatistics;
import eu.europeana.metis.core.rest.stats.RecordStatistics;
import eu.europeana.metis.core.service.ProxiesService;
import eu.europeana.metis.core.workflow.plugins.ExecutablePluginType;
import eu.europeana.metis.exception.GenericMetisException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class ProxiesController {
    private static final Logger LOGGER = LoggerFactory.getLogger(ProxiesController.class);
    private static final int NUMBER_OF_RECORDS = 5;
    private final ProxiesService proxiesService;
    private final AuthenticationClient authenticationClient;

    @Autowired
    public ProxiesController(ProxiesService proxiesService, AuthenticationClient authenticationClient) {
        this.proxiesService = proxiesService;
        this.authenticationClient = authenticationClient;
    }

    @GetMapping(value={"/orchestrator/proxies/{topologyName}/task/{externalTaskId}/logs"}, produces={"application/json", "application/xml"})
    @ResponseStatus(value=HttpStatus.OK)
    public List<SubTaskInfo> getExternalTaskLogs(@RequestHeader(value="Authorization") String authorization, @PathVariable(value="topologyName") String topologyName, @PathVariable(value="externalTaskId") long externalTaskId, @RequestParam(value="from") int from, @RequestParam(value="to") int to) throws GenericMetisException {
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("Requesting proxy call task logs for topologyName: {}, externalTaskId: {}, from: {}, to: {}", new Object[]{topologyName.replaceAll("[\r\n\t]", ""), externalTaskId, from, to});
        }
        MetisUserView metisUserView = this.authenticationClient.getUserByAccessTokenInHeader(authorization);
        return this.proxiesService.getExternalTaskLogs(metisUserView, topologyName, externalTaskId, from, to);
    }

    @GetMapping(value={"/orchestrator/proxies/{topologyName}/task/{externalTaskId}/report/exists"}, produces={"application/json", "application/xml"})
    @ResponseStatus(value=HttpStatus.OK)
    public Map<String, Boolean> existsExternalTaskReport(@RequestHeader(value="Authorization") String authorization, @PathVariable(value="topologyName") String topologyName, @PathVariable(value="externalTaskId") long externalTaskId) throws GenericMetisException {
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("Requesting proxy call to check if task report exists for topologyName: {}, externalTaskId: {}", (Object)topologyName.replaceAll("[\r\n\t]", ""), (Object)externalTaskId);
        }
        MetisUserView metisUserView = this.authenticationClient.getUserByAccessTokenInHeader(authorization);
        return Collections.singletonMap("existsExternalTaskReport", this.proxiesService.existsExternalTaskReport(metisUserView, topologyName, externalTaskId));
    }

    @GetMapping(value={"/orchestrator/proxies/{topologyName}/task/{externalTaskId}/report"}, produces={"application/json", "application/xml"})
    @ResponseStatus(value=HttpStatus.OK)
    public TaskErrorsInfo getExternalTaskReport(@RequestHeader(value="Authorization") String authorization, @PathVariable(value="topologyName") String topologyName, @PathVariable(value="externalTaskId") long externalTaskId, @RequestParam(value="idsPerError") int idsPerError) throws GenericMetisException {
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("Requesting proxy call task reports for topologyName: {}, externalTaskId: {}", (Object)topologyName.replaceAll("[\r\n\t]", ""), (Object)externalTaskId);
        }
        MetisUserView metisUserView = this.authenticationClient.getUserByAccessTokenInHeader(authorization);
        return this.proxiesService.getExternalTaskReport(metisUserView, topologyName, externalTaskId, idsPerError);
    }

    @GetMapping(value={"/orchestrator/proxies/{topologyName}/task/{externalTaskId}/statistics"}, produces={"application/json", "application/xml"})
    @ResponseStatus(value=HttpStatus.OK)
    public RecordStatistics getExternalTaskStatistics(@RequestHeader(value="Authorization") String authorization, @PathVariable(value="topologyName") String topologyName, @PathVariable(value="externalTaskId") long externalTaskId) throws GenericMetisException {
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("Requesting proxy call task statistics for topologyName: {}, externalTaskId: {}", (Object)topologyName.replaceAll("[\r\n\t]", ""), (Object)externalTaskId);
        }
        MetisUserView metisUserView = this.authenticationClient.getUserByAccessTokenInHeader(authorization);
        return this.proxiesService.getExternalTaskStatistics(metisUserView, topologyName, externalTaskId);
    }

    @GetMapping(value={"/orchestrator/proxies/{topologyName}/task/{externalTaskId}/nodestatistics"}, produces={"application/json", "application/xml"})
    @ResponseStatus(value=HttpStatus.OK)
    public NodePathStatistics getAdditionalNodeStatistics(@RequestHeader(value="Authorization") String authorization, @PathVariable(value="topologyName") String topologyName, @PathVariable(value="externalTaskId") long externalTaskId, @RequestParam(value="nodePath") String nodePath) throws GenericMetisException {
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("Requesting proxy call additional node statistics for topologyName: {}, externalTaskId: {}", (Object)topologyName.replaceAll("[\r\n\t]", ""), (Object)externalTaskId);
        }
        MetisUserView metisUserView = this.authenticationClient.getUserByAccessTokenInHeader(authorization);
        return this.proxiesService.getAdditionalNodeStatistics(metisUserView, topologyName, externalTaskId, nodePath);
    }

    @GetMapping(value={"/orchestrator/proxies/records"}, produces={"application/json", "application/xml"})
    @ResponseStatus(value=HttpStatus.OK)
    public RecordsResponse getListOfFileContentsFromPluginExecution(@RequestHeader(value="Authorization") String authorization, @RequestParam(value="workflowExecutionId") String workflowExecutionId, @RequestParam(value="pluginType") ExecutablePluginType pluginType, @RequestParam(value="nextPage", required=false) String nextPage) throws GenericMetisException {
        MetisUserView metisUserView = this.authenticationClient.getUserByAccessTokenInHeader(authorization);
        return this.proxiesService.getListOfFileContentsFromPluginExecution(metisUserView, workflowExecutionId, pluginType, StringUtils.isEmpty((CharSequence)nextPage) ? null : nextPage, 5);
    }

    @PostMapping(value={"/orchestrator/proxies/recordsbyids"}, consumes={"application/json", "application/xml"}, produces={"application/json", "application/xml"})
    @ResponseStatus(value=HttpStatus.OK)
    public RecordsResponse getListOfFileContentsFromPluginExecution(@RequestHeader(value="Authorization") String authorization, @RequestParam(value="workflowExecutionId") String workflowExecutionId, @RequestParam(value="pluginType") ExecutablePluginType pluginType, @RequestBody ListOfIds ecloudIds) throws GenericMetisException {
        MetisUserView metisUserView = this.authenticationClient.getUserByAccessTokenInHeader(authorization);
        return this.proxiesService.getListOfFileContentsFromPluginExecution(metisUserView, workflowExecutionId, pluginType, ecloudIds);
    }

    @PostMapping(value={"/orchestrator/proxies/recordsearchbyid"}, produces={"application/json", "application/xml"})
    @ResponseStatus(value=HttpStatus.OK)
    public Record searchRecordByIdFromPluginExecution(@RequestHeader(value="Authorization") String authorization, @RequestParam(value="workflowExecutionId") String workflowExecutionId, @RequestParam(value="pluginType") ExecutablePluginType pluginType, @RequestParam(value="idToSearch") String idToSearch) throws GenericMetisException {
        MetisUserView metisUserView = this.authenticationClient.getUserByAccessTokenInHeader(authorization);
        return this.proxiesService.searchRecordByIdFromPluginExecution(metisUserView, workflowExecutionId, pluginType, idToSearch);
    }

    @PostMapping(value={"/orchestrator/proxies/recordfrompredecessorplugin"}, consumes={"application/json", "application/xml"}, produces={"application/json", "application/xml"})
    @ResponseStatus(value=HttpStatus.OK)
    public RecordsResponse getListOfFileContentsFromPredecessorOfPluginExecution(@RequestHeader(value="Authorization") String authorization, @RequestParam(value="workflowExecutionId") String workflowExecutionId, @RequestParam(value="pluginType") ExecutablePluginType pluginType, @RequestBody ListOfIds ecloudIds) throws GenericMetisException {
        MetisUserView metisUserView = this.authenticationClient.getUserByAccessTokenInHeader(authorization);
        return this.proxiesService.getListOfFileContentsFromPredecessorPluginExecution(metisUserView, workflowExecutionId, pluginType, ecloudIds);
    }
}

