/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.metis.core.rest.config;

import eu.europeana.metis.core.rest.config.properties.MetisCoreConfigurationProperties;
import java.nio.charset.StandardCharsets;
import java.util.List;
import org.springframework.context.annotation.Configuration;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.converter.StringHttpMessageConverter;
import org.springframework.http.converter.json.MappingJackson2HttpMessageConverter;
import org.springframework.http.converter.xml.MappingJackson2XmlHttpMessageConverter;
import org.springframework.web.servlet.config.annotation.CorsRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;

@Configuration
public class WebMvcConfig
implements WebMvcConfigurer {
    private final MetisCoreConfigurationProperties metisCoreConfigurationProperties;

    public WebMvcConfig(MetisCoreConfigurationProperties metisCoreConfigurationProperties) {
        this.metisCoreConfigurationProperties = metisCoreConfigurationProperties;
    }

    public void addCorsMappings(CorsRegistry registry) {
        registry.addMapping("/**").allowedMethods(new String[]{"GET", "HEAD", "POST", "PUT", "DELETE", "OPTIONS"}).allowedOrigins(this.metisCoreConfigurationProperties.getAllowedCorsHosts());
    }

    public void configureMessageConverters(List<HttpMessageConverter<?>> converters) {
        converters.add((HttpMessageConverter<?>)new MappingJackson2HttpMessageConverter());
        converters.add((HttpMessageConverter<?>)new MappingJackson2XmlHttpMessageConverter());
        converters.add((HttpMessageConverter<?>)new StringHttpMessageConverter(StandardCharsets.UTF_8));
    }
}

