/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.metis.core.rest.config;

import com.rabbitmq.client.Channel;
import com.rabbitmq.client.Connection;
import com.rabbitmq.client.ConnectionFactory;
import com.rabbitmq.client.ExceptionHandler;
import com.rabbitmq.client.impl.ForgivingExceptionHandler;
import eu.europeana.metis.core.execution.QueueConsumer;
import eu.europeana.metis.core.execution.WorkflowExecutionMonitor;
import eu.europeana.metis.core.execution.WorkflowExecutionSettings;
import eu.europeana.metis.core.execution.WorkflowExecutorManager;
import eu.europeana.metis.exception.GenericMetisException;
import jakarta.annotation.PreDestroy;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeoutException;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManagerFactory;
import metis.common.config.properties.TruststoreConfigurationProperties;
import metis.common.config.properties.rabbitmq.RabbitmqConfigurationProperties;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.scheduling.annotation.EnableScheduling;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;

@Configuration
@EnableConfigurationProperties(value={RabbitmqConfigurationProperties.class, TruststoreConfigurationProperties.class})
@ComponentScan(basePackages={"eu.europeana.metis.core.rest.controller"})
@EnableScheduling
public class QueueConfig
implements WebMvcConfigurer {
    private static final Logger LOGGER = LoggerFactory.getLogger(QueueConfig.class);
    private QueueConsumer queueConsumer;
    private Connection connection;
    private Channel publisherChannel;
    private Channel consumerChannel;

    @Bean
    Connection getConnection(RabbitmqConfigurationProperties rabbitmqConfigurationProperties, TruststoreConfigurationProperties truststoreConfigurationProperties) throws KeyManagementException, NoSuchAlgorithmException, IOException, TimeoutException, KeyStoreException, CertificateException {
        ConnectionFactory connectionFactory = new ConnectionFactory();
        connectionFactory.setHost(rabbitmqConfigurationProperties.getHost());
        connectionFactory.setPort(rabbitmqConfigurationProperties.getPort());
        connectionFactory.setVirtualHost(StringUtils.isNotBlank((CharSequence)rabbitmqConfigurationProperties.getVirtualHost()) ? rabbitmqConfigurationProperties.getVirtualHost() : "/");
        connectionFactory.setUsername(rabbitmqConfigurationProperties.getUsername());
        connectionFactory.setPassword(rabbitmqConfigurationProperties.getPassword());
        connectionFactory.setAutomaticRecoveryEnabled(true);
        if (rabbitmqConfigurationProperties.isEnableSsl()) {
            if (rabbitmqConfigurationProperties.isEnableCustomTruststore()) {
                KeyStore keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
                Path trustStoreFile = Paths.get(truststoreConfigurationProperties.getPath(), new String[0]);
                try (InputStream inputStream = Files.newInputStream(trustStoreFile, new OpenOption[0]);){
                    keyStore.load(inputStream, truststoreConfigurationProperties.getPassword().toCharArray());
                }
                TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
                trustManagerFactory.init(keyStore);
                SSLContext sslContext = SSLContext.getInstance("TLS");
                sslContext.init(null, trustManagerFactory.getTrustManagers(), null);
                connectionFactory.useSslProtocol(sslContext);
                LOGGER.info("RabbitMQ enabled SSL WITH certificate verification using custom Truststore");
            } else {
                connectionFactory.useSslProtocol();
                LOGGER.info("RabbitMQ enabled SSL WITHOUT certificate verification");
            }
        }
        connectionFactory.setExceptionHandler((ExceptionHandler)new ForgivingExceptionHandler());
        this.connection = connectionFactory.newConnection();
        return this.connection;
    }

    @Bean(name={"rabbitmqPublisherChannel"})
    Channel getRabbitmqPublisherChannel(Connection connection, RabbitmqConfigurationProperties rabbitmqConfigurationProperties) throws IOException {
        this.publisherChannel = connection.createChannel();
        this.setupChannelProperties(this.publisherChannel, rabbitmqConfigurationProperties);
        return this.publisherChannel;
    }

    @Bean(name={"rabbitmqConsumerChannel"})
    Channel getRabbitmqConsumerChannel(Connection connection, RabbitmqConfigurationProperties rabbitmqConfigurationProperties) throws IOException {
        this.consumerChannel = connection.createChannel();
        this.setupChannelProperties(this.consumerChannel, rabbitmqConfigurationProperties);
        return this.consumerChannel;
    }

    private void setupChannelProperties(Channel channel, RabbitmqConfigurationProperties rabbitmqConfigurationProperties) throws IOException {
        ConcurrentHashMap<String, Integer> args = new ConcurrentHashMap<String, Integer>();
        args.put("x-max-priority", rabbitmqConfigurationProperties.getHighestPriority());
        channel.queueDeclare(rabbitmqConfigurationProperties.getQueueName(), false, false, false, args);
    }

    @Bean
    public QueueConsumer getQueueConsumer(RabbitmqConfigurationProperties rabbitmqConfigurationProperties, WorkflowExecutorManager workflowExecutionManager, WorkflowExecutionMonitor workflowExecutionMonitor, @Qualifier(value="rabbitmqConsumerChannel") Channel rabbitmqConsumerChannel) throws IOException {
        this.queueConsumer = new QueueConsumer(rabbitmqConsumerChannel, rabbitmqConfigurationProperties.getQueueName(), (WorkflowExecutionSettings)workflowExecutionManager, workflowExecutionManager, workflowExecutionMonitor);
        return this.queueConsumer;
    }

    @Scheduled(fixedDelayString="${metis-core.pollingTimeoutForCleaningCompletionServiceInMilliseconds}", initialDelayString="${metis-core.pollingTimeoutForCleaningCompletionServiceInMilliseconds}")
    public void runQueueConsumerCleanup() throws InterruptedException {
        this.queueConsumer.checkAndCleanCompletionService();
        LOGGER.debug("Queue consumer cleanup finished.");
    }

    @PreDestroy
    public void close() throws GenericMetisException {
        try {
            if (this.publisherChannel != null && this.publisherChannel.isOpen()) {
                this.publisherChannel.close();
            }
            if (this.consumerChannel != null && this.consumerChannel.isOpen()) {
                this.consumerChannel.close();
            }
            if (this.connection != null && this.connection.isOpen()) {
                this.connection.close();
            }
            if (this.queueConsumer != null) {
                this.queueConsumer.close();
            }
        }
        catch (IOException | TimeoutException e) {
            throw new GenericMetisException("Could not shutdown resources properly.", (Throwable)e);
        }
    }
}

