/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.metis.core.rest.config;

import eu.europeana.cloud.client.dps.rest.DpsClient;
import eu.europeana.cloud.client.uis.rest.UISClient;
import eu.europeana.cloud.mcs.driver.DataSetServiceClient;
import eu.europeana.cloud.mcs.driver.FileServiceClient;
import eu.europeana.cloud.mcs.driver.RecordServiceClient;
import eu.europeana.metis.core.rest.config.properties.MetisCoreConfigurationProperties;
import jakarta.annotation.PreDestroy;
import metis.common.config.properties.ecloud.EcloudConfigurationProperties;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;

@Configuration
@EnableConfigurationProperties(value={MetisCoreConfigurationProperties.class, EcloudConfigurationProperties.class})
@ComponentScan(basePackages={"eu.europeana.metis.core.rest.controller"})
public class ECloudConfig
implements WebMvcConfigurer {
    private DataSetServiceClient dataSetServiceClient;
    private RecordServiceClient recordServiceClient;
    private FileServiceClient fileServiceClient;
    private DpsClient dpsClient;
    private UISClient uisClient;

    @Bean
    DataSetServiceClient dataSetServiceClient(MetisCoreConfigurationProperties metisCoreConfigurationProperties, EcloudConfigurationProperties ecloudConfigurationProperties) {
        this.dataSetServiceClient = new DataSetServiceClient(ecloudConfigurationProperties.getBaseUrl(), ecloudConfigurationProperties.getUsername(), ecloudConfigurationProperties.getPassword(), metisCoreConfigurationProperties.getDpsConnectTimeoutInMilliseconds(), metisCoreConfigurationProperties.getDpsReadTimeoutInMilliseconds());
        return this.dataSetServiceClient;
    }

    @Bean
    RecordServiceClient recordServiceClient(MetisCoreConfigurationProperties metisCoreConfigurationProperties, EcloudConfigurationProperties ecloudConfigurationProperties) {
        this.recordServiceClient = new RecordServiceClient(ecloudConfigurationProperties.getBaseUrl(), ecloudConfigurationProperties.getUsername(), ecloudConfigurationProperties.getPassword(), metisCoreConfigurationProperties.getDpsConnectTimeoutInMilliseconds(), metisCoreConfigurationProperties.getDpsReadTimeoutInMilliseconds());
        return this.recordServiceClient;
    }

    @Bean
    FileServiceClient fileServiceClient(MetisCoreConfigurationProperties metisCoreConfigurationProperties, EcloudConfigurationProperties ecloudConfigurationProperties) {
        this.fileServiceClient = new FileServiceClient(ecloudConfigurationProperties.getBaseUrl(), ecloudConfigurationProperties.getUsername(), ecloudConfigurationProperties.getPassword(), metisCoreConfigurationProperties.getDpsConnectTimeoutInMilliseconds(), metisCoreConfigurationProperties.getDpsReadTimeoutInMilliseconds());
        return this.fileServiceClient;
    }

    @Bean
    DpsClient dpsClient(MetisCoreConfigurationProperties metisCoreConfigurationProperties, EcloudConfigurationProperties ecloudConfigurationProperties) {
        this.dpsClient = new DpsClient(ecloudConfigurationProperties.getDpsBaseUrl(), ecloudConfigurationProperties.getUsername(), ecloudConfigurationProperties.getPassword(), metisCoreConfigurationProperties.getDpsConnectTimeoutInMilliseconds(), metisCoreConfigurationProperties.getDpsReadTimeoutInMilliseconds());
        return this.dpsClient;
    }

    @Bean
    UISClient uisClient(MetisCoreConfigurationProperties metisCoreConfigurationProperties, EcloudConfigurationProperties ecloudConfigurationProperties) {
        this.uisClient = new UISClient(ecloudConfigurationProperties.getBaseUrl(), ecloudConfigurationProperties.getUsername(), ecloudConfigurationProperties.getPassword(), metisCoreConfigurationProperties.getDpsConnectTimeoutInMilliseconds(), metisCoreConfigurationProperties.getDpsReadTimeoutInMilliseconds());
        return this.uisClient;
    }

    @PreDestroy
    public void close() {
        if (this.dataSetServiceClient != null) {
            this.dataSetServiceClient.close();
        }
        if (this.recordServiceClient != null) {
            this.recordServiceClient.close();
        }
        if (this.fileServiceClient != null) {
            this.fileServiceClient.close();
        }
        if (this.dpsClient != null) {
            this.dpsClient.close();
        }
        if (this.uisClient != null) {
            this.uisClient.close();
        }
    }
}

