/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.metis.core.rest.config;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.mongodb.client.MongoClient;
import eu.europeana.cloud.mcs.driver.DataSetServiceClient;
import eu.europeana.metis.authentication.rest.client.AuthenticationClient;
import eu.europeana.metis.core.dao.DatasetDao;
import eu.europeana.metis.core.dao.DatasetXsltDao;
import eu.europeana.metis.core.dao.DepublishRecordIdDao;
import eu.europeana.metis.core.dao.ScheduledWorkflowDao;
import eu.europeana.metis.core.dao.WorkflowDao;
import eu.europeana.metis.core.dao.WorkflowExecutionDao;
import eu.europeana.metis.core.mongo.MorphiaDatastoreProvider;
import eu.europeana.metis.core.mongo.MorphiaDatastoreProviderImpl;
import eu.europeana.metis.core.rest.RequestLimits;
import eu.europeana.metis.core.rest.config.properties.MetisCoreConfigurationProperties;
import eu.europeana.metis.core.service.Authorizer;
import eu.europeana.metis.core.service.DatasetService;
import eu.europeana.metis.core.service.DepublishRecordIdService;
import eu.europeana.metis.core.service.OrchestratorService;
import eu.europeana.metis.mongo.connection.MongoClientProvider;
import eu.europeana.metis.mongo.connection.MongoProperties;
import eu.europeana.metis.mongo.utils.CustomObjectMapper;
import eu.europeana.metis.utils.CustomTruststoreAppender;
import eu.europeana.metis.utils.apm.ElasticAPMConfiguration;
import jakarta.annotation.PreDestroy;
import java.io.IOException;
import java.lang.invoke.MethodHandles;
import metis.common.config.properties.TruststoreConfigurationProperties;
import metis.common.config.properties.ecloud.EcloudConfigurationProperties;
import metis.common.config.properties.mongo.MongoConfigurationProperties;
import org.apache.commons.lang3.StringUtils;
import org.redisson.api.RedissonClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.io.Resource;
import org.springframework.web.multipart.support.StandardServletMultipartResolver;
import org.springframework.web.servlet.View;
import org.springframework.web.servlet.ViewResolver;
import org.springframework.web.servlet.view.BeanNameViewResolver;
import org.springframework.web.servlet.view.json.MappingJackson2JsonView;

/*
 * Exception performing whole class analysis ignored.
 */
@Configuration
@EnableConfigurationProperties(value={ElasticAPMConfiguration.class, TruststoreConfigurationProperties.class, MongoConfigurationProperties.class, MetisCoreConfigurationProperties.class, EcloudConfigurationProperties.class})
@ComponentScan(basePackages={"eu.europeana.metis.core.rest.controller"})
public class ApplicationConfiguration {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final MongoClient mongoClient;
    @Value(value="classpath:default_transformation.xslt")
    private Resource defaultTransformation;

    @Autowired
    public ApplicationConfiguration(TruststoreConfigurationProperties truststoreConfigurationProperties, MongoConfigurationProperties mongoConfigurationProperties) throws CustomTruststoreAppender.TrustStoreConfigurationException {
        ApplicationConfiguration.initializeTruststore((TruststoreConfigurationProperties)truststoreConfigurationProperties);
        this.mongoClient = ApplicationConfiguration.getMongoClient((MongoConfigurationProperties)mongoConfigurationProperties);
    }

    static void initializeTruststore(TruststoreConfigurationProperties truststoreConfigurationProperties) throws CustomTruststoreAppender.TrustStoreConfigurationException {
        if (StringUtils.isNotEmpty((CharSequence)truststoreConfigurationProperties.getPath()) && StringUtils.isNotEmpty((CharSequence)truststoreConfigurationProperties.getPassword())) {
            CustomTruststoreAppender.appendCustomTruststoreToDefault((String)truststoreConfigurationProperties.getPath(), (String)truststoreConfigurationProperties.getPassword());
            LOGGER.info("Custom truststore appended to default truststore");
        }
    }

    public static MongoClient getMongoClient(MongoConfigurationProperties mongoConfigurationProperties) {
        MongoProperties mongoProperties = new MongoProperties(IllegalArgumentException::new);
        mongoProperties.setAllProperties(mongoConfigurationProperties.getHosts(), mongoConfigurationProperties.getPorts(), mongoConfigurationProperties.getAuthenticationDatabase(), mongoConfigurationProperties.getUsername(), mongoConfigurationProperties.getPassword(), mongoConfigurationProperties.isEnableSsl(), MongoProperties.ReadPreferenceValue.PRIMARY_PREFERRED, mongoConfigurationProperties.getApplicationName());
        return new MongoClientProvider(mongoProperties).createMongoClient();
    }

    @Bean(name={"multipartResolver"})
    public StandardServletMultipartResolver getMultipartResolver() {
        return new StandardServletMultipartResolver();
    }

    @Bean
    AuthenticationClient getAuthenticationClient(MetisCoreConfigurationProperties metisCoreConfigurationProperties) {
        return new AuthenticationClient(metisCoreConfigurationProperties.getAuthenticationBaseUrl());
    }

    @Bean
    MorphiaDatastoreProvider getMorphiaDatastoreProvider(MongoConfigurationProperties mongoConfigurationProperties) throws IOException {
        return new MorphiaDatastoreProviderImpl(this.mongoClient, mongoConfigurationProperties.getDatabase(), () -> ((Resource)this.defaultTransformation).getInputStream());
    }

    @Bean
    Authorizer geAuthorizer(DatasetDao datasetDao) {
        return new Authorizer(datasetDao);
    }

    @Bean
    public DatasetDao getDatasetDao(MorphiaDatastoreProvider morphiaDatastoreProvider, DataSetServiceClient ecloudDataSetServiceClient, EcloudConfigurationProperties ecloudConfigurationProperties) {
        DatasetDao datasetDao = new DatasetDao(morphiaDatastoreProvider, ecloudDataSetServiceClient);
        datasetDao.setDatasetsPerRequest(RequestLimits.DATASETS_PER_REQUEST.getLimit());
        datasetDao.setEcloudProvider(ecloudConfigurationProperties.getProvider());
        return datasetDao;
    }

    @Bean
    public DatasetXsltDao getXsltDao(MorphiaDatastoreProvider morphiaDatastoreProvider) {
        return new DatasetXsltDao(morphiaDatastoreProvider);
    }

    @Bean
    public DepublishRecordIdDao getDepublishedRecordDao(MorphiaDatastoreProvider morphiaDatastoreProvider, MetisCoreConfigurationProperties metisCoreConfigurationProperties) {
        return new DepublishRecordIdDao(morphiaDatastoreProvider, (long)metisCoreConfigurationProperties.getMaxDepublishRecordIdsPerDataset());
    }

    @Bean
    public DatasetService getDatasetService(DatasetDao datasetDao, DatasetXsltDao datasetXsltDao, WorkflowDao workflowDao, WorkflowExecutionDao workflowExecutionDao, ScheduledWorkflowDao scheduledWorkflowDao, RedissonClient redissonClient, Authorizer authorizer, MetisCoreConfigurationProperties metisCoreConfigurationProperties) {
        DatasetService datasetService = new DatasetService(datasetDao, datasetXsltDao, workflowDao, workflowExecutionDao, scheduledWorkflowDao, redissonClient, authorizer);
        datasetService.setMetisCoreUrl(metisCoreConfigurationProperties.getBaseUrl());
        return datasetService;
    }

    @Bean
    public DepublishRecordIdService getDepublishedRecordService(DepublishRecordIdDao depublishRecordIdDao, OrchestratorService orchestratorService, Authorizer authorizer) {
        return new DepublishRecordIdService(authorizer, orchestratorService, depublishRecordIdDao);
    }

    @PreDestroy
    public void close() {
        if (this.mongoClient != null) {
            this.mongoClient.close();
        }
    }

    @Bean
    public View json() {
        MappingJackson2JsonView view = new MappingJackson2JsonView();
        view.setPrettyPrint(true);
        view.setObjectMapper((ObjectMapper)new CustomObjectMapper());
        return view;
    }

    @Bean
    public ViewResolver viewResolver() {
        return new BeanNameViewResolver();
    }
}

