/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.metis.core.rest.config;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.mongodb.MongoClient;
import eu.europeana.cloud.mcs.driver.DataSetServiceClient;
import eu.europeana.metis.authentication.rest.client.AuthenticationClient;
import eu.europeana.metis.core.dao.DatasetDao;
import eu.europeana.metis.core.dao.DatasetXsltDao;
import eu.europeana.metis.core.dao.ScheduledWorkflowDao;
import eu.europeana.metis.core.dao.WorkflowDao;
import eu.europeana.metis.core.dao.WorkflowExecutionDao;
import eu.europeana.metis.core.mongo.MorphiaDatastoreProvider;
import eu.europeana.metis.core.mongo.MorphiaDatastoreProviderImpl;
import eu.europeana.metis.core.rest.RequestLimits;
import eu.europeana.metis.core.rest.config.ApplicationInitUtils;
import eu.europeana.metis.core.rest.config.ConfigurationPropertiesHolder;
import eu.europeana.metis.core.service.Authorizer;
import eu.europeana.metis.core.service.DatasetService;
import eu.europeana.metis.json.CustomObjectMapper;
import eu.europeana.metis.utils.CustomTruststoreAppender;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.List;
import javax.annotation.PreDestroy;
import org.redisson.api.RedissonClient;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.io.Resource;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.converter.StringHttpMessageConverter;
import org.springframework.http.converter.json.MappingJackson2HttpMessageConverter;
import org.springframework.http.converter.xml.MappingJackson2XmlHttpMessageConverter;
import org.springframework.web.servlet.View;
import org.springframework.web.servlet.ViewResolver;
import org.springframework.web.servlet.config.annotation.CorsRegistry;
import org.springframework.web.servlet.config.annotation.EnableWebMvc;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;
import org.springframework.web.servlet.view.BeanNameViewResolver;
import org.springframework.web.servlet.view.json.MappingJackson2JsonView;

@Configuration
@ComponentScan(basePackages={"eu.europeana.metis.core.rest"})
@EnableWebMvc
public class Application
implements WebMvcConfigurer {
    private final ConfigurationPropertiesHolder propertiesHolder;
    private final MongoClient mongoClient;
    @Value(value="classpath:default_transformation.xslt")
    private Resource defaultTransformation;

    @Autowired
    public Application(ConfigurationPropertiesHolder propertiesHolder) throws CustomTruststoreAppender.TrustStoreConfigurationException {
        this.propertiesHolder = propertiesHolder;
        this.mongoClient = ApplicationInitUtils.initializeApplication((ConfigurationPropertiesHolder)propertiesHolder);
    }

    public void addCorsMappings(CorsRegistry registry) {
        registry.addMapping("/**").allowedMethods(new String[]{"GET", "HEAD", "POST", "PUT", "DELETE", "OPTIONS"}).allowedOrigins(this.propertiesHolder.getAllowedCorsHosts());
    }

    @Bean
    AuthenticationClient getAuthenticationClient() {
        return new AuthenticationClient(this.propertiesHolder.getAuthenticationBaseUrl());
    }

    @Bean
    MorphiaDatastoreProvider getMorphiaDatastoreProvider() throws IOException {
        return new MorphiaDatastoreProviderImpl(this.mongoClient, this.propertiesHolder.getMongoDb(), () -> ((Resource)this.defaultTransformation).getInputStream());
    }

    @Bean
    Authorizer geAuthorizer(DatasetDao datasetDao) {
        return new Authorizer(datasetDao);
    }

    @Bean
    public DatasetDao getDatasetDao(MorphiaDatastoreProvider morphiaDatastoreProvider, DataSetServiceClient ecloudDataSetServiceClient) {
        DatasetDao datasetDao = new DatasetDao(morphiaDatastoreProvider, ecloudDataSetServiceClient);
        datasetDao.setDatasetsPerRequest(RequestLimits.DATASETS_PER_REQUEST.getLimit());
        datasetDao.setEcloudProvider(this.propertiesHolder.getEcloudProvider());
        return datasetDao;
    }

    @Bean
    public DatasetXsltDao getXsltDao(MorphiaDatastoreProvider morphiaDatastoreProvider) {
        return new DatasetXsltDao(morphiaDatastoreProvider);
    }

    @Bean
    public DatasetService getDatasetService(DatasetDao datasetDao, DatasetXsltDao datasetXsltDao, WorkflowDao workflowDao, WorkflowExecutionDao workflowExecutionDao, ScheduledWorkflowDao scheduledWorkflowDao, RedissonClient redissonClient, Authorizer authorizer) {
        DatasetService datasetService = new DatasetService(datasetDao, datasetXsltDao, workflowDao, workflowExecutionDao, scheduledWorkflowDao, redissonClient, authorizer);
        datasetService.setMetisCoreUrl(this.propertiesHolder.getMetisCoreBaseUrl());
        return datasetService;
    }

    @PreDestroy
    public void close() {
        if (this.mongoClient != null) {
            this.mongoClient.close();
        }
    }

    @Bean
    public View json() {
        MappingJackson2JsonView view = new MappingJackson2JsonView();
        view.setPrettyPrint(true);
        view.setObjectMapper((ObjectMapper)new CustomObjectMapper());
        return view;
    }

    @Bean
    public ViewResolver viewResolver() {
        return new BeanNameViewResolver();
    }

    public void configureMessageConverters(List<HttpMessageConverter<?>> converters) {
        converters.add((HttpMessageConverter<?>)new MappingJackson2HttpMessageConverter());
        converters.add((HttpMessageConverter<?>)new MappingJackson2XmlHttpMessageConverter());
        converters.add((HttpMessageConverter<?>)new StringHttpMessageConverter(StandardCharsets.UTF_8));
    }
}

