/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.metis.core.rest.config;

import com.rabbitmq.client.Channel;
import com.rabbitmq.client.Connection;
import com.rabbitmq.client.ConnectionFactory;
import com.rabbitmq.client.ExceptionHandler;
import com.rabbitmq.client.impl.ForgivingExceptionHandler;
import eu.europeana.cloud.client.dps.rest.DpsClient;
import eu.europeana.cloud.mcs.driver.DataSetServiceClient;
import eu.europeana.cloud.mcs.driver.FileServiceClient;
import eu.europeana.cloud.mcs.driver.RecordServiceClient;
import eu.europeana.metis.core.dao.DatasetDao;
import eu.europeana.metis.core.dao.DatasetXsltDao;
import eu.europeana.metis.core.dao.ScheduledWorkflowDao;
import eu.europeana.metis.core.dao.WorkflowDao;
import eu.europeana.metis.core.dao.WorkflowExecutionDao;
import eu.europeana.metis.core.dao.WorkflowUtils;
import eu.europeana.metis.core.execution.PersistenceProvider;
import eu.europeana.metis.core.execution.QueueConsumer;
import eu.europeana.metis.core.execution.SchedulerExecutor;
import eu.europeana.metis.core.execution.WorkflowExecutionMonitor;
import eu.europeana.metis.core.execution.WorkflowExecutionSettings;
import eu.europeana.metis.core.execution.WorkflowExecutorManager;
import eu.europeana.metis.core.mongo.MorphiaDatastoreProvider;
import eu.europeana.metis.core.rest.RequestLimits;
import eu.europeana.metis.core.rest.config.ConfigurationPropertiesHolder;
import eu.europeana.metis.core.service.Authorizer;
import eu.europeana.metis.core.service.OrchestratorService;
import eu.europeana.metis.core.service.ProxiesService;
import eu.europeana.metis.core.service.ScheduleWorkflowService;
import eu.europeana.metis.core.service.WorkflowExecutionFactory;
import eu.europeana.metis.exception.GenericMetisException;
import io.netty.util.ThreadDeathWatcher;
import io.netty.util.concurrent.FastThreadLocal;
import io.netty.util.internal.InternalThreadLocalMap;
import java.io.File;
import java.io.IOException;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.time.Duration;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.annotation.PreDestroy;
import org.apache.commons.lang3.StringUtils;
import org.redisson.Redisson;
import org.redisson.api.RedissonClient;
import org.redisson.config.Config;
import org.redisson.config.SingleServerConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.scheduling.annotation.EnableScheduling;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;

@Configuration
@ComponentScan(basePackages={"eu.europeana.metis.core.rest"})
@EnableScheduling
public class OrchestratorConfig
implements WebMvcConfigurer {
    private static final Logger LOGGER = LoggerFactory.getLogger(OrchestratorConfig.class);
    private static final int WAITING_TIME_FOR_THREAD_DEATH = 2;
    private final ConfigurationPropertiesHolder propertiesHolder;
    private SchedulerExecutor schedulerExecutor;
    private WorkflowExecutionMonitor workflowExecutionMonitor;
    private Connection connection;
    private Channel publisherChannel;
    private Channel consumerChannel;
    private RedissonClient redissonClient;

    @Autowired
    public OrchestratorConfig(ConfigurationPropertiesHolder propertiesHolder) {
        this.propertiesHolder = propertiesHolder;
    }

    @Bean
    Connection getConnection() throws KeyManagementException, NoSuchAlgorithmException, IOException, TimeoutException {
        ConnectionFactory connectionFactory = new ConnectionFactory();
        connectionFactory.setHost(this.propertiesHolder.getRabbitmqHost());
        connectionFactory.setPort(this.propertiesHolder.getRabbitmqPort());
        connectionFactory.setVirtualHost(StringUtils.isNotBlank((CharSequence)this.propertiesHolder.getRabbitmqVirtualHost()) ? this.propertiesHolder.getRabbitmqVirtualHost() : "/");
        connectionFactory.setUsername(this.propertiesHolder.getRabbitmqUsername());
        connectionFactory.setPassword(this.propertiesHolder.getRabbitmqPassword());
        connectionFactory.setAutomaticRecoveryEnabled(true);
        if (this.propertiesHolder.isRabbitmqEnableSSL()) {
            connectionFactory.useSslProtocol();
        }
        connectionFactory.setExceptionHandler((ExceptionHandler)new ForgivingExceptionHandler());
        this.connection = connectionFactory.newConnection();
        return this.connection;
    }

    @Bean(name={"rabbitmqPublisherChannel"})
    Channel getRabbitmqPublisherChannel(Connection connection) throws IOException {
        this.publisherChannel = connection.createChannel();
        this.setupChannelProperties(this.publisherChannel);
        return this.publisherChannel;
    }

    @Bean(name={"rabbitmqConsumerChannel"})
    Channel getRabbitmqConsumerChannel(Connection connection) throws IOException {
        this.consumerChannel = connection.createChannel();
        this.setupChannelProperties(this.consumerChannel);
        return this.consumerChannel;
    }

    private void setupChannelProperties(Channel channel) throws IOException {
        ConcurrentHashMap<String, Integer> args = new ConcurrentHashMap<String, Integer>();
        args.put("x-max-priority", this.propertiesHolder.getRabbitmqHighestPriority());
        channel.queueDeclare(this.propertiesHolder.getRabbitmqQueueName(), false, false, false, args);
    }

    @Bean
    RedissonClient getRedissonClient() {
        SingleServerConfig singleServerConfig;
        Config config = new Config();
        if (this.propertiesHolder.isRedisEnableSSL()) {
            singleServerConfig = config.useSingleServer().setAddress(String.format("rediss://%s:%s", this.propertiesHolder.getRedisHost(), this.propertiesHolder.getRedisPort()));
            if (this.propertiesHolder.isRedisEnableCustomTruststore()) {
                singleServerConfig.setSslTruststore(new File(this.propertiesHolder.getTruststorePath()).toURI());
                singleServerConfig.setSslTruststorePassword(this.propertiesHolder.getTruststorePassword());
            }
        } else {
            singleServerConfig = config.useSingleServer().setAddress(String.format("redis://%s:%s", this.propertiesHolder.getRedisHost(), this.propertiesHolder.getRedisPort()));
        }
        if (StringUtils.isNotEmpty((CharSequence)this.propertiesHolder.getRedisPassword())) {
            singleServerConfig.setPassword(this.propertiesHolder.getRedisPassword());
        }
        config.setLockWatchdogTimeout(TimeUnit.SECONDS.toMillis(this.propertiesHolder.getRedissonLockWatchdogTimeoutInSecs()));
        this.redissonClient = Redisson.create((Config)config);
        return this.redissonClient;
    }

    @Bean
    public OrchestratorService getOrchestratorService(WorkflowDao workflowDao, WorkflowExecutionDao workflowExecutionDao, WorkflowUtils workflowUtils, DatasetDao datasetDao, WorkflowExecutionFactory workflowExecutionFactory, WorkflowExecutorManager workflowExecutorManager, Authorizer authorizer) {
        OrchestratorService orchestratorService = new OrchestratorService(workflowExecutionFactory, workflowDao, workflowExecutionDao, workflowUtils, datasetDao, workflowExecutorManager, this.redissonClient, authorizer);
        orchestratorService.setSolrCommitPeriodInMins(this.propertiesHolder.getSolrCommitPeriodInMins());
        return orchestratorService;
    }

    @Bean
    public WorkflowExecutionFactory getWorkflowExecutionFactory(WorkflowExecutionDao workflowExecutionDao, WorkflowUtils workflowUtils, DatasetXsltDao datasetXsltDao) {
        WorkflowExecutionFactory workflowExecutionFactory = new WorkflowExecutionFactory(datasetXsltDao, workflowExecutionDao, workflowUtils);
        workflowExecutionFactory.setValidationExternalProperties(this.propertiesHolder.getValidationExternalProperties());
        workflowExecutionFactory.setValidationInternalProperties(this.propertiesHolder.getValidationInternalProperties());
        workflowExecutionFactory.setMetisUseAlternativeIndexingEnvironment(this.propertiesHolder.isMetisUseAlternativeIndexingEnvironment());
        workflowExecutionFactory.setDefaultSamplingSizeForLinkChecking(this.propertiesHolder.getMetisLinkCheckingDefaultSamplingSize());
        return workflowExecutionFactory;
    }

    @Bean
    public ScheduleWorkflowService getScheduleWorkflowService(ScheduledWorkflowDao scheduledWorkflowDao, WorkflowDao workflowDao, DatasetDao datasetDao, Authorizer authorizer) {
        return new ScheduleWorkflowService(scheduledWorkflowDao, workflowDao, datasetDao, authorizer);
    }

    @Bean
    public ProxiesService getProxiesService(WorkflowExecutionDao workflowExecutionDao, DataSetServiceClient ecloudDataSetServiceClient, RecordServiceClient recordServiceClient, FileServiceClient fileServiceClient, DpsClient dpsClient, Authorizer authorizer) {
        return new ProxiesService(workflowExecutionDao, ecloudDataSetServiceClient, recordServiceClient, fileServiceClient, dpsClient, this.propertiesHolder.getEcloudProvider(), authorizer);
    }

    @Bean
    public WorkflowExecutorManager getWorkflowExecutorManager(WorkflowExecutionDao workflowExecutionDao, @Qualifier(value="rabbitmqPublisherChannel") Channel rabbitmqPublisherChannel, @Qualifier(value="rabbitmqConsumerChannel") Channel rabbitmqConsumerChannel, RedissonClient redissonClient, DpsClient dpsClient) {
        WorkflowExecutorManager workflowExecutorManager = new WorkflowExecutorManager(workflowExecutionDao, rabbitmqPublisherChannel, rabbitmqConsumerChannel, redissonClient, dpsClient);
        workflowExecutorManager.setRabbitmqQueueName(this.propertiesHolder.getRabbitmqQueueName());
        workflowExecutorManager.setMaxConcurrentThreads(this.propertiesHolder.getMaxConcurrentThreads());
        workflowExecutorManager.setDpsMonitorCheckIntervalInSecs(this.propertiesHolder.getDpsMonitorCheckIntervalInSecs());
        workflowExecutorManager.setPollingTimeoutForCleaningCompletionServiceInSecs(this.propertiesHolder.getPollingTimeoutForCleaningCompletionServiceInSecs());
        workflowExecutorManager.setPeriodOfNoProcessedRecordsChangeInMinutes(this.propertiesHolder.getPeriodOfNoProcessedRecordsChangeInMinutes());
        workflowExecutorManager.setEcloudBaseUrl(this.propertiesHolder.getEcloudBaseUrl());
        workflowExecutorManager.setEcloudProvider(this.propertiesHolder.getEcloudProvider());
        workflowExecutorManager.setMetisCoreBaseUrl(this.propertiesHolder.getMetisCoreBaseUrl());
        return workflowExecutorManager;
    }

    @Bean
    public WorkflowExecutionDao getWorkflowExecutionDao(MorphiaDatastoreProvider morphiaDatastoreProvider) {
        WorkflowExecutionDao workflowExecutionDao = new WorkflowExecutionDao(morphiaDatastoreProvider);
        workflowExecutionDao.setWorkflowExecutionsPerRequest(RequestLimits.WORKFLOW_EXECUTIONS_PER_REQUEST.getLimit());
        workflowExecutionDao.setMaxServedExecutionListLength(this.propertiesHolder.getMaxServedExecutionListLength());
        return workflowExecutionDao;
    }

    @Bean
    WorkflowUtils getWorkflowUtils(WorkflowExecutionDao workflowExecutionDao) {
        return new WorkflowUtils(workflowExecutionDao);
    }

    @Bean
    public ScheduledWorkflowDao getScheduledWorkflowDao(MorphiaDatastoreProvider morphiaDatastoreProvider) {
        return new ScheduledWorkflowDao(morphiaDatastoreProvider);
    }

    @Bean
    public WorkflowDao getWorkflowDao(MorphiaDatastoreProvider morphiaDatastoreProvider) {
        return new WorkflowDao(morphiaDatastoreProvider);
    }

    @Bean
    public WorkflowExecutionMonitor getWorkflowExecutionMonitor(WorkflowExecutorManager workflowExecutorManager, WorkflowExecutionDao workflowExecutionDao, RedissonClient redissonClient) {
        Duration failsafeLeniency = Duration.ZERO.plusMillis(this.propertiesHolder.getDpsConnectTimeoutInMillisecs()).plusMillis(this.propertiesHolder.getDpsReadTimeoutInMillisecs()).plusMillis(this.propertiesHolder.getPeriodicFailsafeCheckInMillisecs()).plusSeconds(this.propertiesHolder.getDpsMonitorCheckIntervalInSecs()).plusSeconds(this.propertiesHolder.getFailsafeMarginOfInactivityInSecs());
        this.workflowExecutionMonitor = new WorkflowExecutionMonitor(workflowExecutorManager, workflowExecutionDao, redissonClient, failsafeLeniency);
        return this.workflowExecutionMonitor;
    }

    @Bean
    public SchedulerExecutor getSchedulingExecutor(OrchestratorService orchestratorService, ScheduleWorkflowService scheduleWorkflowService, RedissonClient redissonClient) {
        this.schedulerExecutor = new SchedulerExecutor(orchestratorService, scheduleWorkflowService, redissonClient);
        return this.schedulerExecutor;
    }

    @Bean
    public QueueConsumer getQueueConsumer(WorkflowExecutorManager workflowExecutionManager, WorkflowExecutionMonitor workflowExecutionMonitor, @Qualifier(value="rabbitmqConsumerChannel") Channel rabbitmqConsumerChannel) throws IOException {
        return new QueueConsumer(rabbitmqConsumerChannel, this.propertiesHolder.getRabbitmqQueueName(), (WorkflowExecutionSettings)workflowExecutionManager, (PersistenceProvider)workflowExecutionManager, workflowExecutionMonitor);
    }

    @Scheduled(fixedDelayString="${periodic.failsafe.check.in.millisecs}")
    public void runFailsafeExecutor() {
        LOGGER.info("Failsafe task started (runs every {} milliseconds).", (Object)this.propertiesHolder.getPeriodicFailsafeCheckInMillisecs());
        this.workflowExecutionMonitor.performFailsafe();
        LOGGER.info("Failsafe task finished.");
    }

    @Scheduled(fixedDelayString="${periodic.scheduler.check.in.millisecs}", initialDelayString="${periodic.scheduler.check.in.millisecs}")
    public void runSchedulingExecutor() {
        LOGGER.info("Scheduler task started (runs every {} milliseconds).", (Object)this.propertiesHolder.getPeriodicSchedulerCheckInMillisecs());
        this.schedulerExecutor.performScheduling();
        LOGGER.info("Scheduler task finished.");
    }

    @PreDestroy
    public void close() throws GenericMetisException {
        try {
            if (this.publisherChannel != null && this.publisherChannel.isOpen()) {
                this.publisherChannel.close();
            }
            if (this.consumerChannel != null && this.consumerChannel.isOpen()) {
                this.consumerChannel.close();
            }
            if (this.connection != null && this.connection.isOpen()) {
                this.connection.close();
            }
            if (this.redissonClient != null && !this.redissonClient.isShuttingDown()) {
                this.redissonClient.shutdown();
            }
            FastThreadLocal.removeAll();
            FastThreadLocal.destroy();
            InternalThreadLocalMap.remove();
            InternalThreadLocalMap.destroy();
            ThreadDeathWatcher.awaitInactivity((long)2L, (TimeUnit)TimeUnit.SECONDS);
        }
        catch (IOException | TimeoutException e) {
            throw new GenericMetisException("Could not shutdown resources properly.", (Throwable)e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new GenericMetisException("Could not shutdown resources properly.", (Throwable)e);
        }
    }
}

